/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractSpecialSLSession;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.tlp.ClientConnectionChannel;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.ConnectionStateHandler;
import com.streamscape.sef.network.tlp.PacketHandler;
import com.streamscape.sef.network.tlp.ServerConnectionChannel;
import com.streamscape.sef.network.tlp.impl.ConnectionFactoryImpl;
import com.streamscape.sef.network.tlp.impl.ConnectionImpl;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;

public class ActivatorNetworkConnection
extends ConnectionImpl {
    long sessionId = -1L;
    AbstractSpecialSLSession.ConnectReplyData connectData;
    JSerializer serializer;
    static final long DEFAULT_TIMEOUT = 5000L;
    static final int TYPE_SIZE = 1;
    static final int ID_SIZE = 8;

    protected ActivatorNetworkConnection(ConnectionFactoryImpl factory, ClientConnectionChannel clientChannel, ServerConnectionChannel serverChannel, ConnectionStateHandler stateHandler) throws FabricException {
        super(factory, clientChannel, serverChannel, stateHandler);
        try {
            this.serializer = JSerializerFactory.getInstance().getDefaultSerializer();
        }
        catch (Exception exception) {
            throw new FabricException("Initializing ActivatorNetworkConnection failed.", exception);
        }
    }

    public AbstractSpecialSLSession.ConnectReplyData connect(byte type, String componentName, String slSessionName, String userName, String password, boolean fromSlangTool) throws Exception {
        return this.connect(type, componentName, slSessionName, userName, password, -1L, fromSlangTool);
    }

    public AbstractSpecialSLSession.ConnectReplyData connect(byte type, String componentName, String slSessionName, String userName, String password, long pid, boolean fromSlangTool) throws Exception {
        this.connectData = (AbstractSpecialSLSession.ConnectReplyData)this.invokeRequest(type, new AbstractSpecialSLSession.ConnectRequestData(componentName, slSessionName, userName, this.createDigest(userName, password), pid, fromSlangTool));
        return this.connectData;
    }

    long getSessionId() {
        return this.sessionId;
    }

    void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public Object invokeRequest(byte type) throws Exception {
        return this.invokeRequest(type, null);
    }

    public Object invokeRequest(byte type, Object data) throws Exception {
        return this.invokeRequest(type, data, 5000L);
    }

    public Object invokeRequest(byte type, Object data, long timeout) throws Exception {
        byte[] reply = this.invokeRequest(type, data != null ? this.pack(data) : null, timeout);
        return reply != null ? this.unpack(reply) : null;
    }

    private byte[] invokeRequest(byte type, byte[] data, long timeout) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(1 + (data != null ? data.length : 0));
        buffer.put(type);
        if (data != null) {
            buffer.put(data);
        }
        return this.sendRequest(buffer.array(), timeout);
    }

    public byte[] invokeRoutedRequest(byte[] data, long timeout) throws FabricException, TimeoutException {
        return this.sendRequest(data, timeout);
    }

    public void sendMessage(byte[] data) throws Exception {
        this.send(data);
    }

    public void sendMessage(Object message) throws Exception {
        this.sendMessage(-1L, message);
    }

    public void sendMessage(long sessionId, Object message) throws Exception {
        byte[] messageBytes = this.pack(message);
        ByteBuffer buffer = ByteBuffer.allocate(8 + messageBytes.length);
        buffer.putLong(sessionId).put(messageBytes);
        this.send(buffer.array());
    }

    private byte[] pack(Object object) throws FabricException {
        try {
            return this.serializer.serialize(object);
        }
        catch (Exception exception) {
            throw new FabricException("Serialization of '" + object.getClass().toString() + "' failed.", exception);
        }
    }

    public Object unpack(ByteBuffer buffer) throws FabricException {
        if (buffer.hasRemaining()) {
            byte[] objectBytes = new byte[buffer.remaining()];
            buffer.get(objectBytes);
            return this.unpack(objectBytes);
        }
        return null;
    }

    public Object unpack(byte[] buffer) throws FabricException {
        try {
            return this.serializer.deserialize(buffer);
        }
        catch (Exception exception) {
            throw new FabricException("Deserialization of packet failed.", exception);
        }
    }

    public static class DefaultPacketHandler
    implements PacketHandler {
        ActivatorNetworkConnection connection;

        public DefaultPacketHandler(Connection connection) {
            this.connection = (ActivatorNetworkConnection)connection;
        }

        @Override
        public ByteBuffer onRequest(long requestId, byte[] bytes, long timeout) throws FabricException {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            byte type = buffer.get();
            Object reply = this.isBroadcastRequest(type) ? this.processBroadcastRequest(type, bytes, timeout) : this.processRequest(type, bytes, this.connection.unpack(buffer), timeout);
            return reply != null ? ByteBuffer.wrap(this.connection.pack(reply)) : null;
        }

        protected Object processRequest(byte type, byte[] bytes, Object data, long timeout) throws FabricException {
            return null;
        }

        protected Object processBroadcastRequest(byte type, byte[] bytes, long timeout) throws FabricException {
            return null;
        }

        private boolean isBroadcastRequest(byte type) {
            return type == 10 || type == 11;
        }

        @Override
        public void onPacket(byte[] bytes) {
        }

        protected byte[] getMessageBytes(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.getLong();
            byte[] result = new byte[buffer.remaining()];
            buffer.get(result);
            return result;
        }

        @Override
        public void onPublication(byte[] bytes) {
        }

        @Override
        public byte[] onPublicationRequest(byte[] bytes) throws FabricException {
            return null;
        }
    }

    public static class ConnectionFactory
    extends ConnectionFactoryImpl {
        public ConnectionFactory(ThreadPoolType requestThreadPoolType, int requestThreadPoolSize) {
            super(requestThreadPoolType, requestThreadPoolSize);
        }

        public ConnectionFactory(ConnectionStateHandler stateHandler, ThreadPoolType requestThreadPoolType, int requestThreadPoolSize) {
            super(stateHandler, requestThreadPoolType, requestThreadPoolSize);
        }

        @Override
        public ActivatorNetworkConnection createConnection(LinkAddress address, long timeout) throws FabricException {
            return (ActivatorNetworkConnection)super.createConnection(address, timeout);
        }

        @Override
        protected ConnectionImpl createConnection(ClientConnectionChannel clientChannel, ServerConnectionChannel serverChannel, ConnectionStateHandler stateHandler) throws FabricException {
            return new ActivatorNetworkConnection(this, clientChannel, serverChannel, stateHandler);
        }
    }
}

