/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.log.monitor.SimpleLogEventSourceResolver;
import com.streamscape.tools.mnode.activator.Activator;
import java.util.HashMap;
import java.util.Map;

class ActivatorLogEventSourceResolver
extends SimpleLogEventSourceResolver {
    private Activator activator;
    private Map<String, String> nodeLogs = new HashMap<String, String>();

    ActivatorLogEventSourceResolver(Activator activator) {
        this.activator = activator;
    }

    @Override
    public void prepare() {
        try {
            this.nodeLogs = (Map)this.activator.invokeMNodeRequest(1, null);
        }
        catch (Exception exception) {
            Trace.logException(LogMonitor.class, exception, false);
            Trace.logError(LogMonitor.class, "Obtaining log file paths from management node failed.");
        }
    }

    @Override
    protected Pair<String, Boolean> doResolve(LogEventSource source) {
        String logFilename;
        boolean changed = false;
        if ((Utils.equalsNullSafe(source.getSourceType(), FabricNodeRole.MANAGEMENT_NODE.name()) || Utils.equalsNullSafe(source.getSourceType(), FabricNodeRole.TASK_NODE.name())) && (logFilename = this.nodeLogs.get(source.getSourceName())) != null && (StringUtils.isEmpty(source.getLogFilename()) || !FileIOUtils.equals(source.getLogFilename(), logFilename))) {
            source.setLogFilename(logFilename);
            changed = true;
        }
        Pair<String, Boolean> result = super.doResolve(source);
        result.second = changed;
        return result;
    }
}

