/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.timer.AbstractFabricTimerTask;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerException;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.utils.Banner;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.JVM;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.Container;
import com.streamscape.sef.container.ContainerLockSupport;
import com.streamscape.sef.container.ContainerLoggerParameters;
import com.streamscape.sef.container.FabricContainer;
import com.streamscape.sef.dispatcher.AbstractActivator;
import com.streamscape.sef.dispatcher.AbstractSpecialSLSession;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.DefaultConnectionStateHandler;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptor;
import com.streamscape.sef.security.SHA1DigestCalculator;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.sef.trace.TraceRecord;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.tools.log.monitor.LogEventForwarderConfiguration;
import com.streamscape.tools.log.monitor.LogEventLocalForwarder;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.log.monitor.LogMonitorFactory;
import com.streamscape.tools.mnode.MNodeContainer;
import com.streamscape.tools.mnode.MNodeContainerFactory;
import com.streamscape.tools.mnode.Utils;
import com.streamscape.tools.mnode.activator.ActivatorLexiconProcessor;
import com.streamscape.tools.mnode.activator.ActivatorLogEventSourceResolver;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import com.streamscape.tools.mnode.activator.ActivatorNetworkConnection;
import com.streamscape.tools.mnode.activator.ActivatorSLSessionImpl;
import com.streamscape.tools.mnode.activator.ImageManifest;
import com.streamscape.tools.mnode.activator.UpgradeOperation;
import com.streamscape.tools.mnode.activator.Version;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public class Activator
extends AbstractActivator
implements FabricContainer,
DSLComponent<Activator>,
LogEventLocalForwarder,
SLCallable {
    static final String JAVA_EXE_PARAMETER = "-java-exe";
    static final String URL_PARAMETER = "-url";
    static final String NO_MNODE_PARAMETER = "-no-mnode";
    static final String MNODE_JAR_PATH_PARAMETER = "-mnode-jar-path";
    static final String UPGRADE_MODE_PARAMETER = "-upgrade-mode";
    public static final String DEFAULT_URL = "tlp://localhost:6666";
    private Launcher launcher;
    private CtxDeploymentDescriptor ctxDescriptor;
    private User user;
    private TLPAcceptor acceptor;
    private ActivatorNetworkConnection mnodeConnection;
    private final Map<Long, ActivatorNetworkConnection> connections = new ConcurrentHashMap<Long, ActivatorNetworkConnection>();
    private final LongNumberAllocatorSimple sessionIdAllocator = new LongNumberAllocatorSimple();
    private ActivatorLexiconProcessor lexiconProcessor;
    private Process mnodeProcess;
    private long mnodePid = -1L;
    private String mnodeError;
    private ShutdownMode shutdownMode = ShutdownMode.NONE;
    private ShutdownWaiter shutdownWaiter;
    private LogMonitorFactory logMonitorFactory;
    private LogMonitor logMonitor;
    private volatile boolean logMonitorAutoInitialized = false;
    private Map<String, String> nodeLogPaths = new HashMap<String, String>();
    private static final byte[] EMPTY_BUFFER = new byte[1024];
    private static final String ROOT_DIR = ".activator";
    private static final String LOG_MONITOR_DIR = ".activator/lm";
    private static final String UPGRADE_DIR = ".activator/dist";
    private final Object MONITOR_MUTEX = new Object();
    private static final String FCS_PREFIX = "STRuntime_FCS_";
    private static final String WIN_SUFFIX = "_win";
    private static final String LIN_SUFFIX = "_lin";
    private static final String MAC_SUFFIX = "_mac";
    private static final String SLR_SUFFIX = "_slr";
    private static final String WIN_EXT = ".zip";
    private static final String GZIP_EXT = ".gz";
    private static final String LIN_EXT = ".tar.gz";
    private static final String MAC_EXT = ".tar.gz";
    private static final String SLR_EXT = ".tar.gz";
    private static final String LIN_TAR_EXT = ".tar";
    private static final String MAC_TAR_EXT = ".tar";
    private static final String SLR_TAR_EXT = ".tar";
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
    public static final byte MNODE_CONNECT = 1;
    public static final byte CLIENT_CONNECT = 2;
    public static final byte RESTART_MNODE = 3;
    public static final byte SHUTDOWN_ALL = 4;
    public static final byte START_TNODE = 5;
    public static final byte IMPORT_FILE = 6;
    public static final byte EXPORT_FILE = 7;
    public static final byte COMMAND = 8;
    public static final byte REQUEST = 9;
    public static final byte BROADCAST_COMMAND = 10;
    public static final byte BROADCAST_REQUEST = 11;
    public static final byte OPEN_FILE_RAISER = 12;
    public static final byte CLOSE_FILE_RAISER = 13;
    public static final int GET_NODE_LOGS = 1;
    public static final int UPLOAD_IMAGE = 2;
    public static final int GET_START_TNODES_TIMEOUT = 3;
    public static final int START_TNODES = 4;
    public static final int STOP_TNODES = 5;
    public static final int JOIN_SYSPLEX = 6;
    public static final int GET_TNODE_NAMES = 7;
    public static final int CHECK_TNODES = 8;
    public static final int STOP_MNODES = 9;
    public static final int LIST_NODES = 10;
    public static final int GET_MNODE_NAMES = 11;
    public static final int CREATE_CLUSTER = 12;
    public static final int DROP_CLUSTER = 13;
    public static final int RESTART_TNODES = 14;

    public static void main(String[] args) {
        new Launcher().launch(args);
    }

    private Activator(Launcher launcher, CtxDeploymentDescriptor ctxDescriptor, String url, boolean initShutdownInitiator) throws Exception {
        this.launcher = launcher;
        this.ctxDescriptor = ctxDescriptor;
        this.initUser();
        this.initAcceptor(this.initURL(url));
        this.initDSLProcessor();
        this.initStorage();
        this.logMonitorFactory = new LogMonitorFactory(LOG_MONITOR_DIR, this.getDomain(), ctxDescriptor.getContextName());
        Runtime.getRuntime().addShutdownHook(new ShutdownHandler());
        if (initShutdownInitiator) {
            this.initShutdownInitiator();
        }
    }

    private void initUser() throws Exception {
        this.user = this.getUser(this.ctxDescriptor.getSecurityPrincipal(), this.ctxDescriptor.getSecurityCredentials());
        Activator.logInfo("Runtime user is '" + String.valueOf(this.user.getName()) + "'.");
    }

    private String initURL(String userUrl) throws Exception {
        String url;
        if (userUrl == null) {
            url = this.getURLFromRepository();
            if (url == null) {
                Activator.logInfo("WARNING: Impossible to obtain URL for TLP acceptor from repository.");
                Activator.logInfo("Default URL for TLP acceptor will be used.");
                url = DEFAULT_URL;
            }
        } else {
            Activator.logInfo("Parameter '-url' will be used to set URL for TLP acceptor.");
            url = userUrl;
        }
        url = Activator.formatURL(url);
        Activator.logInfo("URL for TLP acceptor is '" + url + "'.");
        return url;
    }

    private String getURLFromRepository() {
        File containerFile = new File(new File("."), ".tfcache/objects/sys/container/Container.xdo");
        try {
            MNodeContainer container;
            if (!this.isMnodeStarted() && containerFile.exists() && (container = this.getMNodeContainer(containerFile)) != null && container.getActivatorURL() != null) {
                Activator.logInfo("URL for TLP acceptor obtained from repository.");
                return container.getActivatorURL();
            }
        }
        catch (Exception exception) {
            Activator.logException((Throwable)exception, false);
            Activator.logError("Reading file '" + String.valueOf(containerFile) + "' failed.");
        }
        return null;
    }

    private MNodeContainer getMNodeContainer(final File containerFile) throws Exception {
        return (MNodeContainer)new MNodeContainerFactory(null){

            @Override
            protected void addSemanticTypesAndAliases() throws Exception {
                super.addSemanticTypesAndAliases();
                Activator.this.realias("Container", MNodeContainer.class);
            }

            @Override
            protected MNodeContainer doCreate() throws FabricException {
                return (MNodeContainer)Utils.readObjectFromXML(containerFile.getAbsolutePath());
            }
        }.create();
    }

    private static String formatURL(String url) {
        return url.contains("://") ? url : FabricConnection.URL_PREFIX + url;
    }

    private void initAcceptor(String url) {
        this.acceptor = new TLPAcceptor();
        this.acceptor.setURL(url);
        this.acceptor.setConnectionFactory(new ActivatorNetworkConnection.ConnectionFactory(new ConnectionStateHandlerImpl(), ThreadPoolType.DYNAMIC, 10));
    }

    private void initDSLProcessor() {
        this.lexiconProcessor = new ActivatorLexiconProcessor(this);
        Activator.logInfo("DSL Processor initialized.");
    }

    private void initShutdownInitiator() {
        new Container.StdinShutdownInitiator(){

            @Override
            protected void doShutdown(String command) {
                Activator.this.sendShutdown();
                super.doShutdown(command);
            }

            @Override
            protected void processOtherCommand(String command) {
                if (command.equals("shutdown activator")) {
                    super.doShutdown(command);
                }
            }
        }.start();
        Activator.logInfo("Stdin Shutdown Initiator enabled.");
    }

    void shutdown(boolean all) {
        if (all) {
            this.sendShutdown();
        }
        MNodeContainer.doShutdown(Activator.class, "shutdown" + (all ? " all" : ""));
    }

    void startProcessInExtractMode(UpgradeOperation.Definition definition) throws Exception {
        this.launcher.startProcessInExtractMode(definition);
    }

    private void start(boolean noMnode) throws Exception {
        Activator.logInfo("Starting Activator...");
        this.acceptor.start();
        if (!noMnode) {
            this.startMnodeWithoutException(true);
        }
        this.initLogMonitor();
        Activator.logInfo("Activator started.");
    }

    private void restart(long timeout) throws Exception {
        Activator.logInfo("Restarting Activator...");
        this.acceptor.start();
        this.initLogMonitor();
        this.launchMnode(timeout);
        this.joinSysplex(timeout);
        Activator.logInfo("Activator restarted.");
    }

    private void launchMnode(long timeout) throws Exception {
        this.launcher.writeInLog("\n\nLaunching Management Node...");
        this.startMnodeForUpgrade(timeout * 1000L);
        this.launcher.writeInLog(" OK");
    }

    private void joinSysplex(long timeout) throws Exception {
        Activator.logInfo("Joining sysplex...");
        this.launcher.writeInLog("\n\nJoining Sysplex...");
        Utils.sleep(5000L);
        this.invokeMNodeRequest(6, null, timeout * 1000L);
        this.launcher.writeInLog(" OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Activator.logInfo("Stopping Activator.");
        try {
            if (this.logMonitor != null) {
                this.doStopLogMonitor();
            }
            Map<Long, ActivatorNetworkConnection> map = this.connections;
            synchronized (map) {
                this.connections.values().forEach(connection -> connection.close(true));
                this.connections.clear();
            }
            this.mnodeConnection = null;
            if (this.acceptor != null) {
                this.acceptor.stop();
            }
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
        Activator.logInfo("Activator stopped.");
    }

    @Override
    public String getType() {
        return "Activator";
    }

    @Override
    public Activator getCallable() {
        return this;
    }

    String getDomain() {
        return this.ctxDescriptor.getReferral();
    }

    String getNodeName() {
        return this.ctxDescriptor.getContextName();
    }

    String getUserName() {
        return this.ctxDescriptor.getSecurityPrincipal();
    }

    long getMnodePid() {
        return this.mnodePid;
    }

    String getMnodeError() {
        return this.mnodeError;
    }

    String getAccessPoint() {
        return this.acceptor != null ? this.acceptor.getAddress().toString() : "n/a";
    }

    @Override
    public ContainerLoggerParameters getLoggerParameters() {
        return null;
    }

    @Override
    public void printBanner(PrintStream stream) {
        this.launcher.printBanner(stream);
    }

    private void startMnodeWithoutException(boolean ignoreAlreadyStarted) {
        try {
            this.startMnode(ignoreAlreadyStarted, 20000L);
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
    }

    void startMnode(boolean ignoreAlreadyStarted, long timeout) throws Exception {
        if (!this.isMnodeStarted()) {
            this.doStartMnode(this.launcher.makeMnodeArgs(), timeout);
        } else if (ignoreAlreadyStarted) {
            Activator.logInfo("Management Node is already started.");
        } else {
            throw new FabricException("Management Node is already running.");
        }
    }

    void startMnodeForUpgrade(long timeout) throws Exception {
        ArrayList<String> args = new ArrayList<String>(this.launcher.makeMnodeArgs());
        args.add("-no-join");
        args.add("-no-auto-start");
        this.doStartMnode(args, timeout);
    }

    private void doStartMnode(List<String> args, long timeout) throws Exception {
        try {
            Activator.logInfo("Starting Management Node...");
            this.startMnodeProcess(args);
            this.waitForMnodeConnection(timeout);
            this.mnodeError = null;
        }
        catch (Exception exception) {
            this.mnodeError = Utils.formatException(exception, "\n");
            throw exception;
        }
    }

    private void waitForMnodeConnection(long timeout) throws Exception {
        long endTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < endTime && this.mnodeConnection == null) {
            Utils.sleep(1000L);
        }
        if (this.mnodeConnection == null) {
            throw new FabricException("Establishing connection with Management Node failed. Cause: Timeout expired.");
        }
    }

    private void startMnodeProcess(List<String> args) throws Exception {
        Activator.logInfo(args.toString());
        Pair<Object, Object> error = new Pair<Object, Object>(null, null);
        this.mnodeProcess = Utils.startProcessAsChild(args.toArray(new String[0]), error);
        if (!this.mnodeProcess.isAlive()) {
            if (error.first != null) {
                throw new FabricException("Starting Management Node failed.", (Throwable)error.first);
            }
            throw new FabricException("Starting Management Node failed.");
        }
        Activator.logInfo("Management Node started.");
    }

    void stopMnode(boolean force, long timeout) throws FabricException {
        if (!this.isMnodeStarted()) {
            throw new FabricException("Management Node is not running.");
        }
        this.shutdownMnodeWithWait(force, timeout);
    }

    void shutdownMnodeWithWait(boolean force, long timeout) throws FabricException {
        if (this.isMnodeStarted()) {
            if (force) {
                if (!this.killMnode()) {
                    throw new FabricException("Process of Management Node is not available.");
                }
                this.waitForMnodeShutdown(timeout);
            } else {
                this.sendShutdown();
                this.waitForMnodeShutdown(timeout / 2L);
                if (this.isMnodeStarted()) {
                    this.killMnode();
                    this.waitForMnodeShutdown(timeout / 2L);
                }
            }
            if (this.isMnodeStarted()) {
                throw new FabricException("Shutting down Management Node failed.");
            }
        }
    }

    private boolean killMnode() throws FabricException {
        try {
            if (this.mnodePid != -1L) {
                Utils.killProcess(this.mnodePid);
                return true;
            }
            if (this.mnodeProcess != null) {
                this.mnodeProcess.destroyForcibly();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new FabricException("Killing process of Management Node failed.", exception);
        }
    }

    private void waitForMnodeShutdown(long timeout) {
        long endTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < endTime && this.isMnodeStarted()) {
            Utils.sleep(1000L);
        }
    }

    boolean isMnodeStarted() {
        try {
            return ContainerLockSupport.getRemoteNodeLock("./").isLockedByAnotherVM();
        }
        catch (IOException exception) {
            return false;
        }
    }

    boolean isMnodeConnected() {
        return this.mnodeConnection != null && this.mnodeConnection.isOpened();
    }

    private void sendShutdown() {
        try {
            if (this.mnodeConnection != null) {
                this.invokeRequest((byte)4);
            }
        }
        catch (Exception exception) {
            Activator.logException((Throwable)exception, "Sending command to Management Node failed.");
        }
    }

    List<String> getTnodeNames() throws Exception {
        return (List)this.invokeMNodeRequest(7, null);
    }

    List<String> getMnodeNames() throws Exception {
        return (List)this.invokeMNodeRequest(11, null);
    }

    void initStorage() throws FabricException {
        try {
            Activator.logInfo("Initializing file storage...");
            Activator.checkDir(FileIOUtils.newFileDir(ROOT_DIR));
            Activator.checkDir(FileIOUtils.newFileDir(LOG_MONITOR_DIR));
            Activator.checkDir(FileIOUtils.newFileDir(UPGRADE_DIR));
            Activator.logInfo("File storage initialized.");
        }
        catch (Exception exception) {
            throw new FabricException("Initializing file storage failed.", exception);
        }
    }

    private static void checkDir(File dir) throws FabricException {
        if (!dir.exists()) {
            throw new FabricException("Directory '" + dir.getAbsolutePath() + "' does not exist.");
        }
    }

    LogMonitor getLogMonitor() {
        return this.logMonitor;
    }

    private void initLogMonitor() {
        try {
            FabricTimerManager.getInstance().createTimer("LogMonitor", "AutoInit", new AbstractFabricTimerTask(){

                @Override
                public void execute(FabricTimer timer) {
                    Activator.this.autoInitLogMonitor();
                }
            }, 10000L, 1).start();
        }
        catch (FabricTimerException exception) {
            Activator.logException((Throwable)exception, "Auto-starting Log Monitor failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoInitLogMonitor() {
        Object object = this.MONITOR_MUTEX;
        synchronized (object) {
            if (!this.logMonitorAutoInitialized) {
                FabricThreadManager.getInstance().createThread("FSYS:LogMonitor.AutoInit", "Initializes and auto-starts Log Monitor.", () -> {
                    Utils.sleep(500L);
                    this.doAutoInitLogMonitor();
                }).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAutoInitLogMonitor() {
        if (!this.logMonitorAutoInitialized) {
            Object object = this.MONITOR_MUTEX;
            synchronized (object) {
                if (!this.logMonitorAutoInitialized) {
                    try {
                        if (this.logMonitor == null) {
                            this.loadLogMonitor();
                        }
                    }
                    catch (Throwable exception) {
                        Activator.logException(exception.getCause() != null ? exception.getCause() : exception, "Loading Log Monitor failed.");
                    }
                    try {
                        if (this.logMonitor != null && this.logMonitor.isAutoStart()) {
                            Activator.logInfo("Auto-starting Log Monitor...");
                            this.logMonitor.start();
                            Activator.logInfo("Log Monitor started.");
                        }
                    }
                    catch (Throwable exception) {
                        Activator.logException(exception, "Starting Log Monitor failed.");
                    }
                    this.logMonitorAutoInitialized = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startLogMonitor() throws FabricException {
        Object object = this.MONITOR_MUTEX;
        synchronized (object) {
            try {
                Activator.logInfo("Starting Log Monitor...");
                if (this.logMonitor != null && this.logMonitor.isStarted()) {
                    throw new FabricException("Log Monitor is already running.");
                }
                if (this.logMonitor == null) {
                    this.loadLogMonitor();
                }
                this.checkLogMonitor();
                LogEventForwarderConfiguration configuration = this.logMonitor.getForwarderConfiguration();
                if (configuration == null) {
                    throw new FabricException("Log Event Forwarder is not configured.");
                }
                if (this.checkName(configuration)) {
                    this.logMonitor.setForwarderConfiguration(configuration);
                }
                this.logMonitor.start();
                Activator.logInfo("Log Monitor started.");
            }
            catch (FabricException exception) {
                Activator.logException(exception, "Starting Log Monitor failed.", false);
                throw exception;
            }
        }
    }

    private void loadLogMonitor() throws FabricException {
        Activator.logInfo("Loading Log Monitor...");
        try {
            this.logMonitor = this.logMonitorFactory.create();
            this.logMonitor.setLocalForwarder(this);
            this.logMonitor.setSourceResolver(new ActivatorLogEventSourceResolver(this));
            this.logMonitor.init();
        }
        catch (Exception exception) {
            throw new FabricException("Loading Log Monitor failed.", exception);
        }
        Activator.logInfo("Log Monitor loaded.");
    }

    boolean checkName(LogEventForwarderConfiguration configuration) {
        if (!configuration.hasName()) {
            configuration.setName(this.getLogMonitorName());
            return true;
        }
        return false;
    }

    String getLogMonitorName() {
        return this.getDomain() + "-" + this.getNodeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopLogMonitor() throws FabricException {
        Object object = this.MONITOR_MUTEX;
        synchronized (object) {
            try {
                this.checkLogMonitor();
                if (!this.logMonitor.isStarted()) {
                    throw new FabricException("Log Monitor is not running.");
                }
                this.doStopLogMonitor();
            }
            catch (FabricException exception) {
                Activator.logException(exception, "Stopping Log Monitor failed.", false);
                throw exception;
            }
        }
    }

    private void doStopLogMonitor() throws FabricException {
        Activator.logInfo("Stopping Log Monitor...");
        this.logMonitor.stop();
        Activator.logInfo("Log Monitor stopped.");
    }

    @Override
    public void raiseLogEvent(MapEvent event, EventScope eventScope) throws Exception {
        this.raiseEvent(event, eventScope);
    }

    @Override
    public void raiseLogEvent(LogEventSource source, TraceRecord trace, EventScope eventScope) throws Exception {
        if (this.hasConnection()) {
            this.mnodeConnection.sendMessage(new LogEventData(source, trace, eventScope));
        }
    }

    private void checkLogMonitor() throws FabricException {
        if (this.logMonitor == null) {
            throw new FabricException("Log Monitor is not loaded.");
        }
    }

    static OS getOS() {
        if (JVM.isWindowsOS()) {
            return OS.WIN;
        }
        if (JVM.isMacOS()) {
            return OS.MAC;
        }
        if (JVM.isSolarisOS()) {
            return OS.SLR;
        }
        return OS.LIN;
    }

    static String makeFullFilename(String filename) {
        if (JVM.isWindowsOS()) {
            return filename + "_win.zip";
        }
        if (JVM.isMacOS()) {
            return filename + "_mac.tar.gz";
        }
        if (JVM.isSolarisOS()) {
            return filename + "_slr.tar.gz";
        }
        return filename + "_lin.tar.gz";
    }

    static String makeImageFullFilename(String version) {
        return FCS_PREFIX + Activator.makeFullFilename(version);
    }

    static String makeImageFilename(String version) {
        return Activator.makeImageFilename(version, Activator.getOS());
    }

    static String makeImageFilename(String version, OS os) {
        String prefix = FCS_PREFIX + version;
        switch (os.ordinal()) {
            case 0: {
                return prefix + "_win.zip";
            }
            case 1: {
                return prefix + "_lin.tar";
            }
            case 2: {
                return prefix + "_mac.tar";
            }
            case 3: {
                return prefix + "_slr.tar";
            }
        }
        throw new RuntimeException("Invalid OS!");
    }

    static void checkImageFullFileExtension(String filename) throws FabricException {
        if (JVM.isWindowsOS() && !filename.endsWith(WIN_EXT) || !JVM.isWindowsOS() && !Activator.isUnixImage(".tar.gz")) {
            throw new FabricException("Image file extension does not match Operating System.");
        }
    }

    static boolean isUnixImage(String filename) {
        return filename.endsWith(".tar.gz");
    }

    static String extractUnixImageName(String filename) {
        return filename.substring(0, filename.length() - GZIP_EXT.length());
    }

    public static void completeImage(String version) throws FabricException {
        Activator.completeImage(version, new File(Activator.getImageDir(version), Activator.makeImageFilename(version)), true);
    }

    static ImageManifest completeImage(String version, File rawImageFile, boolean deleteRawImage) throws FabricException {
        Map manifestValues = null;
        if (version == null) {
            rawImageFile = Activator.decompressImage(rawImageFile, deleteRawImage);
            Pair<String, Map<String, String>> tmp = Activator.getVersion(rawImageFile);
            version = (String)tmp.first;
            manifestValues = (Map)tmp.second;
            File imageDir = Activator.getImageDir(version);
            boolean isNewDir = imageDir.mkdirs();
            try {
                FileIOUtils.move(rawImageFile, new File(imageDir, Activator.makeImageFilename(version)));
            }
            catch (Exception exception) {
                if (isNewDir) {
                    FileIOUtils.deleteFileDir(imageDir);
                }
                throw new FabricException("Moving image to local storage failed.", exception);
            }
        }
        Activator.logInfo("Image '" + Activator.makeImageFilename(version) + "' saved to storage.");
        return Activator.generateImageManifest(version, true, manifestValues);
    }

    private static File decompressImage(File rawImageFile, boolean deleteRawImage) throws FabricException {
        try {
            if (Activator.isUnixImage(rawImageFile.getName())) {
                File imageFile = new File(rawImageFile.getParentFile().getAbsolutePath(), Activator.extractUnixImageName(rawImageFile.getName()));
                try (GZIPInputStream inStream = new GZIPInputStream(new FileInputStream(rawImageFile));
                     FileOutputStream outStream = new FileOutputStream(imageFile);){
                    FileIOUtils.copy((InputStream)inStream, (OutputStream)outStream);
                }
                if (deleteRawImage) {
                    rawImageFile.delete();
                }
                return imageFile;
            }
            return rawImageFile;
        }
        catch (Exception exception) {
            throw new FabricException("Decompression of image failed.", exception);
        }
    }

    private static Pair<String, Map<String, String>> getVersion(File imageFile) throws FabricException {
        Map<String, String> values = Activator.getImageManifestValues(imageFile.getAbsolutePath());
        if (!(values != null && values.containsKey("Version") && values.containsKey("Build") && values.containsKey("JDK"))) {
            throw new FabricException("Extraction of version from image failed.");
        }
        return new Pair<CallSite, Map<String, String>>((CallSite)((Object)(values.get("Version") + "." + values.get("Build") + "_jdk" + Activator.getJDK(values))), values);
    }

    private static String getJDK(Map<String, String> values) {
        String jdk = values.get("JDK");
        int dotIndex = jdk.indexOf(46);
        return dotIndex != -1 ? jdk.substring(dotIndex + 1) : jdk;
    }

    void dropImage(String version) throws FabricException {
        File dir = new File(UPGRADE_DIR, version);
        if (!dir.exists()) {
            throw new FabricException("Image not found in depot.");
        }
        if (!FileIOUtils.deleteFileDir(dir)) {
            throw new FabricException("Deleting image failed.");
        }
        Activator.logInfo("Image '" + version + "' dropped.");
    }

    List<String> listImageVersions() {
        return Arrays.stream(new File(UPGRADE_DIR).listFiles()).filter(File::isDirectory).map(File::getName).collect(Collectors.toList());
    }

    public static File getImageDir(String version) {
        return new File(UPGRADE_DIR, version);
    }

    public static File getImageFile(String version) {
        return new File(Activator.getImageDir(version), Activator.makeImageFilename(version));
    }

    static File getImageFile(String version, OS os) {
        return new File(Activator.getImageDir(version), Activator.makeImageFilename(version, os));
    }

    static FrmFileReader getImageReader(String filename) throws Exception {
        return new FrmFileReader(new FileInputStream(filename), filename.endsWith(WIN_EXT));
    }

    static ImageManifest getImageManifest(String version) {
        File manifestFile = Activator.getImageManifestFile(version);
        if (!manifestFile.exists()) {
            Activator.generateImageManifest(version, false);
        }
        try {
            ImageManifest manifest = (ImageManifest)Utils.readObjectFromXML(manifestFile.getAbsolutePath());
            manifest.setValid();
            return manifest;
        }
        catch (FabricException exception) {
            Activator.logException(exception.getCause() instanceof FileNotFoundException ? new FabricException(exception.getMessage()) : exception, "Obtaining image manifest for '" + version + "' failed.", false);
            return new ImageManifest();
        }
    }

    private static ImageManifest generateImageManifest(String version, boolean addImportDate) {
        return Activator.generateImageManifest(version, addImportDate, null);
    }

    private static ImageManifest generateImageManifest(String version, boolean addImportDate, Map<String, String> manifestValues) {
        ImageManifest manifest = new ImageManifest();
        File imageFile = Activator.getImageFile(version);
        if (imageFile.exists()) {
            if (manifestValues == null && (manifestValues = Activator.getImageManifestValues(imageFile.getAbsolutePath())) == null) {
                return null;
            }
            for (Map.Entry<String, String> entry : manifestValues.entrySet()) {
                if (entry.getKey().equals("ReleaseDate")) {
                    manifest.addProperty(entry.getKey(), Activator.convertDateValue(entry.getValue()));
                    continue;
                }
                manifest.addProperty(entry.getKey(), entry.getValue());
            }
            manifest.addProperty("Name", version);
            manifest.addProperty("Archive", imageFile.getName());
            if (addImportDate) {
                manifest.addProperty("ImportDate", DATE_FORMAT.format(new Date()));
            }
            manifest.setValid();
        }
        try {
            Utils.writeObjectToXML(manifest, Activator.getImageManifestFile(version).getAbsolutePath());
            Activator.logInfo("Image manifest generated for '" + version + "'.");
        }
        catch (FabricException exception) {
            Activator.logException(exception, "Generating image manifest for '" + version + "' failed.", false);
        }
        return manifest;
    }

    private static File getImageManifestFile(String version) {
        return new File(Activator.getImageDir(version), "ImageManifest.xdo");
    }

    private static Map<String, String> getImageManifestValues(String filename) {
        HashMap<String, String> result = new HashMap<String, String>();
        try (FrmFileReader frmReader = Activator.getImageReader(filename);
             BufferedReader manifestReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(frmReader.getFile("Image.mf"))));){
            while (manifestReader.ready()) {
                List<String> tokens;
                String line = manifestReader.readLine().trim();
                if (line.startsWith("#") || line.isEmpty() || (tokens = StringUtils.split(line, '=')).size() != 2) continue;
                result.put(tokens.get(0), tokens.get(1));
            }
        }
        catch (Exception exception) {
            Activator.logException((Throwable)exception, false);
            return null;
        }
        return result;
    }

    private static String convertDateValue(String value) {
        try {
            if (value != null) {
                return DATE_FORMAT.format(new Date(Long.parseLong(value)));
            }
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
        return "";
    }

    static void extractImage(File imageFile, File targetDir, FileWriter logWriter) throws IOException {
        boolean isWindows = imageFile.getName().endsWith(WIN_EXT);
        try (FrmFileReader reader = new FrmFileReader(new FileInputStream(imageFile), isWindows);){
            HashSet<String> excludedPaths = new HashSet<String>();
            excludedPaths.add("platform/jre");
            reader.extractTo(targetDir, excludedPaths, logWriter);
        }
    }

    static File getUpgradeLogFile(String version) {
        return new File(Activator.getImageDir(version), "Upgrade.log");
    }

    Object invokeRequest(byte type) throws Exception {
        this.checkConnection();
        return this.mnodeConnection.invokeRequest(type);
    }

    Object invokeRequest(byte type, Object data) throws Exception {
        this.checkConnection();
        return this.mnodeConnection.invokeRequest(type, data);
    }

    Object invokeRequest(byte type, Object data, long timeout) throws Exception {
        this.checkConnection();
        return this.mnodeConnection.invokeRequest(type, data, timeout);
    }

    Object invokeCommand(Object data, long timeout) throws Exception {
        return this.mnodeConnection.unpack((byte[])this.invokeRequest((byte)8, data, timeout));
    }

    Map<String, Object> invokeBroadcastCommand(Object data, long timeout) throws Exception {
        Map response = (Map)this.invokeRequest((byte)10, data, timeout);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (response != null) {
            for (Map.Entry entry : response.entrySet()) {
                result.put((String)entry.getKey(), this.mnodeConnection.unpack((byte[])entry.getValue()));
            }
        }
        return result;
    }

    Object invokeMNodeRequest(int requestId, Object data) throws Exception {
        return this.invokeMNodeRequest(requestId, data, 5000L);
    }

    Object invokeMNodeRequest(int requestId, Object data, long timeout) throws Exception {
        this.checkConnection();
        return this.mnodeConnection.invokeRequest((byte)9, new MNodeRequestData(requestId, data), timeout);
    }

    void raiseEvent(ImmutableEventDatagram event, EventScope eventScope) throws Exception {
        if (this.hasConnection()) {
            this.mnodeConnection.sendMessage(new EventData(event, eventScope));
        }
    }

    protected void raiseSLMessage(SLMessage message, ActivatorMFSession session) {
        this.doRaiseSLMessage(message, session);
    }

    protected void raiseSLMessage(String text, ActivatorMFSession session) {
        this.doRaiseSLMessage(text, true, session);
    }

    protected void raiseSLMessageError(String text, ActivatorMFSession session) {
        this.doRaiseSLMessage(text, false, session);
    }

    protected void raiseSLMessageError(Throwable exception, ActivatorMFSession session) {
        this.doRaiseSLMessage(new SLMessage(exception, (MFSession)session), session);
    }

    private void doRaiseSLMessage(String text, boolean isOK, ActivatorMFSession session) {
        this.doRaiseSLMessage(new SLMessage(text, isOK, (MFSession)session), session);
    }

    private void doRaiseSLMessage(SLMessage message, ActivatorMFSession session) {
        try {
            if (session.connection.isOpened()) {
                session.connection.sendMessage(session.getSessionId(), message);
            }
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
    }

    boolean hasConnection() {
        return this.mnodeConnection != null;
    }

    private void checkConnection() throws FabricException {
        if (!this.hasConnection()) {
            throw new FabricException("Connection with managed node is not established.");
        }
    }

    static void logInfo(String message) {
        Trace.logInfo(Activator.class, message);
    }

    static void logException(Throwable exception) {
        Activator.logException(exception, true);
    }

    static void logException(Throwable exception, boolean printStackTrace) {
        Trace.logException(Activator.class, exception, printStackTrace);
    }

    static void logException(Throwable exception, String message) {
        Activator.logException(exception, message, true);
    }

    static void logException(Throwable exception, String message, boolean printStackTrace) {
        Activator.logException(exception, printStackTrace);
        Activator.logError(message);
    }

    static void logError(String message) {
        Trace.logError(Activator.class, message);
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return session instanceof ActivatorMFSession;
    }

    @Override
    public String getStartupDir() {
        return this.ctxDescriptor.getStartupDir();
    }

    static class Launcher
    extends MNodeContainer.MNodeLauncher {
        String[] args;
        String javaExe;
        String activatorURL;
        boolean noMnode = false;
        String mnodeJarPath = null;
        UpgradeMode upgradeMode = null;
        String upgradeVersion = null;
        long upgradeTimeout = -1L;
        private FileWriter logWriter;
        private static final String JAVA_EXE = JVM.isWindowsOS() ? "java.exe" : "java";

        Launcher() {
        }

        @Override
        public void launch(String[] args) {
            this.args = args;
            this.parseArgs(args);
            this.run();
        }

        @Override
        protected int parseOtherArg(String arg, String[] args, int index) {
            if (arg.equals(Activator.JAVA_EXE_PARAMETER)) {
                if (this.javaExe != null) {
                    this.exit("Parsing error: several '-java-exe' parameters specified.");
                }
                if (++index >= args.length) {
                    this.exit("Parsing error: value of '-java-exe' parameter missed.");
                }
                this.javaExe = args[index];
            } else if (arg.equalsIgnoreCase(Activator.MNODE_JAR_PATH_PARAMETER)) {
                if (this.mnodeJarPath != null) {
                    this.exit("Parsing error: several '-mnode-jar-path' parameters specified.");
                }
                if (++index >= args.length) {
                    this.exit("Parsing error: value of '-mnode-jar-path' parameter missed.");
                }
                this.mnodeJarPath = args[index];
            } else if (arg.equals(Activator.URL_PARAMETER)) {
                if (this.activatorURL != null) {
                    this.exit("Parsing error: several '-url' parameters specified.");
                }
                if (++index >= args.length) {
                    this.exit("Parsing error: value of '-url' parameter missed.");
                }
                this.activatorURL = args[index];
            } else if (arg.equals(Activator.NO_MNODE_PARAMETER)) {
                this.noMnode = true;
            } else if (arg.equals(Activator.UPGRADE_MODE_PARAMETER)) {
                if (this.upgradeMode != null) {
                    this.exit("Parsing error: several '-upgrade-mode' parameters specified.");
                }
                if (++index >= args.length) {
                    this.exit("Parsing error: first value of '-upgrade-mode' parameter missed.");
                }
                this.upgradeVersion = args[index];
                if (++index >= args.length) {
                    this.exit("Parsing error: second value of '-upgrade-mode' parameter missed.");
                }
                this.upgradeTimeout = Long.parseLong(args[index]);
                if (++index >= args.length) {
                    this.exit("Parsing error: third value of '-upgrade-mode' parameter missed.");
                }
                this.upgradeMode = UpgradeMode.valueOf(args[index].toUpperCase());
            } else {
                return super.parseOtherArg(arg, args, index);
            }
            return index;
        }

        @Override
        protected String getLogFilename() {
            return this.deploymentDescriptor.getContextName() + "-activator.log";
        }

        @Override
        protected String getTraceFilename() {
            return "activator.traces";
        }

        @Override
        protected void run() {
            block5: {
                if (this.launchMode != Container.ContainerLauncher.LaunchMode.HELP && this.launchMode != Container.ContainerLauncher.LaunchMode.VERSION) {
                    try {
                        if (this.upgradeMode != null) {
                            FabricThreadManager.getInstance().createThread("FSYS:Activator.Upgrade", "Upgrades the software.", () -> {
                                try {
                                    this.initTraces();
                                    Utils.sleep(2000L);
                                    this.runUpgradeMode(this.upgradeMode, this.upgradeVersion);
                                }
                                catch (Throwable exception) {
                                    this.processError(exception, "Activator in Upgrade mode");
                                }
                            }).start();
                            break block5;
                        }
                        this.initTracesAndPrintBanner();
                        new Activator(this, this.getDeploymentDescriptor(), this.activatorURL, this.initShutdownInitiator).start(this.noMnode);
                    }
                    catch (Throwable exception) {
                        this.processError(exception, "Activator");
                    }
                } else {
                    super.run();
                }
            }
        }

        private void processError(Throwable exception, String process) {
            exception.printStackTrace();
            System.err.println("Starting " + process + " failed.");
            System.exit(1);
        }

        private void runUpgradeMode(UpgradeMode upgradeMode, String upgradeVersion) throws Exception {
            this.logWriter = new FileWriter(Activator.getUpgradeLogFile(upgradeVersion), true);
            try {
                if (upgradeMode == UpgradeMode.EXTRACT || upgradeMode == UpgradeMode.EXTRACT_SHUTDOWN) {
                    File image = Activator.getImageFile(upgradeVersion);
                    if (!image.exists()) {
                        throw new Exception("Image archive '" + image.getPath() + "' not found.");
                    }
                    File stroot = new File(System.getenv("STROOT"));
                    Activator.logInfo("Extracting image '" + image.getName() + "' to '" + stroot.getAbsolutePath() + "'...");
                    this.writeInLog("\n\nExtracting image to '" + stroot.getAbsolutePath() + "'...");
                    Activator.extractImage(image, stroot, this.logWriter);
                    Activator.logInfo("Image extracted.");
                    this.writeInLog(" OK");
                    if (upgradeMode == UpgradeMode.EXTRACT_SHUTDOWN) {
                        this.writeInLog("\nShutting down...\n");
                        Launcher.doShutdown();
                    } else {
                        this.startProcessInRestartMode(upgradeVersion);
                    }
                } else {
                    this.args = Arrays.copyOf(this.args, this.args.length - 4);
                    new Activator(this, this.getDeploymentDescriptor(), this.activatorURL, this.initShutdownInitiator).restart(this.upgradeTimeout);
                }
            }
            catch (Throwable exception) {
                this.writeInLog("\nERROR: " + exception.getMessage() + "\n");
                throw exception;
            }
            finally {
                if (this.logWriter != null) {
                    try {
                        this.logWriter.close();
                    }
                    catch (IOException image) {}
                    this.logWriter = null;
                }
            }
        }

        void startProcessInExtractMode(UpgradeOperation.Definition definition) throws Exception {
            ArrayList<String> newArgs = new ArrayList<String>();
            this.initJavaExe();
            newArgs.add(this.javaExe);
            newArgs.add("-jar");
            newArgs.add(this.getActivatorExe());
            Collections.addAll(newArgs, this.args);
            newArgs.add(Activator.UPGRADE_MODE_PARAMETER);
            newArgs.add(definition.version);
            newArgs.add(Long.toString(definition.timeout));
            newArgs.add((definition.shutdown ? UpgradeMode.EXTRACT_SHUTDOWN : UpgradeMode.EXTRACT).name());
            this.doStartProcess(newArgs, "Image Extraction");
        }

        void startProcessInRestartMode(String upgradeVersion) throws Exception {
            ArrayList<String> newArgs = new ArrayList<String>();
            newArgs.add(this.getActivatorExe());
            newArgs.add("-dir");
            newArgs.add(new File(".").getCanonicalPath());
            newArgs.addAll(Arrays.asList(this.args).subList(2, this.args.length - 1));
            newArgs.add(UpgradeMode.RESTART.name());
            this.doStartProcess(newArgs, "Restart Activator");
        }

        private void doStartProcess(List<String> args, String process) throws Exception {
            Activator.logInfo("Starting " + process + " process...");
            Activator.logInfo(args.toString());
            Pair<Object, Object> error = new Pair<Object, Object>(null, null);
            Process ps = Utils.startProcessAsChild(args.toArray(new String[0]), error);
            if (!ps.isAlive() || error.first != null) {
                if (error.first != null) {
                    throw new FabricException("Starting " + process + " process failed.", (Throwable)error.first);
                }
                throw new FabricException("Starting " + process + " process failed.");
            }
            Activator.logInfo(process + " process started.");
            Launcher.doShutdown();
        }

        private static void doShutdown() {
            FabricThreadManager.getInstance().createThread("FSYS:Activator.Shutdown", "Shutdown Activator.", () -> {
                Utils.sleep(200L);
                Trace.logInfo(Activator.class, "Shutting down...");
                System.exit(0);
            }).start();
        }

        private void writeInLog(String message) {
            try {
                if (this.logWriter != null && message != null) {
                    this.logWriter.write(message);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        protected void initTraces() throws Exception {
            this.logFilename = null;
            super.initTraces();
        }

        private List<String> makeMnodeArgs() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            this.initJavaExe();
            result.add(this.javaExe);
            this.addJavaArgs(result);
            Object jarFile = this.mnodeJarPath;
            if (JVM.isWindowsOS()) {
                result.add("-cp");
                if (jarFile == null) {
                    jarFile = this.getActivatorExe();
                }
                this.addJarFile((String)jarFile, result);
                result.add("com.streamscape.tools.mnode.MNodeContainer");
            } else {
                result.add("-jar");
                if (jarFile == null) {
                    jarFile = System.getenv("STROOT") + "/platform/lib/" + this.getExecutableName() + ".jar";
                }
                this.addJarFile((String)jarFile, result);
            }
            String javaExePath = this.getJavaHome();
            if (javaExePath != null) {
                result.add("-java-exe-path");
                result.add(javaExePath);
            } else {
                Activator.logInfo("WARNING: Impossible to find path to Java executable.");
            }
            for (int i = 0; i < this.args.length; ++i) {
                String arg = this.args[i].toLowerCase();
                if (arg.equals("-c") || arg.equals("-console") || arg.equals(Activator.NO_MNODE_PARAMETER)) continue;
                if (this.args[i].equalsIgnoreCase(Activator.URL_PARAMETER) || this.args[i].equalsIgnoreCase(Activator.JAVA_EXE_PARAMETER) || this.args[i].equalsIgnoreCase(Activator.MNODE_JAR_PATH_PARAMETER)) {
                    ++i;
                    continue;
                }
                result.add(this.args[i]);
            }
            if (!this.logEnabled) {
                result.add("-log");
            }
            return result;
        }

        private void addJarFile(String jarFile, List<String> result) throws Exception {
            if (!new File(jarFile).exists()) {
                throw new FabricException("JAR file '" + jarFile + "' not found.");
            }
            result.add(jarFile);
        }

        private void initJavaExe() {
            if (this.javaExe == null || !new File(this.javaExe).exists()) {
                this.javaExe = System.getenv("STROOT") + "/platform/jre/bin/" + JAVA_EXE;
                if (!new File(this.javaExe).exists()) {
                    if (System.getenv("JAVA_HOME") != null) {
                        this.javaExe = System.getenv("JAVA_HOME") + "/bin/" + JAVA_EXE;
                        if (!new File(this.javaExe).exists()) {
                            this.javaExe = "java";
                        }
                    } else {
                        this.javaExe = "java";
                    }
                }
            }
        }

        private String getActivatorExe() {
            return System.getenv("STROOT") + "/bin/" + this.getExecutableName() + ".exe";
        }

        private String getJavaHome() {
            File file;
            String result = this.javaExe;
            if (result.equals(JAVA_EXE)) {
                result = Utils.getExecutablePath(JAVA_EXE);
            }
            if (result != null && (file = new File(result)).isFile() && file.getParentFile() != null) {
                return file.getParentFile().getAbsolutePath();
            }
            return result;
        }

        private void addJavaArgs(List<String> result) throws Exception {
            File mnodeConf;
            if (JVM.is9()) {
                result.add("--add-opens=java.base/jdk.internal.loader=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.net.www=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.security.util=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.nio.ch=ALL-UNNAMED");
                result.add("--add-opens=java.base/jdk.internal.ref=ALL-UNNAMED");
                result.add("--add-opens=java.xml/com.sun.org.apache.xerces.internal.jaxp.datatype=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.net.www.protocol.jar=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.security.provider=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED");
                result.add("--add-opens=java.base/jdk.internal.misc=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.security.action=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.security.pkcs=ALL-UNNAMED");
                result.add("--add-opens=java.base/jdk.internal.reflect=ALL-UNNAMED");
                result.add("--add-opens=java.base/jdk.internal.access=ALL-UNNAMED");
                result.add("--add-opens=java.base/java.util=ALL-UNNAMED");
                result.add("--add-opens=java.base/java.text=ALL-UNNAMED");
                result.add("--add-opens=java.desktop/java.awt.font=ALL-UNNAMED");
                result.add("--add-opens=java.base/java.net=ALL-UNNAMED");
                result.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.security.rsa=ALL-UNNAMED");
                result.add("--add-opens=java.base/sun.nio.cs=ALL-UNNAMED");
            }
            if ((mnodeConf = new File("mnode.conf")).exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(mnodeConf));){
                    while (reader.ready()) {
                        String line = reader.readLine();
                        if (line.startsWith("#")) continue;
                        result.addAll(StringUtils.splitWithoutEmptyTokens(line, ' '));
                    }
                }
            }
        }

        @Override
        protected void printDescription(PrintStream stream) {
            stream.println("\n    TruFabric Activator\n    Release " + Version.getVersion());
        }

        static enum UpgradeMode {
            EXTRACT,
            EXTRACT_SHUTDOWN,
            RESTART;

        }
    }

    static enum ShutdownMode {
        NONE,
        RESTART,
        SHUTDOWN_ALL;

    }

    private class ShutdownHandler
    extends Thread {
        ShutdownHandler() {
            super("FSYS:Shutdown.Handler");
        }

        @Override
        public void run() {
            Activator.logInfo("Activator shutdown initiated.");
            Activator.this.stop();
        }
    }

    private class ConnectionStateHandlerImpl
    extends DefaultConnectionStateHandler {
        private ConnectionStateHandlerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOpen(Connection connection, boolean isOutgoing) throws FabricException {
            ActivatorNetworkConnection networkConnection = (ActivatorNetworkConnection)connection;
            networkConnection.setSessionId(Activator.this.sessionIdAllocator.getNumber());
            Map<Long, ActivatorNetworkConnection> map = Activator.this.connections;
            synchronized (map) {
                Activator.this.connections.put(networkConnection.getSessionId(), networkConnection);
            }
            connection.setPacketHandler(new PacketHandlerImpl(networkConnection));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(Connection connection, boolean isNormal) {
            if (!isNormal) {
                long sessionId = ((ActivatorNetworkConnection)connection).getSessionId();
                Map<Long, ActivatorNetworkConnection> map = Activator.this.connections;
                synchronized (map) {
                    Activator.this.connections.remove(sessionId);
                }
                if (connection == Activator.this.mnodeConnection) {
                    Activator.this.mnodeConnection = null;
                    Activator.logInfo("Connection to Management Node closed.");
                    Activator.this.shutdownWaiter = new ShutdownWaiter();
                    Activator.this.shutdownWaiter.start();
                } else {
                    Activator.logInfo("Session with client '" + sessionId + "' closed.");
                }
            }
        }
    }

    public static class LogEventData
    extends CloneableDataObject {
        public LogEventSource source;
        public TraceRecord trace;
        public EventScope eventScope;

        public LogEventData(LogEventSource source, TraceRecord trace, EventScope eventScope) {
            this.source = source;
            this.trace = trace;
            this.eventScope = eventScope;
        }
    }

    static enum OS {
        WIN,
        LIN,
        MAC,
        SLR;

    }

    public static class MNodeRequestData
    extends CloneableDataObject {
        public int requestId;
        public Object data;

        public MNodeRequestData(int requestId, Object data) {
            this.requestId = requestId;
            this.data = data;
        }
    }

    public static class EventData
    extends CloneableDataObject {
        public ImmutableEventDatagram event;
        public EventScope eventScope;

        public EventData(ImmutableEventDatagram event, EventScope eventScope) {
            this.event = event;
            this.eventScope = eventScope;
        }
    }

    private class PacketHandlerImpl
    extends ActivatorNetworkConnection.DefaultPacketHandler {
        ActivatorMFSession mfSession;

        PacketHandlerImpl(Connection connection) {
            super(connection);
        }

        @Override
        protected Object processRequest(byte type, byte[] bytes, Object data, long timeout) throws FabricException {
            switch (type) {
                case 1: {
                    AbstractSpecialSLSession.ConnectReplyData reply = this.authenticate((AbstractSpecialSLSession.ConnectRequestData)data);
                    Activator.this.mnodeConnection = this.connection;
                    Activator.this.mnodePid = ((AbstractSpecialSLSession.ConnectRequestData)data).pid;
                    if (Activator.this.shutdownWaiter != null) {
                        Activator.this.shutdownWaiter.stop();
                        Activator.this.shutdownWaiter = null;
                    }
                    Activator.logInfo("Session with Management Node established.");
                    Activator.this.autoInitLogMonitor();
                    return reply;
                }
                case 2: {
                    AbstractSpecialSLSession.ConnectRequestData connectData = (AbstractSpecialSLSession.ConnectRequestData)data;
                    AbstractSpecialSLSession.ConnectReplyData reply = this.authenticate(connectData);
                    this.mfSession = new ActivatorMFSession(ActivatorSLSessionImpl.getMFSessionName(this.connection.sessionId), connectData.componentName, reply.user, connectData.slSessionName, this.connection, reply.nodeName + "[Activator]", connectData.fromSlangTool);
                    Activator.logInfo("Session with client '" + connectData.slSessionName + "' established.");
                    return reply;
                }
                case 3: {
                    Activator.this.shutdownMode = ShutdownMode.RESTART;
                    break;
                }
                case 4: {
                    Activator.this.shutdownMode = ShutdownMode.SHUTDOWN_ALL;
                    break;
                }
                case 5: {
                    return this.startTnodeProcess(data);
                }
                case 8: {
                    return this.invokeCommand(data, timeout);
                }
            }
            return null;
        }

        private AbstractSpecialSLSession.ConnectReplyData authenticate(AbstractSpecialSLSession.ConnectRequestData data) throws FabricException {
            try {
                if (!Activator.this.user.getName().equals(data.userName) || !SHA1DigestCalculator.authenticate(Activator.this.user, data.digest, this.connection.getSecurityKey())) {
                    throw new FabricException("Authentication failed: invalid user name or password.");
                }
            }
            catch (SecurityManagerException exception) {
                throw new FabricException("Opening session to Activator failed.", exception);
            }
            return new AbstractSpecialSLSession.ConnectReplyData(Activator.this.user, Activator.this.getDomain(), Activator.this.ctxDescriptor.getContextName(), Banner.getBanner());
        }

        private Object startTnodeProcess(Object data) {
            Activator.logInfo("Starting managed node...");
            try {
                List tnodeArgs = (List)data;
                Activator.logInfo(tnodeArgs.toString());
                Utils.startProcessAsChild(tnodeArgs.toArray(new String[0]));
            }
            catch (Exception exception) {
                Activator.logException((Throwable)exception, "Starting managed node failed.");
                return new FabricException("Start-up of node failed. Cause: " + exception.toString() + ".");
            }
            Activator.logInfo("Managed node started.");
            return null;
        }

        private SLResponse invokeCommand(Object data, long timeout) {
            try {
                return Activator.this.doInvokeCommand(Activator.this.lexiconProcessor, this.getMFSession(data), this.mfSession != null ? data : ((CommandData)data).data, timeout);
            }
            catch (Throwable exception) {
                if (!(exception instanceof UnsupportedRequestException) && !(exception instanceof ParsingException)) {
                    Activator.logException(exception, "Processing SLANG operation failed.");
                }
                return new SLResponse(exception);
            }
        }

        private MFSession getMFSession(Object data) {
            if (this.mfSession != null) {
                return this.mfSession;
            }
            ((ActivatorMFSession)((CommandData)data).mfSession).connection = this.connection;
            return ((CommandData)data).mfSession;
        }

        @Override
        public void onPacket(byte[] packet) {
            try {
                ByteBuffer buffer = ByteBuffer.wrap(packet);
                ActivatorNetworkConnection forwardingConnection = Activator.this.connections.get(buffer.getLong());
                if (forwardingConnection != null) {
                    forwardingConnection.sendMessage(packet);
                } else {
                    Object object = this.connection.unpack(buffer);
                    if (Activator.this.logMonitor != null && object instanceof MapEvent && ((MapEvent)object).getEventId().equals("event.log.monitor.Stream")) {
                        Activator.this.logMonitor.forwardExternalEvent((MapEvent)object);
                    }
                }
            }
            catch (Exception exception) {
                Activator.logException((Throwable)exception, "Packet processing failed.");
            }
        }
    }

    public static class CommandData
    extends CloneableDataObject {
        public String nodeName;
        public MFSession mfSession;
        public Object data;

        public CommandData(MFSession mfSession, Object data) {
            this.mfSession = mfSession;
            this.data = data;
        }

        public CommandData(String nodeName, MFSession mfSession, Object data) {
            this(mfSession, data);
            this.nodeName = nodeName;
        }
    }

    public static class NodesCommandData
    extends CloneableDataObject {
        public ActivatorMFSession session;
        public boolean atDomain;
        public long nodeTimeout;

        NodesCommandData(ActivatorMFSession session, boolean atDomain, long nodeTimeout) {
            this.session = session;
            this.atDomain = atDomain;
            this.nodeTimeout = nodeTimeout;
        }
    }

    public static class UploadImageCommandData
    extends CloneableDataObject {
        public ActivatorMFSession session;
        public Map<String, ImageData> images;
        public boolean withWait;

        UploadImageCommandData(ActivatorMFSession session, Map<String, ImageData> images, boolean withWait) {
            this.session = session;
            this.images = images;
            this.withWait = withWait;
        }
    }

    public static class ImageData
    extends CloneableDataObject {
        public String filename;
        public Set<String> nodes;

        public ImageData(String filename, Set<String> nodes) {
            this.filename = filename;
            this.nodes = nodes;
        }
    }

    private class ShutdownWaiter
    extends SingleTaskWorker {
        ShutdownWaiter() {
            super("FSYS:Activator:ShutdownWaiter", "Waits for a shutdown of Management Node.");
        }

        @Override
        protected void doExecute() throws FabricException {
            boolean success;
            boolean bl = success = Activator.this.mnodeProcess != null ? this.executeWithProcess() : this.executeWithoutProcess();
            if (success) {
                switch (Activator.this.shutdownMode.ordinal()) {
                    case 0: {
                        Activator.logInfo("Management node shut down.");
                        break;
                    }
                    case 1: {
                        Activator.logInfo("Management node shut down. Restarting...");
                        Activator.this.startMnodeWithoutException(true);
                        Activator.this.shutdownMode = ShutdownMode.NONE;
                        break;
                    }
                    case 2: {
                        FabricThreadManager.getInstance().createThread("FSYS:Shutdown.Executor", "Shutdowns Activator.", () -> {
                            Utils.sleep(500L);
                            Activator.logInfo("Management node shut down. Exiting...");
                            System.exit(0);
                        }).start();
                    }
                }
            } else if (Activator.this.shutdownMode != ShutdownMode.NONE) {
                Activator.logError("Waiting for shutdown of Management Node failed.");
            }
        }

        private boolean executeWithProcess() {
            try {
                Activator.this.mnodeProcess.waitFor();
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                Activator.logException(exception);
            }
            return false;
        }

        private boolean executeWithoutProcess() {
            try {
                ContainerLockSupport.RemoteNodeLock mnodeLock = ContainerLockSupport.getRemoteNodeLock("./");
                while (true) {
                    if (!mnodeLock.isLockedByAnotherVM()) {
                        return true;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException mnodeLock) {
            }
            catch (Exception exception) {
                Activator.logException(exception);
            }
            return false;
        }
    }
}

