/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.tools.mnode.Utils;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import com.streamscape.tools.mnode.activator.DescribeDepotImageOperation;
import com.streamscape.tools.mnode.activator.ImageManifest;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractUpgradeOperation
extends AbstractActivatorOperation {
    AbstractUpgradeOperation() {
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.upgrade);
    }

    ExpressionParameter makeVersionParameter(boolean withCompletionAdviser) {
        ExpressionParameter result = new ExpressionParameter("Version");
        if (withCompletionAdviser) {
            result.setCompletionAdviser(new VersionCompletionAdviser());
        }
        return result;
    }

    void addVersionModifier(boolean withCompletionAdviser) {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier().addParameter(this.makeVersionParameter(withCompletionAdviser))).setSyntaxHintSpace());
    }

    File getImageFile(String version) {
        Activator.OS os = Activator.getOS();
        File result = Activator.getImageFile(version, os);
        if (!result.exists()) {
            Activator.OS nextOS;
            Activator.OS[] oSArray = Activator.OS.values();
            int n = oSArray.length;
            for (int i = 0; !(i >= n || (nextOS = oSArray[i]) != os && (result = Activator.getImageFile(version, nextOS)).exists()); ++i) {
            }
        }
        return result;
    }

    String getImageInfo(String version, ImageManifest manifest) {
        return "\n\nImage " + version + ":\n   Version:      " + this.getValue("Version", manifest) + "\n   Build:        " + this.getValue("Build", manifest) + "\n   Platform:     " + this.getValue("Platform", manifest) + "\n   JDK:          " + this.getValue("JDK", manifest) + "\n   Release Date: " + this.getValue("ReleaseDate", manifest) + "\n";
    }

    String getValue(String name, ImageManifest manifest) {
        String result = manifest.getProperty(name);
        return result != null && !result.isEmpty() ? result : "n/a";
    }

    Set<String> checkImage(String nodeName, String version, MFSession session, long timeout) throws Exception {
        Map<String, Object> responses;
        this.raiseSLMessage("\nValidating image " + version + " in " + ((Activator)this.callable).getNodeName() + "... ", session);
        File image = Activator.getImageFile(version);
        if (!image.exists()) {
            throw new FabricException("Image archive not found in depot.");
        }
        ImageManifest manifest = Activator.getImageManifest(version);
        if (!manifest.isValid()) {
            throw new FabricException("Image manifest not valid.");
        }
        this.raiseSLMessage("OK", session);
        this.raiseSLMessage(this.getImageInfo(version, manifest), session);
        HashSet<String> badNodes = new HashSet<String>();
        if (!(nodeName != null && nodeName.equals(((Activator)this.callable).getNodeName()) || (responses = this.invokeDescribeImage(nodeName, version, image.length(), (AbstractMFSession)session, timeout)) == null)) {
            for (Map.Entry<String, Object> entry : responses.entrySet()) {
                this.raiseSLMessage("\nValidating image " + version + " in " + entry.getKey() + "... ", session);
                if (entry.getValue() instanceof SLResponse) {
                    if (((SLResponse)entry.getValue()).isOK()) {
                        this.raiseSLMessage("OK\n", session);
                        continue;
                    }
                    this.raiseSLMessage("\nWARNING: " + Utils.formatException(((SLResponse)entry.getValue()).getException(), "\n       "), session);
                    badNodes.add(entry.getKey());
                    continue;
                }
                this.raiseSLMessageError("Response not received.", session);
                badNodes.add(entry.getKey());
            }
        }
        return badNodes;
    }

    private Map<String, Object> invokeDescribeImage(String nodeName, String version, long imageLength, AbstractMFSession session, long timeout) throws Exception {
        DescribeDepotImageOperation.Definition definition = new DescribeDepotImageOperation.Definition(version, imageLength);
        if (nodeName == null) {
            return this.invokeBroadcastCommand(definition, session, timeout);
        }
        return Collections.singletonMap(nodeName, ((Activator)this.callable).invokeCommand(new Activator.CommandData(nodeName, session, definition), timeout));
    }

    boolean uploadImageToMnodes(ActivatorMFSession session, Map<String, Activator.ImageData> imageData, boolean withWait, long timeout) throws Exception {
        if (((Activator)this.callable).isMnodeConnected()) {
            ((Activator)this.callable).invokeMNodeRequest(2, new Activator.UploadImageCommandData(session, imageData, withWait), timeout);
            return true;
        }
        return false;
    }

    class VersionCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<Activator> {
        VersionCompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            return ((Activator)AbstractUpgradeOperation.this.callable).listImageVersions().stream().sorted().collect(Collectors.toList());
        }
    }
}

