/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;

abstract class AbstractStartStopMnodeOperation
extends AbstractActivatorOperation {
    AbstractDSLOperation.ProgressMonitor progressMonitor;

    AbstractStartStopMnodeOperation(String operationName) {
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName.toUpperCase());
        this.doCompleteSyntax();
    }

    void doCompleteSyntax() {
        this.addTimeoutModifier(true);
    }

    void addTimeoutModifier(boolean withSyntaxHintSpace) {
        Modifier modifier = (Modifier)new Modifier("TIMEOUT", false).addParameter(new LongParameter("Timeout").setRange(10L, Long.MAX_VALUE));
        if (withSyntaxHintSpace) {
            modifier.setSyntaxHintSpace();
        }
        this.syntax.addModifier(modifier);
    }

    long getTimeout(DSLStatement statement, long defaultTimeout) {
        return statement.existsParameter("Timeout") ? Long.valueOf(statement.getParameter("Timeout").getValue()) : defaultTimeout;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.doInvoke(statement, session);
        return new PseudoSLResponse();
    }

    void doInvoke(SLStatement statement, MFSession session) {
        FabricThreadManager.getInstance().createThread(this.getThreadName(), this.getThreadDescription(), () -> {
            try {
                Utils.sleep(500L);
                this.progressMonitor = new AbstractDSLOperation.ProgressMonitor(this, session);
                this.progressMonitor.start();
                this.doOperation(statement, session);
                this.raiseSLMessage(null, session);
            }
            catch (Throwable exception) {
                this.raiseSLMessageError(Utils.formatException(exception, "\n       "), session);
                this.raiseSLMessage(null, session);
            }
            finally {
                if (this.progressMonitor != null) {
                    this.progressMonitor.stop();
                    this.progressMonitor = null;
                }
            }
        }).start();
    }

    abstract String getThreadName();

    abstract String getThreadDescription();

    abstract void doOperation(SLStatement var1, MFSession var2) throws Exception;

    void doOperation(SLStatement statement, MFSession session, String operationMessage, OperationExecutor operation) throws Exception {
        this.raiseSLMessage("\n" + operationMessage + "...", session);
        this.progressMonitor.wakeUp();
        operation.execute();
        this.progressMonitor.sleep();
        this.raiseSLMessage(" OK\n", session);
    }

    void doOperation(SLStatement statement) throws Exception {
    }

    static interface OperationExecutor {
        public void execute() throws Exception;
    }

    static class AbstractDefinition
    extends AbstractSLStatement {
        long timeout;
        boolean force;

        AbstractDefinition(String operationName, long timeout, boolean force) {
            super(operationName);
            this.timeout = timeout;
            this.force = force;
        }
    }
}

