/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.tools.mnode.activator.AbstractStartStopMnodeOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.StartMnodeOperation;
import com.streamscape.tools.mnode.activator.StopMnodeOperation;
import java.util.Map;

abstract class AbstractCreateDropClusterOperation
extends AbstractStartStopMnodeOperation {
    static final long DEFAULT_TIMEOUT = 90L;

    AbstractCreateDropClusterOperation(String operationName) {
        super(operationName);
        this.syntax.addTag(OperationTag.cluster);
    }

    @Override
    void doCompleteSyntax() {
        this.addOtherParameters();
        this.addTimeoutModifier(false);
        this.syntax.addModifier(new Modifier("RESTART MNODE", false));
    }

    void addOtherParameters() {
    }

    String getDescriptionEnd() {
        return "Task nodes must be previously stopped.\nAfter executing the command, the management node will be stopped (or restarted).";
    }

    String getSyntaxDescriptionEnd() {
        return "  timeout <Timeout> - Wait time (in seconds) for shutdown or launch of the management node (separately for each operation).\n                      Default value is 90 seconds. Minimal possible value is 10 seconds.\n  restart mnode     - Specifies if the management node must be restarted after shutdown.";
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.checkTnodes(((Activator)this.callable).getNodeName(), (AbstractMFSession)session);
        this.raiseSLMessage("\n\n" + this.getPreRequestMessage(), session);
        ((Activator)this.callable).invokeMNodeRequest(this.getRequestId(), new Activator.CommandData(((Activator)this.callable).getNodeName(), session, this.getRequestData((Definition)statement)), timeout);
        this.raiseSLMessage(" OK\n", session);
        this.doInvoke(statement, session);
        return new PseudoSLResponse();
    }

    abstract String getPreRequestMessage();

    abstract int getRequestId();

    abstract Object getRequestData(Definition var1);

    @Override
    void doOperation(SLStatement statement, MFSession session) throws Exception {
        this.doOperation(statement, session, "Shutting down management node", () -> StopMnodeOperation.doOperation((Activator)this.callable, statement));
        if (((Definition)statement).restartMnode) {
            Utils.sleep(100L);
            this.doOperation(statement, session, "Launching management node", () -> StartMnodeOperation.doOperation((Activator)this.callable, statement));
        }
    }

    @Override
    String getThreadDescription() {
        return "Stops (or restarts) the management node.";
    }

    static class Definition
    extends AbstractStartStopMnodeOperation.AbstractDefinition {
        String clusterName;
        boolean restartMnode;
        String description;
        Map<String, String> properties;

        Definition(String operationName, String clusterName, long timeout, boolean restartMnode) {
            this(operationName, clusterName, null, null, timeout, restartMnode);
        }

        Definition(String operationName, String clusterName, String description, Map<String, String> properties, long timeout, boolean restartMnode) {
            super(operationName, timeout, false);
            this.clusterName = clusterName;
            this.description = description;
            this.properties = properties;
            this.restartMnode = restartMnode;
        }
    }
}

