/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.lib.utils.JVM;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import com.streamscape.tools.mnode.ManagedNode;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;

public class Utils
extends com.streamscape.sef.utils.Utils {
    private static final int BUFFER_SIZE = 1024;
    private static final String ERROR_PREFIX = "Starting process failed.";

    public static void fillCommandArgs(ManagedNode node, String strootDir, String lastArg, List<String> result) throws FabricException {
        File execFile;
        Object exeFilename = "tnode";
        if (JVM.isWindowsOS()) {
            exeFilename = (String)exeFilename + ".exe";
        }
        if (!((execFile = new File(node.getExecDir(), (String)exeFilename)).exists() || (execFile = new File(strootDir + "/bin", (String)exeFilename)).exists() || (execFile = new File((String)exeFilename)).exists())) {
            throw new FabricException("TNode executable not found.");
        }
        result.add(execFile.getPath());
        Utils.addArg("-dir", node.getDir(), result);
        Utils.addArg("-java-cfg", node.getJavaCfg(), result);
        Utils.addArg("-java-args", node.getJavaArgs(), result);
        Utils.addArg("-java-home", node.getJavaHome(), result);
        Utils.addArg("-ddx", node.getDdx(), result);
        Utils.addArg("-log", node.getLog(), result);
        if (node.isLogBroadcast().booleanValue()) {
            result.add("-log-broadcast");
        }
        if (node.isDebug().booleanValue()) {
            result.add("-debug");
        }
        result.add(lastArg);
    }

    static void addArg(String parameterName, String parameterValue, List<String> result) {
        if (parameterValue != null) {
            result.add(parameterName);
            result.add(parameterValue);
        }
    }

    public static Process startProcessAsChild(String[] commandArgs) throws Exception {
        return Utils.startProcessAsChild(commandArgs, null);
    }

    public static Process startProcessAsChild(String[] commandArgs, Pair<Exception, Exception> error) throws Exception {
        Process result = Runtime.getRuntime().exec(commandArgs, null, null);
        long time = System.currentTimeMillis();
        InputStream stream = result.getInputStream();
        while (stream.available() == 0 && System.currentTimeMillis() - time < 2000L) {
            Utils.sleep(200L);
        }
        if (stream.available() != 0) {
            stream.read(new byte[1024]);
            Utils.checkProcessErrorStream(result, 0L, false, error);
        } else {
            Utils.checkProcessErrorStream(result, 1000L, true, error);
        }
        return result;
    }

    private static void checkProcessErrorStream(Process process, long waitTimeout, boolean throwException, Pair<Exception, Exception> error) throws Exception {
        long time = System.currentTimeMillis();
        InputStream errStream = process.getErrorStream();
        while (errStream.available() == 0 && System.currentTimeMillis() - time < waitTimeout) {
            Utils.sleep(200L);
        }
        if (errStream.available() != 0) {
            byte[] causeBytes = new byte[1024];
            int readBytes = errStream.read(causeBytes);
            String cause = new String(causeBytes, 0, readBytes);
            if (error != null) {
                error.first = new Exception(ERROR_PREFIX, new Exception(cause));
            }
            Trace.logError(Utils.class, "Starting process failed. Cause: " + cause);
            if (throwException) {
                throw error != null ? (Exception)error.first : new Exception("Starting process failed. Cause: " + cause);
            }
        }
    }

    public static void startProcessAndWaitForCompletion(String[] commandArgs) throws Exception {
        Process result = Runtime.getRuntime().exec(commandArgs, null, null);
        long time = System.currentTimeMillis();
        InputStream stream = result.getInputStream();
        while (stream.available() == 0 && System.currentTimeMillis() - time < 2000L) {
            Utils.sleep(200L);
        }
        if (stream.available() != 0) {
            stream.read();
        } else {
            time = System.currentTimeMillis();
            InputStream errorStream = result.getErrorStream();
            while (errorStream.available() == 0 && System.currentTimeMillis() - time < 1000L) {
                Utils.sleep(200L);
            }
            if (errorStream.available() != 0) {
                byte[] bytes = new byte[1024];
                errorStream.read(bytes);
                Trace.logError(Utils.class, "Starting process failed. Cause: " + new String(bytes));
            }
        }
        result.waitFor();
    }

    static Process startProcessByBat(String processName, String[] commandArgs) throws Exception {
        StringBuilder builder = new StringBuilder("start \"" + processName + "\" ");
        for (String commandArg : commandArgs) {
            builder.append(commandArg).append(" ");
        }
        File batFile = new File(processName + ".bat");
        batFile.deleteOnExit();
        PrintWriter writer = new PrintWriter(batFile);
        writer.write(builder.toString());
        writer.close();
        return Runtime.getRuntime().exec(batFile.getName(), null, null);
    }
}

