/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.CreateManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.RemoveManagedNodeOperation;
import java.io.File;
import java.util.List;

public class UndeployManagedNodeOperation
extends RemoveManagedNodeOperation {
    private static final String NAME = "undeploy managed node";

    public UndeployManagedNodeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("UNDEPLOY MANAGED NODE").addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.addCompletionCommand("list managed nodes");
        this.syntax.setDescription("Removes the specified node from the list of managed nodes and deletes its configuration directory.\nAlso removes the corresponding link from the Directory Table and the literal pool from the Global Variables.");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
            if (node == null || node.isRunning()) continue;
            completions.add(node.getName());
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NodeName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        UndeployManagedNodeOperation.doInvoke((MNodeRuntimeContext)this.callable, ((Definition)statement).getNodeName());
        return new SLResponse();
    }

    static ManagedNode doInvoke(MNodeRuntimeContext callable, String nodeName) throws Exception {
        ManagedNode node = RemoveManagedNodeOperation.doInvoke(callable, nodeName);
        callable.getDiscoveryModule().getDirectoryTable().removeNode(node.getName());
        callable.getGlobalVariableFactory().removeLiteralPool(CreateManagedNodeOperation.getPoolName(node.getName()));
        FileIOUtils.deleteFileDir(new File(node.getDir()));
        return node;
    }

    public static class Definition
    extends RemoveManagedNodeOperation.Definition {
        public Definition(String nodeName) {
            super(UndeployManagedNodeOperation.NAME, nodeName);
        }
    }
}

