/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.runtime.deploy.StDeployGenerator;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSyncManagedOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.Utils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SyncManagedOperation
extends AbstractSyncManagedOperation {
    private static final String NAME = "sync managed";
    private static final Method SYNC_GLOBAL_VARIABLES_METHOD;
    private static final Method SYNC_SECURITY_METHOD;
    private static final Method SYNC_CLUSTER_METHOD;

    public SyncManagedOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SYNC MANAGED");
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier("Entity").addPossibleValues("GLOBAL VARIABLES", "SECURITY", "CLUSTER").setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Synchronizes the specified entities among the managed nodes in offline mode.\nThis operation is only applicable to stopped nodes.");
        this.syntax.setSyntaxDescription("sync managed <Entity>           - Synchronizes the specified entities among all managed nodes.\nsync managed <Entity> at <Node> - Synchronizes the specified entities at the specified managed node.");
        this.syntax.setExamples("sync managed global variables\nsync managed security at node Node1\nsync managed cluster");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(ManagedEntity.fromString(statement.getModifier("Entity").getToken()), AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        StringBuilder response = new StringBuilder();
        Definition definition = (Definition)statement;
        if (definition.nodeName != null) {
            ManagedNode node = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.nodeName);
            if (node == null) {
                return new SLResponse("Node not found.", false);
            }
            if (node.isRunning()) {
                return new SLResponse("Node is running.", false);
            }
            response.append("\n").append(SyncManagedOperation.invoke(definition.managedEntity, (MNodeRuntimeContext)this.callable, node));
        } else {
            Method syncMethod = SyncManagedOperation.getSyncMethod(definition.managedEntity);
            for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
                if (!node.isRunning()) {
                    response.append("\n").append(SyncManagedOperation.invokeSyncMethod(syncMethod, (MNodeRuntimeContext)this.callable, node));
                    continue;
                }
                response.append("\n").append(node.getName()).append(" skipped (already running).");
            }
        }
        return new SLResponse(response.length() == 0 ? null : String.valueOf(response) + "\n");
    }

    static String invoke(ManagedEntity entity, MNodeRuntimeContext callable, ManagedNode node) throws Exception {
        return SyncManagedOperation.invokeSyncMethod(SyncManagedOperation.getSyncMethod(entity), callable, node);
    }

    private static Method getSyncMethod(ManagedEntity entity) throws Exception {
        switch (entity.ordinal()) {
            case 0: {
                return SYNC_GLOBAL_VARIABLES_METHOD;
            }
            case 1: {
                return SYNC_SECURITY_METHOD;
            }
            case 2: {
                return SYNC_CLUSTER_METHOD;
            }
        }
        return null;
    }

    private static String invokeSyncMethod(Method method, MNodeRuntimeContext callable, ManagedNode node) {
        try {
            method.invoke(SyncManagedOperation.class, callable, node);
            return node.getName() + " synchronized.";
        }
        catch (InvocationTargetException exception) {
            return "ERROR: " + node.getName() + " failed. Cause: " + exception.getTargetException().getMessage();
        }
        catch (Exception exception) {
            return "ERROR: " + node.getName() + " failed. Cause: " + exception.getMessage();
        }
    }

    static void syncGlobalVariables(MNodeRuntimeContext callable, ManagedNode node) throws Exception {
        File glvFile = new File(node.getDir() + "/.tfcache/globals/GlobalVariables.xdo");
        if (glvFile.exists()) {
            GlobalVariableCollection variables = (GlobalVariableCollection)Utils.readObjectFromXML(glvFile.getAbsolutePath());
            callable.mergeGlobalVariables(variables);
        }
        Utils.writeObjectToXML(callable.getGlobalVariableFactory().getGlobalVariables(), glvFile.getAbsolutePath());
    }

    private static void syncSecurity(MNodeRuntimeContext callable, ManagedNode node) throws Exception {
        SyncManagedOperation.copySecurity(callable, node.getDir() + "/.tfcache/objects/sys/security/");
    }

    private static void syncCluster(MNodeRuntimeContext callable, ManagedNode node) throws Exception {
        File tnodeDdxLocation = new File(SyncManagedOperation.getAbsoluteDdx(node));
        CtxDeploymentDescriptor tnodeDdx = DeployUtils.getDeploymentDescriptor(tnodeDdxLocation);
        tnodeDdx.setClusterEnabled(callable.getDdx().isClusterEnabled());
        tnodeDdx.setClusterName(callable.getDdx().getClusterName());
        StDeployGenerator.generate(tnodeDdxLocation, tnodeDdx);
    }

    static {
        try {
            SYNC_GLOBAL_VARIABLES_METHOD = SyncManagedOperation.class.getDeclaredMethod("syncGlobalVariables", MNodeRuntimeContext.class, ManagedNode.class);
            SYNC_SECURITY_METHOD = SyncManagedOperation.class.getDeclaredMethod("syncSecurity", MNodeRuntimeContext.class, ManagedNode.class);
            SYNC_CLUSTER_METHOD = SyncManagedOperation.class.getDeclaredMethod("syncCluster", MNodeRuntimeContext.class, ManagedNode.class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of SyncManagedOperation failed.", exception);
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private ManagedEntity managedEntity;
        private String nodeName;

        public Definition(ManagedEntity managedEntity, String nodeName) {
            super(SyncManagedOperation.NAME);
            this.managedEntity = managedEntity;
            this.nodeName = nodeName;
        }

        public ManagedEntity getManagedEntity() {
            return this.managedEntity;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }

    public static enum ManagedEntity {
        GLOBAL_VARIABLES,
        SECURITY,
        CLUSTER;


        public static ManagedEntity fromString(String name) {
            return ManagedEntity.valueOf(name.toUpperCase().replace(' ', '_'));
        }
    }
}

