/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.tools.mnode.AbstractStartStopNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.Utils;

public class StopManagedNodeOperation
extends AbstractStartStopNodeOperation {
    public static final String NAME = "stop managed node";
    public static final long DEFAULT_TIMEOUT = 20L;

    public StopManagedNodeOperation() {
        super(NAME, "stop managed node <NodeName> - Stops the specified managed node.\nstop managed node all        - Stops all running managed nodes.\n\nOptional parameters:\n   timeout <Timeout> - Wait time (in seconds) for shutdown of the node, default is 20 seconds.\n   with wait         - Executes this operation in blocking mode (until completion or timeout expiration).");
    }

    @Override
    protected void setOtherParameters(DSLStatement statement, AbstractStartStopNodeOperation.AbstractDefinition definition) {
    }

    @Override
    protected boolean isOperationAllowed(ManagedNode node) {
        return node.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOperation(ManagedNode node, AbstractStartStopNodeOperation.AbstractDefinition definition, MFSession session) throws Exception {
        if (node == null) {
            throw new FabricException("Node not found.");
        }
        if (!node.isRunning()) {
            throw new FabricException("Node is not running.");
        }
        if (node.currentOperation == ManagedNode.Operation.STOP) {
            throw new FabricException("Stopping the node already in progress.");
        }
        node.currentOperation = ManagedNode.Operation.STOP;
        try (NodeStopper stopper = null;){
            stopper = definition.withWait ? new SynchronousNodeStopper(this, node, (Definition)definition) : new AsynchronousNodeStopper(node, (Definition)definition, session);
            stopper.stopAndWait();
            ((MNodeRuntimeContext)this.callable).container.setStoppedState(node);
        }
        finally {
            node.currentOperation = ManagedNode.Operation.NONE;
        }
    }

    @Override
    protected AbstractStartStopNodeOperation.AbstractDefinition createDefinition(String nodeName) {
        return new Definition(nodeName);
    }

    @Override
    protected AbstractStartStopNodeOperation.AbstractDefinition createDefinition(boolean isAll) {
        return new Definition(isAll);
    }

    private class SynchronousNodeStopper
    extends NodeStopper {
        SynchronousNodeStopper(StopManagedNodeOperation stopManagedNodeOperation, ManagedNode node, Definition Definition2) throws Exception {
            super(stopManagedNodeOperation, node, Definition2);
        }
    }

    public static class Definition
    extends AbstractStartStopNodeOperation.AbstractDefinition {
        Definition(String nodeName) {
            super(StopManagedNodeOperation.NAME, nodeName);
        }

        Definition(boolean isAll) {
            super(StopManagedNodeOperation.NAME, isAll);
        }

        Definition(boolean isAll, boolean asyncWithWait) {
            super(StopManagedNodeOperation.NAME, isAll, asyncWithWait);
        }

        Definition(AbstractStartStopNodeOperation.AbstractDefinition other, boolean asyncWithWait) {
            super(StopManagedNodeOperation.NAME, other);
            this.asyncWithWait = asyncWithWait;
        }
    }

    private class AsynchronousNodeStopper
    extends NodeStopper {
        private AbstractDSLOperation.ProgressMonitor progressMonitor;
        private MFSession session;

        AsynchronousNodeStopper(ManagedNode node, Definition definition, MFSession session) throws Exception {
            super(StopManagedNodeOperation.this, node, definition);
            this.session = session;
            this.progressMonitor = new AbstractDSLOperation.ProgressMonitor(StopManagedNodeOperation.this, session);
        }

        @Override
        void stopAndWait() throws Exception {
            StopManagedNodeOperation.this.raiseSLMessage("\nShutdown of node " + this.node.getName() + " initiated.", this.session);
            this.progressMonitor.start();
            super.stopAndWait();
        }

        @Override
        void waitForDetach(long timeout) throws Exception {
            StopManagedNodeOperation.this.raiseSLMessage("\nWaiting for node " + this.node.getName() + " to detach from sysplex...", this.session);
            super.waitForDetach(timeout);
            this.progressMonitor.sleep();
            StopManagedNodeOperation.this.raiseSLMessage("\nNode " + this.node.getName() + " successfully detached from sysplex.", this.session);
        }

        @Override
        void waitForShutdown(long timeout) throws Exception {
            StopManagedNodeOperation.this.raiseSLMessage("\nWaiting for node " + this.node.getName() + " to shutdown...", this.session);
            this.progressMonitor.wakeUp();
            super.waitForShutdown(timeout);
            this.progressMonitor.stop();
            StopManagedNodeOperation.this.raiseSLMessage("\nNode " + this.node.getName() + " successfully shut down.\n", this.session);
        }

        @Override
        void close() {
            super.close();
            if (this.progressMonitor != null) {
                this.progressMonitor.stop();
            }
        }
    }

    private class NodeStopper
    extends AbstractStartStopNodeOperation.AbstractNodeActor {
        protected EventReceiver receiver;
        protected SLSession slSession;

        NodeStopper(StopManagedNodeOperation stopManagedNodeOperation, ManagedNode node, Definition definition) throws Exception {
            super(node, definition);
            this.slSession = ((MNodeRuntimeContext)((StopManagedNodeOperation)stopManagedNodeOperation).callable).container.createSLSession(node.getName());
            this.receiver = stopManagedNodeOperation.getFabricConnection().createEventReceiver("Receiver", "advisory.fabric.Moderator", "(type = 'NODE_DISCONNECTED' OR type = 'NODE_DISCONNECTED_FORCIBLY') AND entity = '" + node.getName() + "'", EventScope.OBSERVABLE, true);
        }

        void stopAndWait() throws Exception {
            this.slSession.slangRequest("shutdown", 5000L);
            long timeout = this.definition.timeout;
            if (timeout == -1L) {
                timeout = 20L;
            }
            long startTime = System.currentTimeMillis();
            this.waitForDetach(timeout *= 1000L);
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.waitForShutdown(timeout - elapsedTime);
        }

        void waitForDetach(long timeout) throws Exception {
            ImmutableEventDatagram event = this.receiver.receive(timeout);
            if (event == null) {
                throw new FabricException("Operation timeout expired. Detach may have failed (see error log).");
            }
        }

        void waitForShutdown(long timeout) throws Exception {
            if (timeout <= 0L) {
                throw new FabricException("Operation timeout expired. Shutdown may have failed (see error log).");
            }
            if (!this.shutdownCompleted()) {
                long endTime = System.currentTimeMillis() + timeout;
                while (System.currentTimeMillis() < endTime) {
                    if (this.shutdownCompleted()) {
                        return;
                    }
                    Utils.sleep(500L);
                }
                throw new FabricException("Operation timeout expired. Shutdown may have failed (see error log).");
            }
        }

        private boolean shutdownCompleted() throws Exception {
            return !this.remoteNodeLock.existsLockFile() || !this.remoteNodeLock.isLockedByAnotherVM();
        }

        void close() {
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.slSession.close();
        }
    }
}

