/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.discovery.DiscoveryModuleConfiguration;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptor;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.tools.mnode.AbstractStartStopNodeOperation;
import com.streamscape.tools.mnode.CreateManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeContainer;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNode;
import com.streamscape.tools.mnode.ManagementNodeFactory;
import com.streamscape.tools.mnode.SyncManagedOperation;
import com.streamscape.tools.mnode.Utils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class StartManagedNodeOperation
extends AbstractStartStopNodeOperation {
    public static final String NAME = "start managed node";
    public static final long DEFAULT_TIMEOUT = 180L;

    public StartManagedNodeOperation() {
        super(NAME, "start managed node <NodeName> - Starts the specified managed node.\nstart managed node all        - Starts all stopped managed nodes.\n\nOptional parameters:\n   timeout   - Wait time (in seconds) for start-up of the node, default is 180 seconds.\n   with wait - Executes this operation in blocking mode (until completion or timeout expiration).\n   admin     - Initializes and starts an administrative HTTP acceptor with the specified URL.\n               URL must have the following format: [$hostname:[(&lt;NetworkInterface&gt;):]]<Port>.\n               Examples: <u>9999</u>, <u>$hostname:9999</u>, <u>$hostname:(eth0):9999</u>, <u>$hostname:(1):9999</u>.");
        this.addAdminModifier();
    }

    @Override
    protected boolean isOperationAllowed(ManagedNode node) {
        return node.getState() == ManagedNode.State.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOperation(ManagedNode node, AbstractStartStopNodeOperation.AbstractDefinition baseDefinition, MFSession session) throws Exception {
        Definition definition = (Definition)baseDefinition;
        if (definition.isAll && definition.adminURL != null) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parameters 'all' and 'admin' cannot be specified together."));
        }
        if (node == null) {
            throw new FabricException("Node not found.");
        }
        if (node.isRunning()) {
            throw new FabricException("Node is already running.");
        }
        if (node.currentOperation == ManagedNode.Operation.START) {
            throw new FabricException("Start-up of the node already in progress.");
        }
        if (!((MNodeRuntimeContext)this.callable).container.checkStoppedState(node)) {
            throw new FabricException("Node is in " + String.valueOf((Object)node.getState()) + " state (probably shutdown failed before).\n       Operation 'kill node' can be used to kill the node.");
        }
        node.currentOperation = ManagedNode.Operation.START;
        try (NodeLauncher launcher = null;){
            launcher = definition.withWait ? new SynchronousNodeLauncher(this, node, definition, ((MNodeRuntimeContext)this.callable).container) : new AsynchronousNodeLauncher(node, definition, session, ((MNodeRuntimeContext)this.callable).container);
            Process process = launcher.startProcess(definition);
            launcher.waitForJoin();
            node.setProcess(process);
        }
        finally {
            node.currentOperation = ManagedNode.Operation.NONE;
        }
    }

    private static void logWarning(String message) {
        Trace.logInfo(StartManagedNodeOperation.class, "WARNING: " + message);
    }

    @Override
    protected AbstractStartStopNodeOperation.AbstractDefinition createDefinition(String nodeName) {
        return new Definition(nodeName);
    }

    @Override
    protected AbstractStartStopNodeOperation.AbstractDefinition createDefinition(boolean isAll) {
        return new Definition(isAll);
    }

    public static class Definition
    extends AbstractStartStopNodeOperation.AbstractStartNodeDefinition {
        Definition(String nodeName) {
            super(StartManagedNodeOperation.NAME, nodeName);
        }

        Definition(boolean isAll) {
            super(StartManagedNodeOperation.NAME, isAll);
        }

        Definition(boolean isAll, boolean asyncWithWait) {
            super(StartManagedNodeOperation.NAME, isAll, asyncWithWait);
        }

        Definition(AbstractStartStopNodeOperation.AbstractStartNodeDefinition other, long timeout) {
            super(StartManagedNodeOperation.NAME, other);
            this.timeout = other.timeout;
        }
    }

    private class SynchronousNodeLauncher
    extends NodeLauncher {
        SynchronousNodeLauncher(StartManagedNodeOperation startManagedNodeOperation, ManagedNode node, Definition definition, MNodeContainer container) throws Exception {
            super(node, definition, container);
        }
    }

    private class AsynchronousNodeLauncher
    extends NodeLauncher {
        private AbstractDSLOperation.ProgressMonitor progressMonitor;
        private MFSession session;

        AsynchronousNodeLauncher(ManagedNode node, Definition definition, MFSession session, MNodeContainer container) throws Exception {
            super(node, definition, container);
            this.session = session;
            this.progressMonitor = new AbstractDSLOperation.ProgressMonitor(StartManagedNodeOperation.this, session);
        }

        @Override
        void waitForJoin() throws Exception {
            StartManagedNodeOperation.this.raiseSLMessage("\nStart-up of node " + this.node.getName() + " initiated.\nWaiting for node " + this.node.getName() + " to join the sysplex...", this.session);
            this.progressMonitor.start();
            super.waitForJoin();
            this.progressMonitor.stop();
            StartManagedNodeOperation.this.raiseSLMessage("\nNode " + this.node.getName() + " successfully joined the sysplex.\n", this.session);
        }

        @Override
        void close() {
            super.close();
            if (this.progressMonitor != null) {
                this.progressMonitor.stop();
            }
        }
    }

    private class NodeLauncher
    extends AbstractStartStopNodeOperation.AbstractNodeActor {
        protected EventConsumer nodeJoinedConsumer;
        protected boolean nodeJoined;
        private MNodeContainer container;

        NodeLauncher(ManagedNode node, Definition definition, MNodeContainer container) throws Exception {
            super(node, definition);
            this.nodeJoined = false;
            this.container = container;
            ManagementNodeFactory.copyObject(new ManagementNode(((MNodeRuntimeContext)StartManagedNodeOperation.this.callable).getName()), node);
            this.checkNodeLockFile();
            this.checkDiscoveryModuleLink();
            this.synchronize(node);
            FabricEventListener listener = event -> {
                this.nodeJoined = true;
            };
            this.nodeJoinedConsumer = container.getFabricConnection().createEventConsumer("NodeJoinerConsumer", listener, "advisory.fabric.Moderator", "type = 'NODE_CONNECTED' AND entity = '" + node.getName() + "'", EventScope.OBSERVABLE, true);
        }

        private void checkDiscoveryModuleLink() throws Exception {
            if (!((MNodeRuntimeContext)StartManagedNodeOperation.this.callable).getDiscoveryModule().getDirectoryTable().existsNode(this.node.getName())) {
                StartManagedNodeOperation.logWarning("Directory Table does not contain a link for managed node '" + this.node.getName() + "'. Adding link...");
                TLPAcceptor acceptor = ((MNodeRuntimeContext)StartManagedNodeOperation.this.callable).getTLPAcceptorFactory().lookupAcceptor("Default");
                if (acceptor != null) {
                    ((MNodeRuntimeContext)StartManagedNodeOperation.this.callable).getDiscoveryModule().getDirectoryTable().addLink(this.node.getName(), new DiscoveryLink(((MNodeRuntimeContext)StartManagedNodeOperation.this.callable).getName(), acceptor.getAddress().toString()));
                } else {
                    Trace.logError(this, "Default TLP acceptor in management node does not exist. Link not added.");
                }
            }
            try {
                DiscoveryModuleConfiguration discovery;
                Path fabricDirectory;
                XSerializer serializer = ((MNodeRuntimeContext)StartManagedNodeOperation.this.callable).getXSerializer();
                DiscoveryModuleConfiguration mnodeDiscovery = ((MNodeRuntimeContext)StartManagedNodeOperation.this.callable).getDiscoveryModuleFactory().getActiveModuleConfiguration();
                File discoveryFile = new File(this.node.getDir() + "/.tfcache/objects/sys/discovery/DiscoveryModule.Default.xdo");
                boolean recreating = false;
                if (!discoveryFile.exists()) {
                    StartManagedNodeOperation.logWarning("Discovery Module does not exist in managed node '" + this.node.getName() + "'. Creating...");
                    if (!discoveryFile.getParentFile().exists()) {
                        discoveryFile.getParentFile().mkdirs();
                    }
                    CreateManagedNodeOperation.writeDiscoveryModule(mnodeDiscovery, discoveryFile, serializer);
                    recreating = true;
                }
                if ((fabricDirectory = CreateManagedNodeOperation.getFabricDirectory(discovery = CreateManagedNodeOperation.readDiscoveryModule(discoveryFile, serializer))) != null && !new File((fabricDirectory = Paths.get(this.node.getDir(), new String[0]).toRealPath(new LinkOption[0]).resolve(fabricDirectory)).toString()).exists()) {
                    fabricDirectory = null;
                }
                Path mnodeFabricDirectory = CreateManagedNodeOperation.getFabricDirectory(mnodeDiscovery).toRealPath(new LinkOption[0]);
                if (recreating || fabricDirectory == null || !Files.isSameFile(fabricDirectory.toRealPath(new LinkOption[0]), mnodeFabricDirectory)) {
                    if (!recreating) {
                        StartManagedNodeOperation.logWarning("Path to Directory Table in managed node '" + this.node.getName() + "' is not the same as in management node. Replacing...");
                    }
                    CreateManagedNodeOperation.setFabricDirectory((MNodeRuntimeContext)StartManagedNodeOperation.this.callable, this.node.getName(), this.node.getDir(), discovery, mnodeFabricDirectory);
                    CreateManagedNodeOperation.writeDiscoveryModule(discovery, discoveryFile, serializer);
                }
            }
            catch (Exception exception) {
                Trace.logException(StartManagedNodeOperation.class, exception, true);
                Trace.logError(StartManagedNodeOperation.class, "Update Discovery Module in managed node '" + this.node.getName() + "' failed.");
            }
        }

        private void checkNodeLockFile() throws Exception {
            if (this.remoteNodeLock.isLockedByAnotherVM()) {
                throw new Exception("Node start-up failed. Cause: Lock file already locked (probably node already started).");
            }
            this.remoteNodeLock.removeLockFile();
            this.remoteNodeLock.removeLockFailFile();
            if (this.remoteNodeLock.existsLockFile()) {
                throw new Exception("Node start-up failed. Cause: Removing lock file failed.");
            }
        }

        private void synchronize(ManagedNode node) throws Exception {
            SyncManagedOperation.invoke(SyncManagedOperation.ManagedEntity.GLOBAL_VARIABLES, (MNodeRuntimeContext)StartManagedNodeOperation.this.callable, node);
            SyncManagedOperation.invoke(SyncManagedOperation.ManagedEntity.SECURITY, (MNodeRuntimeContext)StartManagedNodeOperation.this.callable, node);
            CreateManagedNodeOperation.setTimezone((MNodeRuntimeContext)StartManagedNodeOperation.this.callable, node);
        }

        Process startProcess(Definition definition) throws Exception {
            ArrayList<String> commandArgs = new ArrayList<String>();
            Utils.fillCommandArgs(this.node, ((MNodeRuntimeContext)StartManagedNodeOperation.this.callable).getSTRootDir(), "-start", commandArgs);
            if (this.node.getAdmin() != null || definition.adminURL != null) {
                commandArgs.add("-admin");
                commandArgs.add(definition.adminURL != null ? definition.adminURL : this.node.getAdmin());
            }
            Trace.logInfo(this, ((Object)commandArgs).toString());
            if (this.container.activator != null && this.container.activator.isReady()) {
                Object reply = this.container.activator.invokeRequest((byte)5, commandArgs);
                if (reply instanceof FabricException) {
                    throw (FabricException)reply;
                }
                return null;
            }
            return Utils.startProcessAsChild(commandArgs.toArray(new String[0]));
        }

        void waitForJoin() throws Exception {
            long startTime = System.currentTimeMillis();
            long timeout = this.definition.timeout;
            if (timeout == -1L) {
                timeout = 180L;
            }
            long lockFileCreationTimeout = Math.min(10000L, timeout *= 1000L);
            while (System.currentTimeMillis() - startTime < lockFileCreationTimeout && !this.remoteNodeLock.existsLockFile() && !this.remoteNodeLock.existsLockFailFile()) {
                Thread.sleep(1000L);
            }
            if (!this.remoteNodeLock.existsLockFile() && !this.remoteNodeLock.existsLockFailFile()) {
                throw new FabricException("Node start-up failed. Lock file not created during 10 secs after start.");
            }
            while (System.currentTimeMillis() - startTime < timeout && !this.nodeJoined) {
                if (!this.remoteNodeLock.isLockedByAnotherVM()) {
                    Object error = this.remoteNodeLock.getLockFailFileError();
                    error = error == null || ((String)error).length() == 0 ? "Node start-up failed (see error log)." : "Node start-up failed. Cause: " + (String)error;
                    throw new FabricException((String)error);
                }
                Thread.sleep(1000L);
            }
            if (!this.nodeJoined) {
                throw new FabricException("Node started but not joined to the sysplex.");
            }
        }

        void close() {
            if (this.nodeJoinedConsumer != null) {
                try {
                    this.container.getFabricConnection().dropEventConsumer(this.nodeJoinedConsumer.getName());
                }
                catch (Exception exception) {
                    Trace.logException(StartManagedNodeOperation.class, exception, true);
                }
            }
        }
    }
}

