/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.runtime.mf.operation.trace.log.ShowLogOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import java.io.File;

public class ShowLogOperation
extends com.streamscape.runtime.mf.operation.trace.log.ShowLogOperation<MNodeRuntimeContext> {
    public ShowLogOperation() {
        super(true);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.mnode);
    }

    @Override
    protected void addNodeModifier() {
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("AT", false).setAlias("@")).addParameter(new IdentifierParameter("NodeName"))).setSyntaxHintSpace());
    }

    @Override
    protected String doGetNodeDescription() {
        return "SHOW LOG               - Shows the log file from the current node.\nSHOW LOG AT <NodeName> - Shows the log file from the specified managed node.\n";
    }

    @Override
    protected String getNodeExample() {
        return "\nshow log at Node1";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        this.checkSyntax(statement);
        return new Definition(statement.existsParameter("NodeName") ? statement.getParameter("NodeName").getValue() : null, statement.existsModifier("FULL"), this.getDirection(statement), this.getLines(statement));
    }

    @Override
    protected File getLogFile(ShowLogOperation.Definition definition) throws Exception {
        File logFile;
        String nodeName = ((Definition)definition).nodeName;
        if (nodeName == null) {
            return super.getLogFile(definition);
        }
        ManagedNode node = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(nodeName);
        if (node != null) {
            Object logFilename = node.getLog().endsWith(".log") ? node.getLog() : node.getLog() + ".log";
            logFile = new File((String)logFilename);
            if (!logFile.exists()) {
                logFile = new File(new File(node.getDir()), (String)logFilename);
            }
        } else {
            throw new Exception("Node not found.");
        }
        return logFile;
    }

    static class Definition
    extends ShowLogOperation.Definition {
        private String nodeName;

        Definition(String nodeName, boolean full, ShowLogOperation.Direction direction, int lines) {
            super(full, direction, lines);
            this.nodeName = nodeName;
        }

        String getNodeName() {
            return this.nodeName;
        }
    }
}

