/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.deploy.DeploymentAdvisoryType;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.BackupManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import java.util.List;

public class RevertManagedNodeOperation
extends AbstractFrmNodeOperation<MNodeRuntimeContext> {
    private static final String NAME = "revert managed node";

    public RevertManagedNodeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REVERT MANAGED NODE").addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.setDescription("Reverts the checked out managed node back into its normal state.");
        this.syntax.addCompletionCommand("list managed nodes");
        this.syntax.addTag(OperationTag.mnode);
    }

    boolean isOperationAllowed(ManagedNode node) {
        return node.getCheckedOutBy() != null;
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
            if (node == null || !this.isOperationAllowed(node)) continue;
            completions.add(node.getName());
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NodeName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return RevertManagedNodeOperation.doInvoke((MNodeRuntimeContext)this.callable, (Definition)statement, session);
    }

    static SLResponse doInvoke(MNodeRuntimeContext callable, Definition definition, MFSession session) throws Exception {
        ManagedNode node = callable.container.getManagedNodes().getNode(definition.getNodeName());
        if (node == null) {
            throw new FabricException("Node not found.");
        }
        if (node.getCheckedOutBy() != null && !node.getCheckedOutBy().equals(session.getOwnerName()) && !session.getOwner().isSudoCapable()) {
            throw new FabricException("Node already checked out by '" + node.getCheckedOutBy() + "' user and cannot be reverted.");
        }
        node.currentOperation = ManagedNode.Operation.NONE;
        node.setCheckedOutBy(null);
        callable.container.getManagedNodes().save();
        RevertManagedNodeOperation.raiseDeploymentAdvisory(callable, DeploymentAdvisoryType.NODE_REVERTED, definition.getNodeName(), callable.getName());
        return new SLResponse();
    }

    static class Definition
    extends AbstractFrmNodeOperation.Definition {
        Definition(String nodeName) {
            super(RevertManagedNodeOperation.NAME, nodeName, null, false);
        }

        Definition(BackupManagedNodeOperation.Definition definition) {
            this(definition.getNodeName());
        }
    }
}

