/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.runtime.mf.operation.frm.RestoreNodeOperation;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.deploy.DeploymentAdvisoryType;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNode;
import java.io.File;
import java.util.List;
import java.util.Set;

public class RestoreManagedNodeOperation
extends RestoreNodeOperation<MNodeRuntimeContext> {
    public static final String NAME = "restore managed node";

    public RestoreManagedNodeOperation() {
        super(NAME);
        this.syntax.addCompletionCommand("list managed nodes");
        this.syntax.addTag(OperationTag.mnode);
    }

    @Override
    protected void doInit() {
        this.syntax.addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false).setName("WithWait"));
        this.syntax.setDescription("Restores the specified managed node using the content of a specified Fabric Resource Module (FRM).\nIt is expected that the FRM was created using a corresponding BACKUP command and contains\na full node image.\n\nThis operation erases all files in the node (and its storage cache) and loads all\ncontents from the specified FRM, performing a full, destructive load operation.\nBy default, the original deployment descriptor is retained and not replaced by the one from FRM.\nTherefore, Node Name, Domain and Runtime Security Credentials of the target node are retained.\n\nThe node must be stopped and not be checked out.\n\nIf you want to replace existing files without erasing others, use 'import managed node' command\ninstead. If you want to fully replace the node content including the Deployment Descriptor, use\n'undeploy/deploy managed node' commands instead.\n\nInformation about the operation steps and results is written to Restore.log file.");
        this.syntax.setExamples("restore managed node Node1 from 'C:/Streamscape/resources/Node1.frm'\nrestore managed node Node1 from 'C:/Streamscape/resources/Node1.frm' with wait\nrestore managed node Node1 from 'C:/Streamscape/resources/Node1.frm' password '123'");
        this.syntax.setInitialVersion("3.8 Build 24");
    }

    @Override
    protected String getOtherSyntaxDescription() {
        return "\n   with wait - Executes this operation in blocking mode (until completion or timeout expiration).\n";
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
            if (node == null || node.isRunning()) continue;
            completions.add(node.getName());
        }
    }

    @Override
    protected RestoreNodeOperation.Definition createDefinition(String nodeName, String frmPath, boolean isAsync, String password) {
        return new Definition(this.getName(), nodeName, frmPath, isAsync, password);
    }

    @Override
    protected void checkBeforeExecute(AbstractFrmNodeOperation.Definition definition, MFSession session) throws Exception {
        ManagedNode existingNode = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.getNodeName());
        if (existingNode == null) {
            throw new FabricException("Node not found.");
        }
        if (existingNode.isRunning()) {
            throw new FabricException("Node is running");
        }
        if (existingNode.getCheckedOutBy() != null) {
            throw new FabricException("Node checked out by '" + existingNode.getCheckedOutBy() + "'. It should be either checked in or reverted.");
        }
        ((Definition)definition).node = existingNode;
    }

    @Override
    protected File getWorkingDir(RestoreNodeOperation.Definition definition) throws Exception {
        return new File(((Definition)definition).node.getDir()).getCanonicalFile();
    }

    @Override
    protected File getDdxFile(RestoreNodeOperation.Definition definition) throws Exception {
        return new File(AbstractMNodeOperation.getAbsoluteDdx(((Definition)definition).node), "stdeploy.jar").getCanonicalFile();
    }

    @Override
    protected String getNodeName(RestoreNodeOperation.Definition definition) {
        return ((Definition)definition).node.getName();
    }

    @Override
    protected void throwInvalidFrmException(String errorMessage) throws Exception {
        throw new FabricException(errorMessage);
    }

    @Override
    protected void unloadNode(RestoreNodeOperation.Definition definition, MFSession session) throws Exception {
    }

    @Override
    protected void addExcludedFiles(File workingDir, Set<File> excludedFiles) {
        excludedFiles.add(new File(workingDir, ManagementNode.OBJECT_PATH));
    }

    @Override
    protected void deleteExcludedFiles(File frmDir) {
        super.deleteExcludedFiles(frmDir);
        new File(frmDir, ManagementNode.OBJECT_PATH).delete();
    }

    @Override
    protected void loadNode(RestoreNodeOperation.Definition definition, MFSession session) throws Exception {
        RestoreManagedNodeOperation.raiseDeploymentAdvisory((MNodeRuntimeContext)this.callable, DeploymentAdvisoryType.NODE_RESTORED, definition.getNodeName(), ((MNodeRuntimeContext)this.callable).getName());
    }

    @Override
    protected boolean canRaiseSLMessage(MFSession session) {
        return true;
    }

    @Override
    protected File initLog(File workingDir) throws Exception {
        return null;
    }

    @Override
    protected void writeInLog(String message) {
    }

    static class Definition
    extends RestoreNodeOperation.Definition {
        ManagedNode node;

        Definition(String operationName, String nodeName, String frmPath, boolean isAsync, String password) {
            super(operationName, nodeName, frmPath, isAsync, password);
        }
    }
}

