/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.tools.mnode.AbstractStartStopNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.StartManagedNodeOperation;
import com.streamscape.tools.mnode.StopManagedNodeOperation;
import java.util.ArrayList;

public class RestartManagedNodeOperation
extends AbstractStartStopNodeOperation {
    private static final String NAME = "restart managed node";

    public RestartManagedNodeOperation() {
        super(NAME, "restart managed node <NodeName> - Restarts the specified managed node.\nrestart managed node all        - Restarts all running managed nodes.\n\nOptional parameters:\n   stop timeout  - Wait time (in seconds) for shutdown of a node, default is 20 seconds.\n   start timeout - Wait time (in seconds) for start-up of a node, default is 180 seconds.\n   with wait     - Executes this operation in blocking mode (until completion or timeout expiration).\n   admin         - Initializes and starts an administrative HTTP acceptor with an automatically assigned port.\n   admin &lt;Port&gt;  - Initializes and starts an administrative HTTP acceptor with the specified port.");
        this.addAdminModifier();
    }

    @Override
    protected void addTimeoutModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("STOP TIMEOUT", false).addParameter(new LongParameter("StopTimeout")));
        this.syntax.addModifier((AbstractModifier)new Modifier("START TIMEOUT", false).addParameter(new LongParameter("StartTimeout")));
    }

    @Override
    protected void setExamples(String operationName) {
        this.syntax.setExamples(operationName + " ExampleNode\n" + operationName + " all\n" + operationName + " ExampleNode stop timeout 10\n" + operationName + " ExampleNode stop timeout 10 start timeout 60\n" + operationName + " ExampleNode with wait\n" + operationName + " ExampleNode stop timeout 10 start timeout 60 with wait");
    }

    @Override
    protected void setTimeout(DSLStatement statement, AbstractStartStopNodeOperation.AbstractDefinition definition) {
        if (statement.existsParameter("StopTimeout")) {
            definition.timeout = Integer.parseInt(statement.getParameter("Timeout").getValue());
        }
        if (statement.existsParameter("StartTimeout")) {
            ((Definition)definition).startTimeout = Integer.parseInt(statement.getParameter("StartTimeout").getValue());
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        if (inProgress) {
            return new SLResponse("Operation with managed nodes is already in progress.", false);
        }
        Definition definition = (Definition)statement;
        SLResponse stopResponse = ((MNodeRuntimeContext)this.callable).getLexiconProcessor().invoke(new StopManagedNodeOperation.Definition(definition, true), session, timeout);
        if (!stopResponse.isOK()) {
            return stopResponse;
        }
        SLResponse startResponse = ((MNodeRuntimeContext)this.callable).getLexiconProcessor().invoke(new StartManagedNodeOperation.Definition(definition, definition.startTimeout), session, timeout);
        ArrayList<String> allMessages = new ArrayList<String>();
        if (stopResponse.getMessages() != null) {
            allMessages.addAll(stopResponse.getMessages());
        }
        if (startResponse.getMessages() != null) {
            allMessages.addAll(startResponse.getMessages());
        }
        if (!allMessages.isEmpty()) {
            startResponse.setMessages(allMessages);
        }
        return startResponse;
    }

    @Override
    protected boolean isOperationAllowed(ManagedNode node) {
        return node.isRunning();
    }

    @Override
    protected void doOperation(ManagedNode node, AbstractStartStopNodeOperation.AbstractDefinition definition, MFSession session) throws Exception {
    }

    @Override
    protected AbstractStartStopNodeOperation.AbstractDefinition createDefinition(String nodeName) {
        return new Definition(nodeName);
    }

    @Override
    protected AbstractStartStopNodeOperation.AbstractDefinition createDefinition(boolean isAll) {
        return new Definition(isAll);
    }

    private static class Definition
    extends AbstractStartStopNodeOperation.AbstractStartNodeDefinition {
        int startTimeout;

        Definition(String nodeName) {
            super(RestartManagedNodeOperation.NAME, nodeName);
        }

        Definition(boolean isAll) {
            super(RestartManagedNodeOperation.NAME, isAll);
        }

        Definition(boolean isAll, boolean asyncWithWait) {
            super(RestartManagedNodeOperation.NAME, isAll, asyncWithWait);
        }
    }
}

