/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNodeFactory;
import java.util.List;

public class RemoveManagedNodeOperation
extends AbstractMNodeOperation {
    private static final String NAME = "remove managed node";

    public RemoveManagedNodeOperation() {
        super(true, false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE MANAGED NODE").addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.setDescription("Removes the specified node from the list of managed nodes.");
        this.syntax.addCompletionCommand("list managed nodes");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
            if (node == null || node.isRunning()) continue;
            completions.add(node.getName());
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NodeName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RemoveManagedNodeOperation.doInvoke((MNodeRuntimeContext)this.callable, ((Definition)statement).nodeName);
        return new SLResponse();
    }

    static ManagedNode doInvoke(MNodeRuntimeContext callable, String nodeName) throws Exception {
        ManagedNode node = callable.container.getManagedNodes().getNode(nodeName);
        if (node == null) {
            throw new FabricException("Node not found.");
        }
        if (node.isRunning()) {
            throw new FabricException("Node is running.");
        }
        ManagementNodeFactory.removeObject(node);
        callable.container.getManagedNodes().removeNode(node.getName());
        return node;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;

        public Definition(String nodeName) {
            super(RemoveManagedNodeOperation.NAME);
            this.nodeName = nodeName;
        }

        public Definition(String operationName, String nodeName) {
            super(operationName);
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

