/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.mf.operation.LocationModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SLFilePathCompleter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.AddManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNode;
import com.streamscape.tools.mnode.ManagementNodeFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProvisionManagedNodesOperation
extends AbstractMNodeOperation {
    private static final String NAME = "provision managed nodes";
    private File workingDir;
    private boolean found;
    private int nAddedNodes;
    private static final Set<String> FORBIDDEN_DIRS = new HashSet<String>();

    public ProvisionManagedNodesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("PROVISION MANAGED NODES");
        this.syntax.addModifier((AbstractModifier)new LocationModifier(false, new SLFilePathCompleter()).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)new Modifier("ALL", false).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Searches all nodes at the specified directory and adds the found nodes to the list of managed nodes.\nUses the working directory for the search if the parameter 'Location' is not specified.\nAdds only new managed nodes by default.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   all - Clears the list of managed nodes and adds all the found nodes to it.");
        this.syntax.setExamples("provision managed nodes\nprovision managed nodes all\nprovision managed nodes at 'C:/Streamscape/MNode1/Nodes'\nprovision managed nodes at 'C:/Streamscape/MNode1/Nodes' all");
    }

    @Override
    public void activate(MNodeRuntimeContext callable) {
        super.activate(callable);
        try {
            this.workingDir = new File(callable.getStartupDir()).getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(LocationModifier.getValue(statement), statement.existsModifier("ALL"));
    }

    @Override
    public synchronized SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        File directory;
        Definition definition = (Definition)statement;
        File file = directory = definition.directory != null ? new File(definition.directory) : this.workingDir;
        if (!directory.isDirectory()) {
            return new SLResponse("'" + directory.getPath() + "' is not an existing directory.", false);
        }
        if (definition.isAll) {
            this.checkExistingNodes();
            ((MNodeRuntimeContext)this.callable).container.getManagedNodes().clear();
        }
        this.found = false;
        this.nAddedNodes = 0;
        this.addNodes(directory, !definition.isAll, session);
        return new SLResponse((String)(this.found ? this.nAddedNodes + " nodes added." : "Nodes not found."));
    }

    private void checkExistingNodes() throws Exception {
        for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
            if (node == null || !node.isRunning()) continue;
            throw new FabricException("Some managed nodes are running.");
        }
    }

    private void addNodes(File directory, boolean newOnly, MFSession session) throws Exception {
        if (this.containsNode(directory)) {
            this.addNode(directory, newOnly, session);
        } else {
            List<String> subdirs = FileIOUtils.directorySublist(directory.getCanonicalPath(), false);
            for (File file : directory.listFiles()) {
                if (!file.isDirectory() || FORBIDDEN_DIRS.contains(file.getName().toLowerCase())) continue;
                this.addNodes(file, newOnly, session);
            }
        }
    }

    private boolean containsNode(File directory) throws Exception {
        return !directory.equals(this.workingDir) && new File(directory, ".tfcache").isDirectory();
    }

    private void addNode(File directory, boolean newOnly, MFSession session) throws Exception {
        this.found = true;
        this.raiseSLMessage("\nNode found at '" + directory.getCanonicalPath() + "'...", session);
        File ddx = this.findDeploymentDescriptor(directory);
        if (ddx == null) {
            this.raiseSLMessage("\nERROR: Deployment descriptor not found.\n", session);
        } else {
            ManagedNode node = new ManagedNode();
            node.setDir(directory.getAbsolutePath());
            node.setDdx(ddx.getParentFile().getAbsolutePath());
            try {
                AddManagedNodeOperation.checkDdx(node, (MNodeRuntimeContext)this.callable);
                if (newOnly && ((MNodeRuntimeContext)this.callable).container.getManagedNodes().existsNode(node.getName())) {
                    this.raiseSLMessage("\nNode " + node.getName() + " already exists. Skipping...\n", session);
                } else {
                    node.setLog(node.getName() + ".log");
                    ManagementNodeFactory.copyObject(new ManagementNode(((MNodeRuntimeContext)this.callable).getName()), node);
                    ((MNodeRuntimeContext)this.callable).container.getManagedNodes().appendNode(node);
                    ++this.nAddedNodes;
                    this.raiseSLMessage("\nNode " + node.getName() + " added.\n", session);
                }
            }
            catch (Exception exception) {
                this.raiseSLMessage("\nERROR: " + exception.getMessage() + "\n", session);
            }
        }
    }

    private File findDeploymentDescriptor(File directory) {
        ArrayList<File> subdirs = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (!file.isDirectory()) {
                if (!file.getName().equals("stdeploy.jar")) continue;
                return file;
            }
            if (FORBIDDEN_DIRS.contains(file.getName().toLowerCase())) continue;
            subdirs.add(file);
        }
        for (File subdir : subdirs) {
            File ddx = this.findDeploymentDescriptor(subdir);
            if (ddx == null) continue;
            return ddx;
        }
        return null;
    }

    static {
        FORBIDDEN_DIRS.add(".tfcache");
        FORBIDDEN_DIRS.add(".dscache");
        FORBIDDEN_DIRS.add(".htcache");
        FORBIDDEN_DIRS.add(".junk");
    }

    public static class Definition
    extends AbstractSLStatement {
        private String directory;
        private boolean isAll;

        public Definition(String directory, boolean isAll) {
            super(ProvisionManagedNodesOperation.NAME);
            this.directory = directory;
            this.isAll = isAll;
        }

        public String getDirectory() {
            return this.directory;
        }

        public boolean isNew() {
            return this.isAll;
        }
    }
}

