/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractBackupNodeOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.DeployManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.UndeployManagedNodeOperation;
import com.streamscape.tools.mnode.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;

public class MigrateManagedNodeOperation
extends AbstractMNodeOperation {
    private static final String NAME = "migrate managed node";

    public MigrateManagedNodeOperation() {
        super(true, false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("MIGRATE MANAGED NODE");
        this.syntax.addActionParameter((SyntaxParameter)new IdentifierParameter("TnodeName").setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser<MNodeRuntimeContext>(){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                return ((MNodeRuntimeContext)MigrateManagedNodeOperation.this.callable).getManagedNodes().stream().filter(node -> node != null && MigrateManagedNodeOperation.this.isOperationAllowed((ManagedNode)node)).map(ManagedNode::getName).collect(Collectors.toList());
            }
        }));
        this.syntax.addModifier((AbstractModifier)new Modifier("TO").addParameter((SyntaxParameter)new IdentifierParameter("MnodeName").setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser<MNodeRuntimeContext>(){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                return ((MNodeRuntimeContext)((MigrateManagedNodeOperation)MigrateManagedNodeOperation.this).callable).container.getMNodes().stream().map(FabricNodeReference::getName).collect(Collectors.toList());
            }
        })));
        this.syntax.setDescription("Migrates the specified managed node from the current management node to another management node.");
        this.syntax.setExamples("migrate managed node Tnode1 to Mnode1");
    }

    boolean isOperationAllowed(ManagedNode node) {
        return (node.currentOperation == null || node.currentOperation == ManagedNode.Operation.NONE) && node.getCheckedOutBy() == null;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("TnodeName").getValue(), statement.getParameter("MnodeName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.forSource) {
            this.doInvokeInSourceNode(definition, session, timeout);
        } else {
            this.doInvokeInTargetNode(definition, session, timeout);
        }
        return new PseudoSLResponse();
    }

    private void doInvokeInSourceNode(Definition definition, MFSession session, long timeout) throws Exception {
        ManagedNode tnode = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.tnodeName);
        if (tnode == null) {
            throw new FabricException("Managed node not found.");
        }
        if (tnode.currentOperation != null && tnode.currentOperation != ManagedNode.Operation.NONE) {
            throw new FabricException("Migration of managed node is not possible while other operation is in progress.");
        }
        if (tnode.getCheckedOutBy() != null) {
            throw new FabricException("Managed node checked out by '" + tnode.getCheckedOutBy() + "'. It should be either checked in or reverted.");
        }
        if (tnode.isRunning()) {
            throw new FabricException("Managed node is running.");
        }
        FabricNodeReference mnode = ((MNodeRuntimeContext)this.callable).getModerator().lookupFabricNode(definition.mnodeName);
        if (mnode == null) {
            throw new FabricException("Management node not found.");
        }
        if (mnode.getName().equals(((MNodeRuntimeContext)this.callable).getName())) {
            throw new FabricException("Management node specified is a current node.");
        }
        FabricThreadManager.getInstance().createThread("FSYS:MNode.Migrate", "Migrates '" + tnode.getName() + "' to '" + mnode.getName() + "'.", () -> {
            File frmFile = new File(tnode.getDir() + "/" + this.getFrmFilename(tnode.getName()));
            try {
                this.generateFRM(session, tnode, frmFile);
                this.uploadFRM(session, mnode, frmFile);
                this.undeployTnode(session, tnode);
                this.invokeRemote(mnode, definition.setForTarget(), (AbstractMFSession)session, timeout);
            }
            catch (Throwable exception) {
                this.raiseSLMessageError(Utils.formatException(exception), session);
                this.raiseSLMessage(null, session);
            }
            finally {
                frmFile.delete();
            }
        }).start();
    }

    private void generateFRM(MFSession session, ManagedNode node, File frmFile) throws Exception {
        this.raiseSLMessage("\nGenerating Resource Module...\n\n", session);
        try (OutputStream output = AbstractBackupNodeOperation.openFrmOutputStream(frmFile);){
            FrmFileWriter writer = new FrmFileWriter(frmFile.getAbsolutePath(), output);
            writer.addFile("manifest.frmm", ((MNodeRuntimeContext)this.callable).getXSerializer().serialize(new FrmManifest()).getBytes());
            writer.generate(new File(node.getDir()), new File(node.getDdx()), new FrmManifest(), message -> this.raiseSLMessage(message, session));
            writer.close();
        }
        this.raiseSLMessage("\nResource Module generated.\n", session);
    }

    private void uploadFRM(MFSession session, FabricNodeReference mnode, File frmFile) throws Exception {
        this.raiseSLMessage("\nUploading Resource Module to " + mnode.getName() + "...\n\n", session);
        try (FileInputStream inputFileStream = new FileInputStream(frmFile);){
            SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(((MNodeRuntimeContext)this.callable).container.getConnectionFullName(mnode.getName()), message -> this.raiseSLMessage(((SLFileMessage)message).getText("upload"), session), frmFile.getName(), session.getSLSessionData().getTransferBufferSize());
            utils.createFile(inputFileStream, inputFileStream.available(), true);
        }
        this.raiseSLMessage("\nResource Module uploaded to " + mnode.getName() + ".\n", session);
    }

    private void undeployTnode(MFSession session, ManagedNode tnode) throws Exception {
        this.raiseSLMessage("\nDeleting managed node...", session);
        UndeployManagedNodeOperation.doInvoke((MNodeRuntimeContext)this.callable, tnode.getName());
        this.raiseSLMessage("OK\n", session);
    }

    private void doInvokeInTargetNode(Definition definition, MFSession session, long timeout) throws Exception {
        this.raiseSLMessage("\nDeploying managed node to " + definition.mnodeName + "...\n", session);
        ((MNodeRuntimeContext)this.callable).getLexiconProcessor().invoke(new DeployManagedNodeOperation.Definition(definition.tnodeName, this.getFrmFilename(definition.tnodeName)), session, timeout);
    }

    private String getFrmFilename(String nodeName) {
        return nodeName + ".frm";
    }

    public static class Definition
    extends AbstractSLStatement {
        private String tnodeName;
        private String mnodeName;
        private boolean forSource = true;

        Definition(String tnodeName, String mnodeName) {
            super(MigrateManagedNodeOperation.NAME);
            this.tnodeName = tnodeName;
            this.mnodeName = mnodeName;
        }

        public String getTnodeName() {
            return this.tnodeName;
        }

        public String getMnodeName() {
            return this.mnodeName;
        }

        Definition setForTarget() {
            this.forSource = false;
            return this;
        }
    }
}

