/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.utils.Utils;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNode;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

class ManagementNodeFactory
extends AbstractRuntimeFactory {
    ManagementNodeFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyObject(ManagementNode object, ManagedNode node) throws Exception {
        File file = ManagementNodeFactory.getObjectFile(node, true);
        boolean objectFileExists = file.exists();
        RandomAccessFile objectFile = new RandomAccessFile(file, "rw");
        FileLock objectFileLock = ManagementNodeFactory.getObjectFileLock(file, objectFile, node);
        try {
            if (objectFileExists) {
                ManagementNodeFactory.checkExistingObject(object, node, objectFile);
            } else {
                ManagementNodeFactory.writeObject(object, objectFile, ManagementNodeFactory.getSerializer());
            }
        }
        finally {
            objectFileLock.release();
            objectFile.close();
        }
    }

    static void removeObject(ManagedNode node) {
        File file = ManagementNodeFactory.getObjectFile(node, false);
        if (file.exists()) {
            file.delete();
            if (file.exists()) {
                Trace.logError(ManagementNodeFactory.class, "Removing file '" + file.getAbsolutePath() + "' failed.");
            }
        }
    }

    private static File getObjectFile(ManagedNode node, boolean makeDirs) {
        File objectDir;
        File file = objectDir = makeDirs ? new File(Utils.createTFCache(node.getDir()), "objects//sys/mf") : new File(new File(node.getDir(), ".tfcache"), "objects//sys/mf");
        if (makeDirs && !objectDir.exists()) {
            objectDir.mkdirs();
        }
        return new File(objectDir, "ManagementNode.xdo");
    }

    static FileLock getObjectFileLock(File file, RandomAccessFile objectFile, ManagedNode node) throws FabricException {
        try {
            FileLock result = objectFile.getChannel().tryLock();
            if (result == null) {
                throw new FabricException("Opening '" + file.getAbsolutePath() + "' failed.\n       Probably node " + node.getName() + " is already running.");
            }
            return result;
        }
        catch (IOException exception) {
            throw new FabricException("Locking '" + file.getAbsolutePath() + "' failed.", exception);
        }
    }

    static void checkObject(ManagementNode object, ManagedNode node) throws Exception {
        File file = ManagementNodeFactory.getObjectFile(node, false);
        if (file.exists()) {
            RandomAccessFile objectFile = new RandomAccessFile(file, "rw");
            FileLock objectFileLock = ManagementNodeFactory.getObjectFileLock(file, objectFile, node);
            ManagementNodeFactory.checkExistingObject(object, node, objectFile);
        }
    }

    static ManagementNode getObject(ManagedNode node) throws Exception {
        File file = ManagementNodeFactory.getObjectFile(node, false);
        if (file.exists()) {
            RandomAccessFile objectFile = new RandomAccessFile(file, "rw");
            return ManagementNodeFactory.readObject(objectFile, ManagementNodeFactory.getSerializer());
        }
        return null;
    }

    private static void checkExistingObject(ManagementNode object, ManagedNode node, RandomAccessFile objectFile) throws Exception {
        ManagementNode existingObject;
        XSerializer serializer = ManagementNodeFactory.getSerializer();
        try {
            existingObject = ManagementNodeFactory.readObject(objectFile, serializer);
        }
        catch (Exception exception) {
            Trace.logException(ManagementNodeFactory.class, exception, false);
            Trace.logError(ManagementNodeFactory.class, "Obtaining existing ManagementNode object failed. Trying to copy new object...");
            existingObject = ManagementNodeFactory.writeObject(object, objectFile, serializer);
        }
        if (!object.getName().equals(existingObject.getName())) {
            throw new FabricException("Node " + node.getName() + " already managed by other management node (" + existingObject.getName() + ").");
        }
    }

    static <T> T writeObject(T object, RandomAccessFile objectFile, XSerializer serializer) throws FabricException {
        try {
            String objectString = serializer.serialize(object);
            objectFile.setLength(0L);
            objectFile.seek(0L);
            objectFile.write(objectString.getBytes());
            return object;
        }
        catch (Exception exception) {
            throw new FabricException("Copying " + object.getClass().getSimpleName() + " object failed.", exception);
        }
    }

    private static ManagementNode readObject(RandomAccessFile objectFile, XSerializer serializer) throws Exception {
        byte[] existingObjectBytes = new byte[(int)objectFile.length()];
        objectFile.readFully(existingObjectBytes);
        return (ManagementNode)serializer.deserialize(existingObjectBytes);
    }

    private static XSerializer getSerializer() {
        return ManagementNodeFactory.getContext().getXSerializerFactory().lookupSerializer("RuntimeCache$Serializer");
    }
}

