/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.repository.cache.SystemTableFile;
import com.streamscape.sdo.enums.ArtifactState;
import com.streamscape.tools.mnode.ManagedNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ManagedNodes
extends SystemTableFile<List<ManagedNode>> {
    public static final String TABLE_PATH_IN_CACHE = "objects/sys/mf/ManagedNodes.sdo".replace('/', File.separatorChar);

    protected ManagedNodes() {
        super("ManagedNodes", TABLE_PATH_IN_CACHE, ArtifactState.RECOVER_MANAGED_NODES_TABLE);
    }

    public synchronized void appendNode(ManagedNode node) {
        this.checkNodeAbsence(node);
        ((List)this.store).add(node);
        this.save();
    }

    public synchronized void prependNode(ManagedNode node) {
        this.checkNodeAbsence(node);
        ((List)this.store).add(0, node);
        this.save();
    }

    public synchronized void insertNodeAfter(ManagedNode node, String nodeName) {
        this.checkNodeAbsence(node);
        ((List)this.store).add(this.getNodeIndexWithCheck(nodeName) + 1, node);
        this.save();
    }

    public synchronized void insertNodeBefore(ManagedNode node, String nodeName) {
        this.checkNodeAbsence(node);
        ((List)this.store).add(this.getNodeIndexWithCheck(nodeName), node);
        this.save();
    }

    private void checkNodeAbsence(ManagedNode node) {
        if (this.getNodeIndex(node.getName()) != -1) {
            throw new IndexOutOfBoundsException("Managed node '" + node.getName() + "' already exists.");
        }
    }

    public synchronized void moveNodeAfter(String nodeNameToMove, String nodeName) {
        this.moveNode(nodeNameToMove, this.getNodeIndexWithCheck(nodeName) + 1);
    }

    public synchronized void moveNodeBefore(String nodeNameToMove, String nodeName) {
        this.moveNode(nodeNameToMove, this.getNodeIndexWithCheck(nodeName));
    }

    public synchronized void moveNodeToEnd(String nodeName) {
        this.moveNode(nodeName, ((List)this.store).size());
    }

    public synchronized void moveNode(String nodeName, int newIndex) {
        int nodeIndex = this.getNodeIndexWithCheck(nodeName);
        ManagedNode node = (ManagedNode)((List)this.store).remove(nodeIndex);
        if (nodeIndex < newIndex) {
            --newIndex;
        }
        ((List)this.store).add(newIndex, node);
        this.save();
    }

    public synchronized void updateNode(ManagedNode node) {
        ((List)this.store).set(this.getNodeIndexWithCheck(node.getName()), node);
        this.save();
    }

    private int getNodeIndexWithCheck(String nodeName) {
        return ManagedNodes.checkIndex(this.getNodeIndex(nodeName), nodeName);
    }

    private static int checkIndex(int index, String nodeName) {
        if (index == -1) {
            throw new IndexOutOfBoundsException("Managed node '" + nodeName + "' does not exist.");
        }
        return index;
    }

    synchronized void removeNode(String nodeName) {
        int index = this.getNodeIndex(nodeName);
        if (index != -1) {
            ((List)this.store).remove(index);
            this.save();
        }
    }

    synchronized void clear() {
        ((List)this.store).clear();
        this.save();
    }

    ManagedNode getNode(String nodeName) {
        int index = this.getNodeIndex(nodeName);
        if (index != -1) {
            return (ManagedNode)((List)this.store).get(index);
        }
        return null;
    }

    boolean existsNode(String nodeName) {
        return this.getNodeIndex(nodeName) != -1;
    }

    int getNodeIndex(String nodeName) {
        return IntStream.range(0, ((List)this.store).size()).filter(i -> ((ManagedNode)((List)this.store).get(i)).getName().equals(nodeName)).findFirst().orElse(-1);
    }

    List<ManagedNode> getNodes() {
        return new ArrayList<ManagedNode>((Collection)this.store);
    }

    @Override
    protected void createStore() {
        this.store = new ArrayList();
    }

    @Override
    protected synchronized List<ManagedNode> cloneStore() {
        return ((List)this.store).stream().map(node -> (ManagedNode)node.clone()).collect(Collectors.toList());
    }

    void check() {
        if (((List)this.store).contains(null)) {
            ((List)this.store).remove(null);
            this.save();
        }
    }

    boolean isEmpty() {
        return ((List)this.store).isEmpty();
    }
}

