/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.container.Container;

public class ManagedNode
extends CloneableDataObject {
    private String name;
    private String dir;
    private String ddx;
    private String execDir;
    private String javaCfg;
    private String javaArgs;
    private String javaHome;
    private String log;
    private Boolean logBroadcast = false;
    private Boolean debug = false;
    private String admin;
    private String checkedOutBy;
    private Boolean autoStart = false;
    private Integer delayBeforeStart = 1;
    private Long startTimeout = 180L;
    transient Operation currentOperation = Operation.NONE;
    transient State state = State.STOPPED;
    transient Process process;
    transient int pid = -1;
    transient long lastAttachTime = -1L;
    transient long lastDetachTime = -1L;
    private static final int DEFAULT_DELAY_BEFORE_START = 1;
    private static final long DEFAULT_START_TIMEOUT = 180L;

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    String getDir() {
        return this.dir;
    }

    void setDir(String dir) {
        this.dir = dir;
    }

    String getDdx() {
        return this.ddx;
    }

    void setDdx(String ddx) {
        this.ddx = ddx;
    }

    String getExecDir() {
        return this.execDir;
    }

    void setExecDir(String execDir) {
        this.execDir = execDir;
    }

    String getJavaCfg() {
        return this.javaCfg;
    }

    void setJavaCfg(String javaCfg) {
        this.javaCfg = javaCfg;
    }

    String getJavaArgs() {
        return this.javaArgs;
    }

    void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    String getJavaHome() {
        return this.javaHome;
    }

    void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    String getLog() {
        return this.log;
    }

    void setLog(String log) {
        this.log = log;
    }

    Boolean isLogBroadcast() {
        return this.logBroadcast;
    }

    void setLogBroadcast(Boolean logBroadcast) {
        this.logBroadcast = logBroadcast;
    }

    Boolean isDebug() {
        return this.debug;
    }

    void setDebug(Boolean debug) {
        this.debug = debug;
    }

    String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    void setCheckedOutBy(String checkedOutBy) {
        this.checkedOutBy = checkedOutBy;
    }

    Boolean isAutoStart() {
        return this.autoStart;
    }

    void setAutoStart(Boolean autoStart) {
        this.autoStart = autoStart;
    }

    String getAdmin() {
        return this.admin;
    }

    void setAdmin(String admin) {
        this.admin = admin;
    }

    Integer getDelayBeforeStart() {
        return this.delayBeforeStart;
    }

    void setDelayBeforeStart(Integer delayBeforeStart) {
        this.delayBeforeStart = delayBeforeStart;
    }

    Long getStartTimeout() {
        return this.startTimeout;
    }

    void setStartTimeout(Long startTimeout) {
        this.startTimeout = startTimeout;
    }

    State getState() {
        return this.state;
    }

    void setState(State state) {
        this.state = state;
    }

    boolean isRunning() {
        return this.state == State.RUNNING;
    }

    boolean isOperationInProgress() {
        return this.currentOperation != null && this.currentOperation != Operation.NONE;
    }

    boolean isStartOrStopOperationInProgress() {
        return this.currentOperation != null && (this.currentOperation == Operation.START || this.currentOperation == Operation.STOP);
    }

    Process getProcess() {
        return this.process;
    }

    void setPid(int pid) {
        this.pid = pid;
    }

    int getPid() {
        return this.pid;
    }

    void setProcess(Process process) {
        this.process = process;
    }

    long getLastAttachTime() {
        return this.lastAttachTime;
    }

    void setLastAttachTime(long lastAttachTime) {
        this.lastAttachTime = lastAttachTime;
    }

    long getLastDetachTime() {
        return this.lastDetachTime;
    }

    void setLastDetachTime(long lastDetachTime) {
        this.lastDetachTime = lastDetachTime;
    }

    void setDefaults() {
        if (this.log == null) {
            this.log = Container.getDefaultLogFilename(this.name);
        }
        if (this.logBroadcast == null) {
            this.logBroadcast = false;
        }
        if (this.debug == null) {
            this.debug = false;
        }
        if (this.autoStart == null) {
            this.autoStart = false;
        }
        if (this.delayBeforeStart == null) {
            this.delayBeforeStart = 1;
        }
        if (this.startTimeout == null) {
            this.startTimeout = 180L;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name           = ").append(this.name).append("\n");
        builder.append("workDir        = ").append(this.dir).append("\n");
        builder.append("javaCfgFile    = ").append(this.javaCfg).append("\n");
        builder.append("javaArgs       = ").append(this.javaArgs).append("\n");
        builder.append("javaHomeDir    = ").append(this.javaHome).append("\n");
        builder.append("ddxDir         = ").append(this.ddx).append("\n");
        builder.append("log            = ").append(this.log).append("\n");
        builder.append("logBroadcast   = ").append(this.logBroadcast).append("\n");
        builder.append("debug          = ").append(this.debug).append("\n");
        builder.append("admin          = ").append(this.admin).append("\n");
        builder.append("checkedOutBy   = ").append(this.checkedOutBy).append("\n");
        builder.append("autostart      = ").append(this.autoStart).append("\n");
        builder.append("delay          = ").append(this.delayBeforeStart).append("\n");
        builder.append("timeout        = ").append(this.startTimeout).append("\n");
        builder.append("state          = ").append((Object)this.state).append("\n");
        builder.append("lastAttachTime = ").append(this.lastAttachTime).append("\n");
        builder.append("lastDetachTime = ").append(this.lastDetachTime);
        return builder.toString();
    }

    static enum Operation {
        START,
        STOP,
        CHECKOUT,
        NONE;

    }

    public static enum State {
        RUNNING,
        DETACHED,
        STOPPED,
        SUSPECT;

    }
}

