/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.runtime.RuntimeSessionManager;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.SessionRequest;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.tools.mnode.ActivatorConnection;
import com.streamscape.tools.mnode.MNodeContainer;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import java.util.Objects;

class MNodeSessionManager
extends RuntimeSessionManager {
    protected final LongNumberAllocatorSimple activatorSessionNameAllocator = new LongNumberAllocatorSimple();

    protected MNodeSessionManager(MNodeRuntimeContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RequestConsumerReference doOpenSession(SessionRequest request, ComponentReference client, String sessionName) throws Exception {
        if (this.isForActivator(request)) {
            if (!this.getContainer().activator.isReady()) {
                throw new FabricRequestException("Session with Activator is not established. Probably Activator is stopped.");
            }
            ActivatorConnection activatorConnection = this.getContainer().activator;
            Objects.requireNonNull(activatorConnection);
            ActivatorConnection.AccessorProxyImpl proxy = activatorConnection.new ActivatorConnection.AccessorProxyImpl(sessionName, request.getClientName(), this.getOwner(request), request.isRouted(), request.getSLSessionName(), request.getSLSessionData());
            MNodeSessionManager mNodeSessionManager = this;
            synchronized (mNodeSessionManager) {
                RequestConsumerReference result = this.createSessionConsumer(request, sessionName, proxy, this.isLocal(client) ? EventScope.OBSERVABLE : EventScope.INHERITED);
                this.sessions.put(sessionName, proxy);
                this.addClientSession(client, sessionName);
                Trace.logInfo(this, "Session '" + sessionName + "' opened " + this.inComponent());
                return result;
            }
        }
        return super.doOpenSession(request, client, sessionName);
    }

    @Override
    protected String getSessionName(SessionRequest request) {
        return this.isForActivator(request) ? "ActivatorSession" + this.activatorSessionNameAllocator.getNumber() : super.getSessionName(request);
    }

    private boolean isForActivator(SessionRequest request) {
        return request.getAccessorName().startsWith("Activator$");
    }

    private MNodeContainer getContainer() {
        return (MNodeContainer)this.context.getContainer();
    }
}

