/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.sef.exchange.FabricCluster;
import com.streamscape.sef.exchange.FabricClusterFactory;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNodeFactory;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

class MNodeFabricClusterFactory
extends FabricClusterFactory {
    protected static final String OBJECT_XDO = OBJECT_NAME + ".xdo";
    protected static final String OBJECT_DIR = ".tfcache/objects//sys/exchange";
    protected static final String OBJECT_FULL_PATH = ".tfcache/objects//sys/exchange/" + OBJECT_XDO;

    MNodeFabricClusterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyObject(FabricCluster object, ManagedNode node) throws Exception {
        File file = MNodeFabricClusterFactory.getObjectFile(node);
        RandomAccessFile objectFile = new RandomAccessFile(file, "rw");
        FileLock objectFileLock = ManagementNodeFactory.getObjectFileLock(file, objectFile, node);
        try {
            ManagementNodeFactory.writeObject(object, objectFile, MNodeFabricClusterFactory.getContext().getXSerializerFactory().lookupSerializer("RuntimeCache$Serializer"));
        }
        finally {
            objectFileLock.release();
            objectFile.close();
        }
    }

    static void removeObject(ManagedNode node) {
        File file = MNodeFabricClusterFactory.getObjectFile(node);
        if (file.exists()) {
            file.delete();
            if (file.exists()) {
                Trace.logError(MNodeFabricClusterFactory.class, "Removing file '" + file.getAbsolutePath() + "' failed.");
            }
        }
    }

    private static File getObjectFile(ManagedNode node) {
        return new File(node.getDir(), OBJECT_FULL_PATH);
    }
}

