/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.omf.java.SerialSupport;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.runtime.deploy.StDeployGenerator;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.moderator.ListNodesOperation;
import com.streamscape.runtime.mf.operation.moderator.ShutdownOperation;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.container.Container;
import com.streamscape.sef.container.ContainerFactory;
import com.streamscape.sef.container.ContainerLockSupport;
import com.streamscape.sef.dispatcher.AbstractMNodeContainer;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricCluster;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.sef.trace.TraceRecord;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.ActivatorConnection;
import com.streamscape.tools.mnode.CompleteImageOperation;
import com.streamscape.tools.mnode.ListManagedNodesOperation;
import com.streamscape.tools.mnode.MNodeContainerFactory;
import com.streamscape.tools.mnode.MNodeFabricClusterFactory;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagedNodeStateAdvisory;
import com.streamscape.tools.mnode.ManagedNodes;
import com.streamscape.tools.mnode.ManagementNode;
import com.streamscape.tools.mnode.StartManagedNodeOperation;
import com.streamscape.tools.mnode.StopManagedNodeOperation;
import com.streamscape.tools.mnode.Utils;
import com.streamscape.tools.mnode.Version;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MNodeContainer
extends AbstractMNodeContainer {
    public static final String JAVA_EXE_PATH_PARAMETER = "-java-exe-path";
    public static final String NO_AUTO_START_PARAMETER = "-no-auto-start";
    ActivatorConnection activator = new ActivatorConnection();
    Integer minTlpPort = DEFAULT_MIN_TLP_PORT;
    Integer maxTlpPort = DEFAULT_MAX_TLP_PORT;
    Integer minHttpPort = DEFAULT_MIN_HTTP_PORT;
    Integer maxHttpPort = DEFAULT_MAX_HTTP_PORT;
    transient ManagedNodes managedNodes;
    transient ManagedNodesStarter managedNodesStarter;
    transient StateMonitor stateMonitor;
    static final Integer DEFAULT_MIN_TLP_PORT = 6000;
    static final Integer DEFAULT_MAX_TLP_PORT = 6999;
    static final Integer DEFAULT_MIN_HTTP_PORT = 8000;
    static final Integer DEFAULT_MAX_HTTP_PORT = 8999;
    private static final SLStatement START_TNODES_STATEMENT = new StartManagedNodeOperation.Definition(true, true);
    private static final String START_TNODES_MESSAGE = "Starting task nodes";
    private static final SLStatement STOP_TNODES_STATEMENT = new StopManagedNodeOperation.Definition(true, true);
    private static final String STOP_TNODES_MESSAGE = "Stopping task nodes";
    private static final SLStatement STOP_MNODE_STATEMENT = new ShutdownOperation.Definition(false, null, ShutdownOperation.ShutdownMode.ALL);
    private static final LongNumberAllocatorSimple SL_MESSAGE_CONSUMER_ALLOCATOR = new LongNumberAllocatorSimple();

    public static void main(String[] args) {
        new MNodeLauncher().launch(args);
    }

    public static MNodeRuntimeContext getContext() {
        return (MNodeRuntimeContext)context;
    }

    public String getActivatorURL() {
        return this.activator != null ? this.activator.getUrl() : null;
    }

    public boolean setActivatorURL(String url) {
        if (url != null) {
            if (this.activator == null) {
                this.activator = new ActivatorConnection(url);
                this.onUpdate();
                return true;
            }
            if (!url.equalsIgnoreCase(this.getActivatorURL())) {
                this.activator.setUrl(url);
                this.onUpdate();
                return true;
            }
        }
        return false;
    }

    public int getMinTlpPort() {
        return this.minTlpPort;
    }

    int getMinTlpPortPositive() {
        return this.minTlpPort > 0 ? this.minTlpPort : DEFAULT_MIN_TLP_PORT;
    }

    public void setMinTlpPort(int minTlpPort) {
        if (this.minTlpPort != minTlpPort) {
            this.minTlpPort = minTlpPort;
            this.onUpdate();
        }
    }

    public int getMaxTlpPort() {
        return this.maxTlpPort;
    }

    int getMaxTlpPortPositive() {
        return this.maxTlpPort > 0 ? this.maxTlpPort : DEFAULT_MAX_TLP_PORT;
    }

    public void setMaxTlpPort(int maxTlpPort) {
        if (this.maxTlpPort != maxTlpPort) {
            this.maxTlpPort = maxTlpPort;
            this.onUpdate();
        }
    }

    public int getMinHttpPort() {
        return this.minHttpPort;
    }

    int getMinHttpPortPositive() {
        return this.minHttpPort > 0 ? this.minHttpPort : DEFAULT_MIN_HTTP_PORT;
    }

    public void setMinHttpPort(int minHttpPort) {
        if (this.minHttpPort != minHttpPort) {
            this.minHttpPort = minHttpPort;
            this.onUpdate();
        }
    }

    public int getMaxHttpPort() {
        return this.maxHttpPort;
    }

    int getMaxHttpPortPositive() {
        return this.maxHttpPort > 0 ? this.maxHttpPort : DEFAULT_MAX_HTTP_PORT;
    }

    public void setMaxHttpPort(int maxHttpPort) {
        if (this.maxHttpPort != maxHttpPort) {
            this.maxHttpPort = maxHttpPort;
            this.onUpdate();
        }
    }

    String getJavaExePath() {
        return ((MNodeLauncher)this.launcher).javaExePath;
    }

    String getJavaHomePath() {
        File file;
        String javaExePath = this.getJavaExePath();
        if (javaExePath != null && (file = new File(javaExePath)).isDirectory() && file.getName().equalsIgnoreCase("bin") && file.getParentFile() != null) {
            return file.getParentFile().getAbsolutePath();
        }
        return null;
    }

    @Override
    public void doInit() throws FabricException {
        super.doInit();
        this.minTlpPort = this.initPort("minTlpPort", this.minTlpPort, DEFAULT_MIN_TLP_PORT);
        this.maxTlpPort = this.initPort("maxTlpPort", this.maxTlpPort, DEFAULT_MAX_TLP_PORT);
        this.minHttpPort = this.initPort("minHttpPort", this.minHttpPort, DEFAULT_MIN_HTTP_PORT);
        this.maxHttpPort = this.initPort("maxHttpPort", this.maxHttpPort, DEFAULT_MAX_HTTP_PORT);
        if (this.activator == null) {
            this.activator = new ActivatorConnection();
            this.isUpdated = true;
        }
        this.activator.init(this);
        this.createLogEventConsumer();
        this.managedNodes = new ManagedNodes();
        this.loadManagedNodes();
        this.managedNodes.check();
        this.stateMonitor = new StateMonitor();
        this.managedNodesStarter = new ManagedNodesStarter();
    }

    private int initPort(String name, Integer value, Integer defaultValue) throws FabricException {
        if (value == null || value == 0) {
            this.logWarning("Parameter '" + name + "' is not specified. Default value '" + defaultValue + "' will be used.");
            this.isUpdated = true;
            return defaultValue;
        }
        try {
            if (value < 0) {
                throw new FabricException("Parameter '" + name + "' must be positive.");
            }
            return value;
        }
        catch (NumberFormatException exception) {
            throw new FabricException("Parameter '" + name + "' has invalid format.", exception);
        }
    }

    private void loadManagedNodes() throws FabricException {
        try {
            this.managedNodes.load(false);
        }
        catch (TFCacheException exception) {
            Exception cause = Utils.getCause(exception, JSerializerException.class);
            if (cause != null) {
                this.logWarning("Trying to load system table 'ManagedNodes' from old format...");
                if (!this.loadOldManagedNodes()) {
                    throw exception;
                }
            }
            throw exception;
        }
    }

    @Override
    protected void doDestroy() {
        this.dropLogEventConsumer();
        this.managedNodesStarter = null;
        this.stateMonitor = null;
        super.doDestroy();
    }

    @Override
    protected Container.StdinShutdownInitiator createShutdownInitiator() {
        return new Container.StdinShutdownInitiator(){

            @Override
            protected void processOtherCommand(String command) {
                if (command.equals("shutdown all")) {
                    MNodeContainer.this.onShutdownAll();
                    super.doShutdown(command);
                }
            }
        };
    }

    @Override
    protected void doStart() {
        super.doStart();
        this.activator.start();
        this.stateMonitor.start();
        if (!((MNodeLauncher)this.launcher).noAutoStart) {
            this.managedNodesStarter.start();
        }
    }

    @Override
    protected void doStop() {
        if (this.managedNodesStarter != null) {
            this.managedNodesStarter.stop();
        }
        if (this.stateMonitor != null) {
            this.stateMonitor.stop();
        }
        if (this.activator != null) {
            this.activator.stop();
        }
        super.doStop();
    }

    @Override
    protected void onContextUnload() {
        if (this.activator != null) {
            this.activator.destroy();
            this.activator = null;
        }
        super.onContextUnload();
    }

    void onShutdownAll() {
        if (this.activator != null && this.activator.isReady()) {
            this.invokeRequestToActivator((byte)4);
        }
    }

    void onRestart() {
        this.invokeRequestToActivator((byte)3);
    }

    long getProcessID() {
        return MNodeContainer.getContext().getModerator().getFabricNode().getProcessID();
    }

    public String getUserName() {
        return MNodeContainer.getContext().getUserName();
    }

    public String getPassword() {
        return MNodeContainer.getContext().getPassword();
    }

    @Override
    protected FabricConnection getFabricConnection() {
        return super.getFabricConnection();
    }

    @Override
    protected String getConnectionFullName(String nodeName) {
        return super.getConnectionFullName(nodeName);
    }

    @Override
    protected List<FabricNodeReference> getMNodes() {
        return super.getMNodes();
    }

    @Override
    protected ManagementNode getManagementNodeObject(String nodeName) throws Exception {
        return super.getManagementNodeObject(nodeName);
    }

    @Override
    protected SLSession createSLSession() throws FabricConnectionException, SLSessionException {
        return super.createSLSession();
    }

    @Override
    protected SLSession createSLSession(String nodeName) throws FabricConnectionException, SLSessionException {
        return super.createSLSession(nodeName);
    }

    @Override
    protected RequestConsumerReference createRequestConsumer(String name, FabricRequestListener listener, EventScope eventScope) throws Exception {
        return super.createRequestConsumer(name, listener, eventScope);
    }

    @Override
    public void dropSystemConsumer(String name) {
        super.dropSystemConsumer(name);
    }

    @Override
    protected void raiseEvent(ImmutableEventDatagram event, EventScope eventScope) throws Exception {
        super.raiseEvent(event, eventScope);
    }

    ManagedNodes getManagedNodes() {
        return this.managedNodes;
    }

    synchronized void onNodeConnect(FabricNodeReference node) {
        ManagedNode managedNode = this.managedNodes.getNode(node.getName());
        if (managedNode != null) {
            managedNode.setLastAttachTime(System.currentTimeMillis());
            this.setRunningState(node, managedNode);
        }
    }

    synchronized void onNodeDisconnect(FabricNodeReference node, boolean normal) {
        ManagedNode managedNode = this.managedNodes.getNode(node.getName());
        if (managedNode != null) {
            managedNode.setLastDetachTime(System.currentTimeMillis());
            if (MNodeContainer.isNodeStopped(managedNode)) {
                this.setStoppedState(managedNode);
            } else if (normal) {
                managedNode.setState(ManagedNode.State.DETACHED);
                this.raiseStateAdvisory(managedNode);
            } else {
                this.setSuspectState(managedNode);
            }
        }
    }

    synchronized boolean checkStoppedState(ManagedNode managedNode) {
        if (managedNode.getState() != ManagedNode.State.STOPPED) {
            if (MNodeContainer.isNodeStopped(managedNode)) {
                this.setStoppedState(managedNode);
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean isNodeStopped(ManagedNode managedNode) {
        ContainerLockSupport.RemoteNodeLock nodeLock = ContainerLockSupport.getRemoteNodeLock(managedNode.getDir());
        try {
            return !nodeLock.existsLockFile() || !nodeLock.isLockedByAnotherVM();
        }
        catch (IOException exception) {
            return false;
        }
    }

    private void setRunningState(FabricNodeReference fabricNode, ManagedNode managedNode) {
        try {
            ManagementNode mnode = this.getManagementNodeObject(managedNode.getName());
            if (mnode == null) {
                this.logError("Obtaining ManagementNode object from node '" + managedNode.getName() + "' failed. Skipping status update...");
            } else if (!MNodeContainer.getContext().getName().equalsIgnoreCase(mnode.getName())) {
                this.logError("Wrong node name '" + mnode.getName() + "' in ManagementNode object of node '" + managedNode.getName() + "' (expected '" + MNodeContainer.getContext().getName() + "'). Skipping status update...");
            } else {
                managedNode.setState(ManagedNode.State.RUNNING);
                managedNode.setPid(fabricNode.getProcessID());
                this.raiseStateAdvisory(managedNode);
            }
        }
        catch (Exception exception) {
            this.logException(exception);
            this.logError("Setting RUNNING state to managed node '" + managedNode.getName() + "' failed.");
        }
    }

    void setStoppedState(ManagedNode managedNode) {
        managedNode.setState(ManagedNode.State.STOPPED);
        managedNode.setProcess(null);
        managedNode.setPid(-1);
        this.raiseStateAdvisory(managedNode);
    }

    private void setSuspectState(ManagedNode managedNode) {
        managedNode.setState(ManagedNode.State.SUSPECT);
        this.raiseStateAdvisory(managedNode);
    }

    private void raiseStateAdvisory(ManagedNode managedNode) {
        try {
            this.raiseAdvisory(new ManagedNodeStateAdvisory(managedNode.getName(), managedNode.getState(), managedNode.getPid()));
        }
        catch (Exception exception) {
            this.logException(exception);
            this.logError("Raising ManagedNodeStateAdvisory for managed node '" + managedNode.getName() + "' failed.");
        }
    }

    void invokeRequestToActivator(byte type) {
        try {
            if (this.activator != null) {
                this.activator.invokeRequest(type);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Sending command to Activator failed.");
        }
    }

    @Override
    protected Object invokeRoutedContainerRequest(String nodeName, byte[] data, long timeout) throws Exception {
        return super.invokeRoutedContainerRequest(nodeName, data, timeout);
    }

    @Override
    protected Map<String, Object> broadcastRoutedContainerRequest(byte[] data, long timeout) throws Exception {
        return super.broadcastRoutedContainerRequest(data, timeout);
    }

    @Override
    protected byte[] invokeRoutedRequest(byte[] data, long timeout) throws Exception {
        if (this.activator != null) {
            return this.activator.invokeRoutedRequest(data, timeout);
        }
        throw new FabricException("Connection with Activator is not established.");
    }

    void sendMessage(Object message) throws Exception {
        if (this.activator != null) {
            this.activator.sendMessage(message);
        }
    }

    void sendMessage(long sessionId, Object message) throws Exception {
        if (this.activator != null) {
            this.activator.sendMessage(sessionId, message);
        }
    }

    Map<String, String> getNodeLogs() {
        HashMap<String, String> result = new HashMap<String, String>();
        File logFile = TraceConfigurator.getInstance().getLogFile();
        if (logFile != null) {
            result.put(MNodeContainer.getContext().getName(), logFile.getAbsolutePath());
        }
        for (ManagedNode node : this.managedNodes.getNodes()) {
            File nodeLog = new File(node.getLog());
            result.put(node.getName(), nodeLog.isAbsolute() ? nodeLog.getAbsolutePath() : new File(node.getDir() + "/" + node.getLog()).getAbsolutePath());
        }
        return result;
    }

    File getLogFile(String nodeName) throws Exception {
        ManagedNode node = this.getManagedNodes().getNode(nodeName);
        if (node != null) {
            File logFile = new File(node.getLog());
            if (!logFile.exists()) {
                logFile = new File(new File(node.getDir()), node.getLog());
            }
            return logFile.getCanonicalFile();
        }
        throw new Exception("Node not found.");
    }

    File getWorkingDir(String nodeName) throws Exception {
        ManagedNode node = this.getManagedNodes().getNode(nodeName);
        if (node != null) {
            return new File(node.getDir()).getCanonicalFile();
        }
        throw new Exception("Node not found.");
    }

    Object uploadImage(ActivatorMFSession session, Map<String, Activator.ImageData> images, boolean withWait) {
        if (withWait) {
            this.doUploadImage(session, images);
            return new SLResponse();
        }
        FabricThreadManager.getInstance().createThread("FSYS:Activator.UploadImage", "Uploads images to management nodes.", () -> {
            Utils.sleep(500L);
            this.doUploadImage(session, images);
            this.raiseNullSLMessage(session);
        }).start();
        return new PseudoSLResponse();
    }

    private void doUploadImage(ActivatorMFSession session, Map<String, Activator.ImageData> images) {
        List<FabricNodeReference> mnodes = this.getMNodes();
        for (Map.Entry<String, Activator.ImageData> entry : images.entrySet()) {
            this.doUploadImage(mnodes, session, entry.getKey(), entry.getValue());
        }
    }

    private void doUploadImage(List<FabricNodeReference> mnodes, ActivatorMFSession session, String version, Activator.ImageData image) {
        for (FabricNodeReference mnode : mnodes) {
            if (image.nodes != null && !image.nodes.remove(mnode.getName())) continue;
            this.raiseSLMessage("\nSynchronizing image " + version + " in " + mnode.getName() + "...\n\n", session);
            try (FileInputStream inputFileStream = new FileInputStream(image.filename);){
                SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(this.getConnectionFullName(mnode.getName()), message -> this.raiseSLMessage(new SLMessage(((SLFileMessage)message).getText("upload"), (MFSession)session), session), image.filename, session.getSLSessionData().getTransferBufferSize());
                utils.createDirectory(Activator.getImageDir(version).getPath());
                utils.createFile(inputFileStream, inputFileStream.available(), true);
                this.raiseSLMessage("\nValidating image...", session);
                SLResponse response = this.invokeSlangRequest(mnode.getName(), new CompleteImageOperation.Definition(version, true), session, 5000L);
                if (!response.isOK() && response.getException() != null) {
                    throw response.getException();
                }
                this.raiseSLMessage(" OK", session);
                this.raiseSLMessage("\n\nImage " + version + " synchronized in " + mnode.getName() + ".\n", session);
                Utils.sleep(100L);
            }
            catch (Throwable exception) {
                this.raiseSLMessageError(Utils.formatException(exception), session);
            }
        }
    }

    Object startTnodes(ActivatorMFSession session, boolean atDomain, long tnodeTimeout) {
        return atDomain ? this.startAllTnodes(session, tnodeTimeout) : this.startTnodes(session, tnodeTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object startTnodes(ActivatorMFSession session, long tnodeTimeout) {
        try (EventAsyncConsumer slMessageConsumer = this.createSLMessageConsumer(session);){
            this.doStartTnodes(MNodeContainer.getContext().getName(), session, tnodeTimeout, false);
        }
        return new PseudoSLResponse();
    }

    private Object startAllTnodes(ActivatorMFSession session, long tnodeTimeout) {
        FabricThreadManager.getInstance().createThread("FSYS:Activator.StartTaskNodes", "Starts all task nodes in the sysplex.", () -> {
            try (EventAsyncConsumer slMessageConsumer = this.createSLMessageConsumer(session);){
                this.doStartTnodes(MNodeContainer.getContext().getName(), session, tnodeTimeout, true);
                for (FabricNodeReference mnode : this.getMNodes()) {
                    this.doStartTnodes(mnode.getName(), session, tnodeTimeout, true);
                }
                this.raiseNullSLMessage(session);
            }
        }).start();
        return new PseudoSLResponse();
    }

    private void doStartTnodes(String mnodeName, ActivatorMFSession session, long tnodeTimeout, boolean withMessage) {
        if (withMessage) {
            this.raiseSLMessage(START_TNODES_MESSAGE, mnodeName, session);
        }
        try {
            this.invokeSlangRequest(mnodeName, START_TNODES_STATEMENT, session, this.calculateTimeout(mnodeName, session, ManagedNode.State.STOPPED, tnodeTimeout));
        }
        catch (Exception exception) {
            this.raiseSLMessageError(exception.getMessage(), mnodeName, session);
        }
    }

    long getStartTnodesTimeout(ActivatorMFSession session, boolean atDomain, long tnodeTimeout) {
        long result = this.calculateTimeout(MNodeContainer.getContext().getName(), session, ManagedNode.State.STOPPED, tnodeTimeout);
        if (atDomain) {
            result += this.getMNodes().stream().mapToLong(mnode -> this.calculateTimeout(mnode.getName(), session, ManagedNode.State.STOPPED, tnodeTimeout)).sum();
        }
        return result;
    }

    Object stopTnodes(ActivatorMFSession session, boolean atDomain, long tnodeTimeout, boolean onRestart) {
        if (onRestart) {
            this.doStopTnodes(session, tnodeTimeout, false);
            return new SLResponse();
        }
        FabricThreadManager.getInstance().createThread("FSYS:Activator.StopTaskNodes", "Stops all task nodes in the sysplex.", () -> this.doStopTnodes(session, tnodeTimeout, true)).start();
        return new PseudoSLResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStopTnodes(ActivatorMFSession session, long tnodeTimeout, boolean raiseNull) {
        try (EventAsyncConsumer slMessageConsumer = this.createSLMessageConsumer(session);){
            this.doStopTnodes(MNodeContainer.getContext().getName(), session, tnodeTimeout);
            for (FabricNodeReference mnode : this.getMNodes()) {
                this.doStopTnodes(mnode.getName(), session, tnodeTimeout);
            }
            if (raiseNull) {
                this.raiseNullSLMessage(session);
            }
        }
    }

    private void doStopTnodes(String mnodeName, ActivatorMFSession session, long tnodeTimeout) {
        this.raiseSLMessage(STOP_TNODES_MESSAGE, mnodeName, session);
        try {
            this.invokeSlangRequest(mnodeName, STOP_TNODES_STATEMENT, session, this.calculateTimeout(mnodeName, session, ManagedNode.State.RUNNING, tnodeTimeout));
        }
        catch (Exception exception) {
            this.raiseSLMessageError(exception.getMessage(), mnodeName, session);
        }
    }

    private long calculateTimeout(String mnodeName, ActivatorMFSession session, ManagedNode.State tnodeState, long tnodeTimeout) {
        try {
            long result = 0L;
            SLResponse response = this.invokeSlangRequest(mnodeName, new ListManagedNodesOperation.Definition(mnodeName), session, 5000L);
            if (response.getRowSet() != null) {
                RowSet rowSet = response.getRowSet();
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    if (!rowSet.getString(2).equals(tnodeState.name())) continue;
                    result += tnodeTimeout;
                }
            }
            return result != 0L ? result * 1000L : 5000L;
        }
        catch (Exception exception) {
            return 600000L;
        }
    }

    @Override
    protected void joinSysplex(ActivatorMFSession session) throws FabricException {
        try {
            super.joinSysplex(session);
        }
        catch (Exception exception) {
            if (exception instanceof FabricException) {
                throw (FabricException)exception;
            }
            throw new FabricException("Joining the sysplex failed.", exception);
        }
    }

    public List<String> getTnodeNames() {
        return this.managedNodes.getNodes().stream().map(ManagedNode::getName).collect(Collectors.toList());
    }

    SLResponse checkTnodes(String nodeName, ActivatorMFSession session) throws FabricException {
        try {
            return MNodeContainer.getContext().getLexiconProcessor().invoke(new ListManagedNodesOperation.Definition(nodeName == null ? "*" : nodeName), (MFSession)session, 5000L);
        }
        catch (Exception exception) {
            throw new FabricException("Checking state of task nodes failed.", exception);
        }
    }

    SLResponse stopMnodes(ActivatorMFSession session, long nodeTimeout) throws FabricException {
        FabricThreadManager.getInstance().createThread("FSYS:Activator.StopManagementNodes", "Stops all management nodes in the sysplex.", () -> {
            try (EventAsyncConsumer slMessageConsumer = this.createSLMessageConsumer(session);){
                for (FabricNodeReference mnode : this.getMNodes()) {
                    this.doStopMnode(mnode.getName(), session, nodeTimeout, ShutdownOperation.ShutdownMode.ALL);
                }
                this.doStopMnode(MNodeContainer.getContext().getName(), session, nodeTimeout, null);
                this.raiseNullSLMessage(session);
            }
        }).start();
        return new PseudoSLResponse();
    }

    private void doStopMnode(String nodeName, ActivatorMFSession session, long timeout, ShutdownOperation.ShutdownMode shutdownMode) {
        this.raiseSLMessage("\nStopping management node " + nodeName + "...\n", session);
        try {
            this.invokeSlangRequest(nodeName, new ShutdownOperation.Definition(false, timeout, shutdownMode), session, timeout * 2L * 1000L);
        }
        catch (Exception exception) {
            this.raiseSLMessageError(exception.getMessage(), nodeName, session);
        }
    }

    private EventAsyncConsumer createSLMessageConsumer(ActivatorMFSession session) {
        try {
            if (session.getSessionId() != -1L) {
                EventAsyncConsumer result = this.createAsyncConsumer("SLMessageListener_Activator_" + SL_MESSAGE_CONSUMER_ALLOCATOR.getNumber(), event -> {
                    try {
                        this.raiseSLMessage((SLMessage)((OpaqueDatagram)event).getData(), session);
                    }
                    catch (Exception exception) {
                        this.logException(exception);
                    }
                }, "e.sys.sl.Message", "eventKey = '" + session.getComponentName() + ":" + session.getSLSessionName() + "'");
                result.start();
                return result;
            }
        }
        catch (Exception exception) {
            this.logException(exception, "Creating SLMessage listener failed.");
        }
        return null;
    }

    SLResponse listNodes(ActivatorMFSession session) throws FabricException {
        try {
            return this.invokeSlangRequest(new ListNodesOperation.Definition(), session, 5000L);
        }
        catch (Exception exception) {
            if (exception instanceof FabricException) {
                throw (FabricException)exception;
            }
            throw new FabricException("Command failed.", exception);
        }
    }

    protected List<String> getMnodeNames() {
        return this.getMNodes().stream().map(FabricNodeReference::getName).collect(Collectors.toList());
    }

    void createCluster(ActivatorMFSession session, FabricCluster cluster) throws FabricException {
        if (MNodeContainer.getContext().isClustered()) {
            throw new FabricException("Management node is already in cluster. Drop existing cluster first.");
        }
        try {
            MNodeFabricClusterFactory.putObjectToRepository(cluster);
            this.updateDeploymentDescriptor(DeployUtils.getDdxLocation(MNodeContainer.getContext()), cluster.getName(), true);
        }
        catch (Exception exception) {
            throw new FabricException("Storing cluster descriptor in management node failed.", exception);
        }
        for (ManagedNode node : this.managedNodes.getNodes()) {
            try {
                MNodeFabricClusterFactory.copyObject(cluster, node);
                this.updateDeploymentDescriptor(new File(AbstractMNodeOperation.getAbsoluteDdx(node)), cluster.getName(), true);
            }
            catch (Exception exception) {
                this.raiseSLMessageError(exception.getMessage(), session);
                this.raiseSLMessageError("Storing cluster descriptor in tnode '" + node.getName() + " ' failed.", session);
            }
        }
    }

    void dropCluster(ActivatorMFSession session) throws FabricException {
        if (!MNodeContainer.getContext().isClustered()) {
            throw new FabricException("Management node is not in cluster.");
        }
        try {
            MNodeFabricClusterFactory.dropObjectFromRepository();
            this.updateDeploymentDescriptor(DeployUtils.getDdxLocation(MNodeContainer.getContext()), null, false);
        }
        catch (Exception exception) {
            throw new FabricException("Deleting cluster descriptor from management node failed.", exception);
        }
        for (ManagedNode node : this.managedNodes.getNodes()) {
            try {
                MNodeFabricClusterFactory.removeObject(node);
                this.updateDeploymentDescriptor(new File(AbstractMNodeOperation.getAbsoluteDdx(node)), null, false);
            }
            catch (Exception exception) {
                this.raiseSLMessageError(exception.getMessage(), session);
                this.raiseSLMessageError("Deleting cluster descriptor from tnode '" + node.getName() + " ' failed.", session);
            }
        }
    }

    private void updateDeploymentDescriptor(File ddxLocation, String clusterName, boolean clusterEnabled) throws Exception {
        CtxDeploymentDescriptor descriptor = DeployUtils.getDeploymentDescriptor(ddxLocation);
        descriptor.setClusterName(clusterName);
        descriptor.setClusterEnabled(clusterEnabled);
        StDeployGenerator.generate(ddxLocation, descriptor);
    }

    private void raiseNullSLMessage(ActivatorMFSession session) {
        this.raiseSLMessage((String)null, session);
    }

    private void raiseSLMessage(String message, String nodeName, ActivatorMFSession session) {
        if (message != null) {
            this.raiseSLMessage("\n" + message + " in " + nodeName + "...\n", session);
        }
    }

    private void raiseSLMessageError(String message, String nodeName, ActivatorMFSession session) {
        if (message != null) {
            this.raiseSLMessageError("\n" + message + " in " + nodeName + ".\n", session);
        }
    }

    private void raiseSLMessage(String text, ActivatorMFSession session) {
        this.raiseSLMessage(new SLMessage(text, (MFSession)session), session);
    }

    private void raiseSLMessageError(String text, ActivatorMFSession session) {
        this.raiseSLMessage(new SLMessage(text, false, (MFSession)session), session);
    }

    private void raiseSLMessage(SLMessage message, ActivatorMFSession session) {
        try {
            if (session.getSessionId() != -1L) {
                if (this.activator != null) {
                    this.activator.sendMessage(session.getSessionId(), message);
                }
            } else {
                this.raiseSLMessage(message);
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    @Override
    protected void raiseSLMessage(SLMessage message) throws Exception {
        super.raiseSLMessage(message);
    }

    void raiseLogEvent(LogEventSource source, TraceRecord trace, EventScope eventScope) throws Exception {
        super.raiseEvent(com.streamscape.tools.log.monitor.Utils.createEvent(source, trace), eventScope);
    }

    void createLogEventConsumer() {
        try {
            this.createAsyncConsumer("LogEventListener_Activator", event -> {
                try {
                    this.resetEvent(event);
                    if (this.activator != null) {
                        this.activator.sendMessage(event);
                    }
                }
                catch (Exception exception) {
                    this.logException(exception, "Forwarding Log event to Activator failed.");
                }
            }, "event.log.monitor.Stream", null).start();
        }
        catch (Exception exception) {
            this.logException(exception, "Creation consumer for Log Event forwarding failed.");
        }
    }

    private void dropLogEventConsumer() {
        this.dropSystemConsumer("LogEventListener_Activator");
    }

    @Override
    protected void logError(String message) {
        Trace.logError(MNodeContainer.class, message);
    }

    @Override
    protected void logInfo(String message) {
        Trace.logInfo(MNodeContainer.class, message);
    }

    @Override
    protected void logDebug(String message) {
        Trace.logDebug(MNodeContainer.class, message);
    }

    @Override
    protected void logException(Throwable exception) {
        Trace.logException(MNodeContainer.class, exception, true);
    }

    protected void logException(Throwable exception, String message) {
        this.logException(exception);
        this.logError(message);
    }

    protected void logWarning(String message) {
        this.logInfo("WARNING: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadOldManagedNodes() {
        SemanticType managedNodeType = this.lookupSemanticClass(ManagedNode.class);
        SerialSupport managedNodeSerialSupport = MNodeContainer.getSerialSupport(managedNodeType);
        try {
            this.doLoadOldManagedNodes(managedNodeType, this.createSchema1ForManagedNode());
        }
        catch (Throwable exception1) {
            try {
                this.doLoadOldManagedNodes(managedNodeType, this.createSchema2ForManagedNode());
            }
            catch (Throwable exception2) {
                this.logException(exception1);
                this.logException(exception2, "Loading system table 'ManagedNodes' from old format failed.");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            MNodeContainer.setSerialSupport(managedNodeType, managedNodeSerialSupport);
        }
        return true;
    }

    private void doLoadOldManagedNodes(SemanticType managedNodeType, SerialSchema serialSchema) throws Exception {
        this.setSerialSupport(managedNodeType, ManagedNode.class, serialSchema);
        ManagedNodes nodes = new ManagedNodes();
        nodes.load(false);
        nodes.save();
        this.managedNodes = nodes;
    }

    private SerialSchema createSchema1ForManagedNode() {
        SerialSchema result = new SerialSchema();
        result.addField("autoStart", "java.lang.Boolean", false, false);
        result.addField("checkedOutBy", "java.lang.String", false, false);
        result.addField("ddx", "java.lang.String", false, false);
        result.addField("debug", "java.lang.Boolean", false, false);
        result.addField("delayBeforeStart", "java.lang.Integer", false, false);
        result.addField("dir", "java.lang.String", false, false);
        result.addField("execDir", "java.lang.String", false, false);
        result.addField("javaArgs", "java.lang.String", false, false);
        result.addField("javaCfg", "java.lang.String", false, false);
        result.addField("javaHome", "java.lang.String", false, false);
        result.addField("log", "java.lang.String", false, false);
        result.addField("logBroadcast", "java.lang.Boolean", false, false);
        result.addField("name", "java.lang.String", false, false);
        result.addField("startTimeout", "java.lang.Long", false, false);
        return result;
    }

    private SerialSchema createSchema2ForManagedNode() {
        SerialSchema result = new SerialSchema();
        result.addField("admin", "java.lang.Integer", false, false);
        result.addField("autoStart", "java.lang.Boolean", false, false);
        result.addField("checkedOutBy", "java.lang.String", false, false);
        result.addField("ddx", "java.lang.String", false, false);
        result.addField("debug", "java.lang.Boolean", false, false);
        result.addField("delayBeforeStart", "java.lang.Integer", false, false);
        result.addField("dir", "java.lang.String", false, false);
        result.addField("execDir", "java.lang.String", false, false);
        result.addField("javaArgs", "java.lang.String", false, false);
        result.addField("javaCfg", "java.lang.String", false, false);
        result.addField("javaHome", "java.lang.String", false, false);
        result.addField("log", "java.lang.String", false, false);
        result.addField("logBroadcast", "java.lang.Boolean", false, false);
        result.addField("name", "java.lang.String", false, false);
        result.addField("startTimeout", "java.lang.Long", false, false);
        return result;
    }

    public static class MNodeLauncher
    extends Container.ContainerLauncher {
        String javaExePath;
        boolean noAutoStart = false;

        @Override
        protected void printDescription(PrintStream stream) {
            stream.println("\n    TruFabric Management Node\n    Release " + Version.getVersion());
        }

        @Override
        protected int parseOtherArg(String arg, String[] args, int index) {
            if (arg.equals(MNodeContainer.JAVA_EXE_PATH_PARAMETER)) {
                if (this.javaExePath != null) {
                    this.exit("Parsing error: several '-java-exe-path' parameters specified.");
                }
                if (++index >= args.length) {
                    this.exit("Parsing error: value of '-java-exe-path' parameter missed.");
                }
                this.javaExePath = args[index];
            } else if (arg.equals(MNodeContainer.NO_AUTO_START_PARAMETER)) {
                this.noAutoStart = true;
            } else {
                return super.parseOtherArg(arg, args, index);
            }
            return index;
        }

        @Override
        protected String getJavaParametersHelp() {
            return "";
        }

        @Override
        protected void printJavaParametersDescription() {
        }

        @Override
        protected String getExecutableName() {
            return "mnode";
        }

        @Override
        protected String getTraceFilename() {
            return "mnode.traces";
        }

        @Override
        protected void initRuntimeInstance() {
            MNodeRuntimeContext.getInstance();
        }

        @Override
        protected ContainerFactory getContainerFactory() {
            return new MNodeContainerFactory(RuntimeContext.getInstance());
        }
    }

    private class StateMonitor
    extends MonitorWorker {
        protected StateMonitor() throws FabricException {
            super("FSYS:MNode:StateMonitor", "Monitors a state of managed nodes.", 60000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doExecute() throws FabricException {
            MNodeContainer mNodeContainer = MNodeContainer.this;
            synchronized (mNodeContainer) {
                MNodeContainer.this.getManagedNodes().getNodes().stream().filter(managedNode -> !managedNode.isStartOrStopOperationInProgress()).forEach(managedNode -> {
                    FabricNodeReference fabricNode = MNodeContainer.this.getFabricNode(managedNode.getName());
                    if (fabricNode != null && fabricNode.isReady()) {
                        if (!managedNode.isRunning()) {
                            MNodeContainer.this.setRunningState(fabricNode, (ManagedNode)managedNode);
                        }
                    } else if (MNodeContainer.isNodeStopped(managedNode)) {
                        if (managedNode.getState() != ManagedNode.State.STOPPED) {
                            MNodeContainer.this.setStoppedState((ManagedNode)managedNode);
                        }
                    } else if (managedNode.getState() == ManagedNode.State.SUSPECT) {
                        MNodeContainer.this.raiseStateAdvisory((ManagedNode)managedNode);
                    } else if (managedNode.getState() == ManagedNode.State.DETACHED) {
                        if (managedNode.lastDetachTime > 0L && System.currentTimeMillis() - managedNode.lastDetachTime >= 60000L) {
                            MNodeContainer.this.setSuspectState((ManagedNode)managedNode);
                        }
                    } else {
                        MNodeContainer.this.setSuspectState((ManagedNode)managedNode);
                    }
                });
            }
        }
    }

    private class ManagedNodesStarter
    extends SingleTaskWorker {
        protected ManagedNodesStarter() {
            super("FSYS:MNode.ManagedNodesStarter", "Starts managed nodes.");
        }

        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            List nodes;
            if (!MNodeContainer.this.managedNodes.isEmpty() && !(nodes = MNodeContainer.this.getManagedNodes().getNodes().stream().filter(ManagedNode::isAutoStart).collect(Collectors.toList())).isEmpty()) {
                SLSession session;
                Thread.sleep(1000L);
                Trace.logInfo(this, "Auto starting managed nodes...");
                try {
                    session = MNodeContainer.this.createSLSession();
                }
                catch (Exception exception) {
                    MNodeContainer.this.logException(exception);
                    MNodeContainer.this.logError("Opening SLANG session failed.");
                    return;
                }
                for (ManagedNode node : nodes) {
                    if (node.isRunning()) {
                        MNodeContainer.this.logInfo("Managed node '" + node.getName() + "' already running.");
                        continue;
                    }
                    if (node.isOperationInProgress()) {
                        MNodeContainer.this.logInfo("Operation " + node.isOperationInProgress() + " already running for managed node '" + node.getName() + "'.");
                        continue;
                    }
                    MNodeContainer.this.logInfo("Starting managed node '" + node.getName() + "'...");
                    try {
                        SLResponse response;
                        if (node.getDelayBeforeStart() != 0) {
                            try {
                                Thread.sleep(node.getDelayBeforeStart() * 1000);
                            }
                            catch (InterruptedException exception) {
                                session.close();
                                throw exception;
                            }
                        }
                        if (!(response = session.slangRequest("start managed node " + node.getName() + " timeout " + node.getStartTimeout() + " with wait", (node.getStartTimeout() + 10L) * 1000L)).isOK()) {
                            MNodeContainer.this.logError("Staring managed node '" + node.getName() + "' failed. Cause: " + String.valueOf(response.getText() != null ? response.getText() : response.getException()));
                            continue;
                        }
                        MNodeContainer.this.logInfo("Managed node '" + node.getName() + "' started.");
                    }
                    catch (Exception exception) {
                        MNodeContainer.this.logException(exception);
                        MNodeContainer.this.logError("Staring managed node '" + node.getName() + "' failed.");
                    }
                }
                session.close();
                Trace.logInfo(this, "Managed nodes started.");
            }
        }
    }

    static class NodeCompletionAdviser
    extends AtNodeOrAtDomainModifier.NodeCompletionAdviser<MNodeRuntimeContext> {
        NodeCompletionAdviser() {
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, MNodeRuntimeContext callable, MFSession session) {
            return callable.getManagedNodes().stream().map(ManagedNode::getName).collect(Collectors.toList());
        }
    }
}

