/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.Utils;
import java.util.List;
import java.util.stream.Collectors;

public class KillNodeOperation
extends com.streamscape.runtime.mf.operation.moderator.KillNodeOperation<MNodeRuntimeContext> {
    public KillNodeOperation() {
        super(true);
        this.syntax.addTag(OperationTag.mnode);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        super.doFillCompletionsList(comp, session, completions);
        completions.addAll(((MNodeRuntimeContext)this.callable).getManagedNodes().stream().filter(node -> node.getState() == ManagedNode.State.DETACHED || node.getState() == ManagedNode.State.SUSPECT).map(ManagedNode::getName).collect(Collectors.toList()));
    }

    @Override
    protected Pair<FabricNodeReference, Integer> lookupNodeAndPid(String nodeName) throws Exception {
        FabricNodeReference node = this.lookupNode(nodeName);
        if (node == null) {
            ManagedNode managedNode = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(nodeName);
            if (managedNode == null) {
                throw new FabricException("Node not found.");
            }
            if (managedNode.getState() == ManagedNode.State.STOPPED) {
                throw new FabricException("Node is not running.");
            }
            return new Pair<Object, Integer>(null, managedNode.getPid());
        }
        return new Pair<FabricNodeReference, Integer>(node, node.getProcessID());
    }

    @Override
    protected void onKillNode(String nodeName) {
        Utils.sleep(500L);
        ManagedNode managedNode = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(nodeName);
        if (managedNode != null && managedNode.getState() != ManagedNode.State.STOPPED) {
            managedNode.setState(ManagedNode.State.STOPPED);
        }
    }

    @Override
    protected void onRestartNode() {
        ((MNodeRuntimeContext)this.callable).container.onRestart();
    }
}

