/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.Utils;
import java.util.ArrayList;
import java.util.List;

public class InitManagedNodeOperation
extends AbstractMNodeOperation {
    private static final String NAME = "init managed node";

    public InitManagedNodeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("INIT MANAGED NODE").addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.addCompletionCommand("list managed nodes");
        this.syntax.setDescription("Initializes the specified node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NodeName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ManagedNode node = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.nodeName);
        if (node == null) {
            return new SLResponse("Node not found.", false);
        }
        if (node.isRunning()) {
            return new SLResponse("Node already running.", false);
        }
        ArrayList<String> commandArgs = new ArrayList<String>();
        Utils.fillCommandArgs(node, ((MNodeRuntimeContext)this.callable).getSTRootDir(), "-init", commandArgs);
        Trace.logInfo(this, ((Object)commandArgs).toString());
        Process process = Utils.startProcessAsChild(commandArgs.toArray(new String[commandArgs.size()]));
        return new SLResponse();
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
            if (node == null || node.isRunning()) continue;
            completions.add(node.getName());
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;

        public Definition(String nodeName) {
            super(InitManagedNodeOperation.NAME);
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

