/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sef.FabricException;
import com.streamscape.sef.deploy.DeploymentAdvisoryType;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.tools.mnode.AbstractImportManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;

public class ImportManagedNodeOperation
extends AbstractImportManagedNodeOperation {
    private static final String NAME = "import managed node";

    public ImportManagedNodeOperation() {
        super(NAME);
        this.syntax.setDescription("Imports the content of specified Fabric Resource Module into the specified managed node.\nThis operation replaces existing files in the node directory with the files from the FRM.\nThe original deployment descriptor is retained and not replaced by the one from FRM.\nThe node must be stopped and not be checked out.\n\nIf you want to first erase all files in the node directory, use the 'restore managed node' command instead.\n");
        this.syntax.setExamples("import managed node TestNode1 from 'C:/Streamscape/resources/Node.frm' with wait");
    }

    @Override
    protected boolean isOperationAllowed(ManagedNode node) {
        return super.isOperationAllowed(node) && node.getCheckedOutBy() == null;
    }

    @Override
    protected void doCheckBeforeExecute(ManagedNode node, MFSession session) throws Exception {
        if (node.getCheckedOutBy() != null) {
            throw new FabricException("Node checked out by '" + node.getCheckedOutBy() + "'. It should be either checked in or reverted.");
        }
    }

    @Override
    protected void doCompleteExecution(AbstractFrmNodeOperation.Definition definition, ManagedNode node) throws Exception {
        ImportManagedNodeOperation.raiseDeploymentAdvisory((MNodeRuntimeContext)this.callable, DeploymentAdvisoryType.NODE_UPDATED, definition.getNodeName(), ((MNodeRuntimeContext)this.callable).getName());
    }
}

