/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CaseInsensitiveCompletionAdviser;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import java.util.List;
import java.util.stream.Collectors;

public class ForceManagedNodeStateOperation
extends AbstractMNodeOperation {
    private static final String NAME = "force managed node state";

    public ForceManagedNodeStateOperation() {
        super(true, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("FORCE MANAGED NODE").addActionParameter((SyntaxParameter)new IdentifierParameter("NodeName").setCompletionAdviser(new CaseInsensitiveCompletionAdviser<MNodeRuntimeContext>(this){

            @Override
            public List<String> getCompletions(String script, String processedScript, MNodeRuntimeContext callable, MFSession session) {
                return callable.getManagedNodes().stream().filter(node -> node != null).map(ManagedNode::getName).collect(Collectors.toList());
            }
        }));
        this.syntax.setSubject((Subject)new Subject("STATE").addParameter(new EnumParameter("NodeState", ManagedNode.State.class)));
        this.syntax.setDescription("Forcibly sets the specified state for the specified node.");
        this.syntax.setExamples("force managed node Node1 state running");
        this.syntax.addCompletionCommand("list managed nodes");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NodeName").getValue(), ManagedNode.State.valueOf(statement.getParameter("NodeState").getValue()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ManagedNode node = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.nodeName);
        if (node == null) {
            return new SLResponse("Node not found.", false);
        }
        node.setState(definition.state);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private ManagedNode.State state;

        public Definition(String nodeName, ManagedNode.State state) {
            super(ForceManagedNodeStateOperation.NAME);
            this.nodeName = nodeName;
            this.state = state;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public ManagedNode.State getState() {
            return this.state;
        }
    }
}

