/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.container.ContainerLockSupport;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNode;
import com.streamscape.tools.mnode.ManagementNodeFactory;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DescribeManagedNodeOperation
extends AbstractMNodeOperation {
    private static final String NAME = "describe managed node";

    public DescribeManagedNodeOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE MANAGED NODE").addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.addCompletionCommand("list managed nodes");
        this.syntax.setDescription("Shows information about the specified node.");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((MNodeRuntimeContext)this.callable).getManagedNodes().stream().filter(Objects::nonNull).map(ManagedNode::getName).collect(Collectors.toList()));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NodeName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String error;
        ContainerLockSupport.RemoteNodeLock lock;
        Definition definition = (Definition)statement;
        ManagedNode node = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.nodeName);
        if (node == null) {
            return new SLResponse("Node not found.", false);
        }
        RowSet result = new RowSet(DescribeManagedNodeOperation.createResultDescriptor());
        DescribeManagedNodeOperation.addValues(result, "Name", node.getName());
        DescribeManagedNodeOperation.addValues(result, "State", node.getState().name());
        DescribeManagedNodeOperation.addValues(result, "Autostart", node.isAutoStart());
        DescribeManagedNodeOperation.addValues(result, "Delay Before Start", node.getDelayBeforeStart());
        DescribeManagedNodeOperation.addValues(result, "Start Timeout", node.getStartTimeout());
        DescribeManagedNodeOperation.addValues(result, "Start Order", ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNodeIndex(node.getName()) + 1);
        DescribeManagedNodeOperation.addValues(result, "-dir", node.getDir());
        DescribeManagedNodeOperation.addValues(result, "-ddx", node.getDdx());
        DescribeManagedNodeOperation.addValues(result, "-exec-dir", DescribeManagedNodeOperation.skipNull(node.getExecDir()));
        DescribeManagedNodeOperation.addValues(result, "-java-cfg", DescribeManagedNodeOperation.skipNull(node.getJavaCfg()));
        DescribeManagedNodeOperation.addValues(result, "-java-args", DescribeManagedNodeOperation.skipNull(node.getJavaArgs()));
        DescribeManagedNodeOperation.addValues(result, "-java-home", DescribeManagedNodeOperation.skipNull(node.getJavaHome()));
        DescribeManagedNodeOperation.addValues(result, "-log", node.getLog());
        DescribeManagedNodeOperation.addValues(result, "-log-broadcast", node.isLogBroadcast());
        DescribeManagedNodeOperation.addValues(result, "-debug", node.isDebug());
        DescribeManagedNodeOperation.addValues(result, "-admin", DescribeManagedNodeOperation.skipNull(node.getAdmin()));
        DescribeManagedNodeOperation.addValues(result, "Last Connect Time", DescribeManagedNodeOperation.formatDate(node.getLastAttachTime()));
        DescribeManagedNodeOperation.addValues(result, "Last Disconnect Time", DescribeManagedNodeOperation.formatDate(node.getLastDetachTime()));
        DescribeManagedNodeOperation.addValues(result, "Checked Out", node.getCheckedOutBy() != null);
        DescribeManagedNodeOperation.addValues(result, "Checked Out By", DescribeManagedNodeOperation.skipNull(node.getCheckedOutBy()));
        this.addIsCheckoutCopy(node, result);
        if (node.getState() != ManagedNode.State.RUNNING && !(lock = ContainerLockSupport.getRemoteNodeLock(node.getDir())).isLockedByAnotherVM() && lock.existsLockFailFile() && (error = lock.getLockFailFileError()) != null && !error.isEmpty()) {
            DescribeManagedNodeOperation.addValues(result, "Startup Error", error);
        }
        return new SLResponse(result);
    }

    void addIsCheckoutCopy(ManagedNode node, RowSet result) {
        try {
            ManagementNode mnode;
            ManagementNode managementNode = mnode = node.getState() == ManagedNode.State.RUNNING ? ((MNodeRuntimeContext)this.callable).container.getManagementNodeObject(node.getName()) : ManagementNodeFactory.getObject(node);
            if (mnode != null) {
                DescribeManagedNodeOperation.addValues(result, "Is Check-out Copy", mnode.isCheckedOut());
            }
        }
        catch (Exception exception) {
            Trace.logException(ManagementNodeFactory.class, exception, false);
            Trace.logError(ManagementNodeFactory.class, "Obtaining ManagementNode object failed.");
        }
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(14);
        DescribeManagedNodeOperation.addColumn(result, "Property");
        DescribeManagedNodeOperation.addColumn(result, "Value");
        return result;
    }

    public static String formatDate(long time) {
        return time > 0L ? AbstractOperation.formatDate(time) : "n/a";
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;

        public Definition(String nodeName) {
            super(DescribeManagedNodeOperation.NAME);
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

