/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.deploy.DeploymentAdvisoryType;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.sef.service.ServiceManifest;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.tools.mnode.AddManagedNodeOperation;
import com.streamscape.tools.mnode.CreateManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNode;
import com.streamscape.tools.mnode.ManagementNodeFactory;
import com.streamscape.tools.mnode.SyncManagedOperation;
import com.streamscape.tools.mnode.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class DeployManagedNodeOperation
extends AbstractFrmNodeOperation<MNodeRuntimeContext> {
    private static final String NAME = "deploy managed node";
    private static final Set<String> EXCLUDED_PATHS = new HashSet<String>();

    public DeployManagedNodeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DEPLOY MANAGED NODE").addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("FROM").setName("FrmPathModifier")).addParameter(new SLFilePathParameter("FrmPath"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false).setName("WithWait"));
        this.syntax.setDescription("Adds a new node to the list of managed nodes and extracts its configuration from the specified FRM.\nAutomatically generates a deployment descriptor for the new node.");
        this.syntax.setExamples("deploy managed node TestNode1 from 'C:/Streamscape/resources/Node.frm'");
        this.syntax.addTag(OperationTag.mnode);
    }

    boolean isOperationAllowed(ManagedNode node) {
        return !node.isRunning();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NodeName").getValue(), statement.getParameter("FrmPath").getValue(), !statement.existsModifier("WithWait"));
    }

    @Override
    protected void checkBeforeExecute(AbstractFrmNodeOperation.Definition definition, MFSession session) throws Exception {
        AddManagedNodeOperation.checkError(!((MNodeRuntimeContext)this.callable).container.getManagedNodes().existsNode(definition.getNodeName()), "Managed node '" + definition.getNodeName() + "' already exists.");
        if (((MNodeRuntimeContext)this.callable).getModerator().listFabricNodes().contains(definition.getNodeName())) {
            throw new Exception("Node '" + definition.getNodeName() + "' already exists in sysplex.");
        }
    }

    @Override
    protected SLResponse execute(AbstractFrmNodeOperation.Definition definition, MFSession session, long timeout) throws Exception {
        boolean isNewNode = true;
        File nodeWorkingDir = new File("nodes" + File.separator + definition.getNodeName());
        try {
            ManagedNode node = new ManagedNode();
            node.setName(definition.getNodeName());
            node.setDir(nodeWorkingDir.getAbsolutePath());
            node.setDdx(new File(nodeWorkingDir, "deploy").getAbsolutePath());
            node.setLog(definition.getNodeName() + ".log");
            node.setJavaHome(((MNodeRuntimeContext)this.callable).container.getJavaHomePath());
            ManagementNode mfObject = new ManagementNode(((MNodeRuntimeContext)this.callable).getName());
            if (!nodeWorkingDir.exists()) {
                this.raiseSLMessage("\nCreating working directory '" + nodeWorkingDir.getAbsolutePath() + "'...\n", session);
                FileIOUtils.newFileDir(nodeWorkingDir.getAbsolutePath());
            } else {
                isNewNode = false;
                ManagementNodeFactory.checkObject(mfObject, node);
            }
            this.uploadFRM(nodeWorkingDir, (Definition)definition, session);
            this.checkContainer(nodeWorkingDir, definition.getNodeName(), session);
            this.raiseSLMessage("Adding deployment descriptor...\n", session);
            CreateManagedNodeOperation.generateDeploymentDescriptor(definition.getNodeName(), nodeWorkingDir.getAbsolutePath(), ((MNodeRuntimeContext)this.callable).getDdx(), ((MNodeRuntimeContext)this.callable).getXSerializer());
            File confFile = new File(nodeWorkingDir, definition.getNodeName() + ".conf");
            if (!confFile.exists()) {
                this.raiseSLMessage("Creating config file '" + confFile.getName() + "'...\n", session);
                confFile.createNewFile();
            }
            node.setJavaCfg(confFile.getName());
            this.raiseSLMessage("Copying ManagementNode object...\n", session);
            ManagementNodeFactory.copyObject(mfObject, node);
            this.raiseSLMessage("Setting acceptors...\n", session);
            CreateManagedNodeOperation.setAcceptors((MNodeRuntimeContext)this.callable, node, false);
            this.raiseSLMessage("Setting Directory Table...\n", session);
            CreateManagedNodeOperation.setDirectoryTable((MNodeRuntimeContext)this.callable, definition.getNodeName(), nodeWorkingDir.getAbsolutePath(), false);
            this.raiseSLMessage("Synchronizing timezone...\n", session);
            CreateManagedNodeOperation.setTimezone((MNodeRuntimeContext)this.callable, node);
            this.raiseSLMessage("Synchronizing global variables...\n", session);
            SyncManagedOperation.syncGlobalVariables((MNodeRuntimeContext)this.callable, node);
            this.raiseSLMessage("Adding managed node to table...\n\n", session);
            ((MNodeRuntimeContext)this.callable).container.getManagedNodes().appendNode(node);
            this.executeScripts(nodeWorkingDir, definition, session);
            DeployManagedNodeOperation.raiseDeploymentAdvisory((MNodeRuntimeContext)this.callable, DeploymentAdvisoryType.NODE_DEPLOYED, definition.getNodeName(), ((MNodeRuntimeContext)this.callable).getName());
            SLResponse sLResponse = new SLResponse();
            return sLResponse;
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            if (isNewNode) {
                FileIOUtils.deleteFileDir(nodeWorkingDir);
            }
            throw error;
        }
        finally {
            if (((Definition)definition).forMigrate) {
                FileIOUtils.deleteFile(definition.getFrmPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkContainer(File nodeWorkingDir, String nodeName, MFSession session) throws Exception {
        this.raiseSLMessage("Checking node type...\n", session);
        Utils.sleep(50L);
        try (BufferedReader reader = null;){
            try {
                reader = new BufferedReader(new FileReader(new File(nodeWorkingDir, ".tfcache/objects/sys/container/Container.xdo")));
            }
            catch (Exception ignored) {
                if (reader != null) {
                    reader.close();
                }
                return;
            }
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.contains("<activator") && !line.contains("Port")) continue;
                throw new Exception("Node '" + nodeName + "' is Management Node. It cannot be added as managed node.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFRM(File nodeWorkingDir, Definition definition, MFSession session) throws Exception {
        InputStream input = null;
        FrmFileReader frmFile = null;
        try {
            this.raiseSLMessage("\nUploading Resource Module...\n", session);
            Utils.sleep(50L);
            input = definition.forMigrate ? this.openFrmInputStream(session, definition, SLFileSessionContext.SERVER) : this.openFrmInputStream(session, definition);
            frmFile = new FrmFileReader(input);
            frmFile.extractTo(nodeWorkingDir, EXCLUDED_PATHS);
            frmFile.close();
            this.raiseSLMessage("Resource Module Uploaded.\n\n", session);
        }
        finally {
            if (frmFile != null) {
                frmFile.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScripts(File nodeWorkingDir, AbstractFrmNodeOperation.Definition definition, MFSession session) throws Exception {
        File tnodeScript;
        XSerializer serializer = ((MNodeRuntimeContext)this.callable).getXSerializer();
        File mnodeScript = new File(nodeWorkingDir, "mnode.slang");
        if (mnodeScript.exists()) {
            this.raiseSLMessage("Executing 'mnode.slang' script...\n", session);
            this.executeScript(mnodeScript, definition.getNodeName());
        }
        if ((tnodeScript = new File(nodeWorkingDir, "tnode.slang")).exists()) {
            this.raiseSLMessage("Executing 'tnode.slang' script...\n", session);
            try (SLSession mnodeSession = DeployManagedNodeOperation.getFabricConnection((MNodeRuntimeContext)this.callable).createSLSession();){
                File serviceManifest = new File(nodeWorkingDir, ".tfcache/objects/sys/service/" + ServiceManifest.class.getSimpleName() + ".xdo");
                if (serviceManifest.exists()) {
                    ServiceManifest manifest = (ServiceManifest)serializer.deserialize(FileIOUtils.getFileContent(serviceManifest));
                    boolean serviceManifestEnabled = manifest.isManifestUsed();
                    manifest.enableServiceManifest(false);
                    FileIOUtils.putFile(serviceManifest.getParent(), ServiceManifest.class.getSimpleName() + ".xdo", serializer.serialize(manifest).getBytes());
                    mnodeSession.slangRequest("start managed node " + definition.getNodeName(), 30000L);
                    this.executeScript(tnodeScript, definition.getNodeName());
                    mnodeSession.slangRequest("stop managed node " + definition.getNodeName(), 30000L);
                    manifest = (ServiceManifest)serializer.deserialize(FileIOUtils.getFileContent(serviceManifest));
                    manifest.enableServiceManifest(serviceManifestEnabled);
                    FileIOUtils.putFile(serviceManifest.getParent(), ServiceManifest.class.getSimpleName() + ".xdo", serializer.serialize(manifest).getBytes());
                } else {
                    mnodeSession.slangRequest("start managed node " + definition.getNodeName(), 30000L);
                    this.executeScript(tnodeScript, definition.getNodeName());
                    mnodeSession.slangRequest("stop managed node " + definition.getNodeName(), 30000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(File script, String nodeName) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(script));
        SLSession slSession = DeployManagedNodeOperation.getFabricConnection((MNodeRuntimeContext)this.callable).createSLSession(nodeName);
        try {
            String operation;
            while ((operation = reader.readLine()) != null) {
                slSession.slangRequest(operation, 0L);
            }
        }
        finally {
            slSession.close();
            reader.close();
            script.delete();
        }
    }

    private static FabricConnection getFabricConnection(MNodeRuntimeContext callable) {
        return callable.container.getFabricConnection();
    }

    static {
        EXCLUDED_PATHS.add(".tfcache/objects/sys/mf");
        EXCLUDED_PATHS.add(".tfcache/objects/sys/security");
    }

    public static class Definition
    extends AbstractFrmNodeOperation.Definition {
        private boolean forMigrate = false;

        Definition(String nodeName, String frmPath, boolean isAsync) {
            super(DeployManagedNodeOperation.NAME, nodeName, frmPath, isAsync);
        }

        Definition(String nodeName, String frmPath) {
            this(nodeName, frmPath, true);
            this.forMigrate = true;
        }
    }
}

