/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.omf.serializer.Serializer;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.StDeployGenerator;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.Container;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.discovery.DiscoveryModuleConfiguration;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptor;
import com.streamscape.sef.network.utils.NetworkUtils;
import com.streamscape.sef.utils.WrongParameterException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.AbstractAddSetNodeOperation;
import com.streamscape.tools.mnode.MNodeContainer;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.Utils;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class CreateManagedNodeOperation
extends AbstractAddSetNodeOperation {
    private static final String NAME = "create managed node";

    public CreateManagedNodeOperation() {
        super(NAME);
        this.syntax.setAction("CREATE MANAGED NODE");
        this.syntax.addActionParameter(new IdentifierParameter("NodeName"));
        CreateManagedNodeOperation.addCommonCreateAddSetModifiers(this.syntax, false);
        this.syntax.setDescription("Creates a new managed node with the specified name and adds it to the list managed nodes.\nAutomatically generates a deployment descriptor for the new node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n" + this.getCommonCreateAddSetModifiersDescription());
        this.syntax.setExamples("create managed node TestNode\ncreate managed node TestNode -java-home 'c:/java/jdk_1.6_30'\ncreate managed node TestNode -java-cfg 'D:/TMP/tnode.conf' -java-args '-Xmx1024m'\ncreate managed node TestNode autostart true position first\ncreate managed node TestNode -admin '9999'\ncreate managed node TestNode -admin '$hostname:9999'\ncreate managed node TestNode -admin '$hostname:(eth0):9999'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        AbstractAddSetNodeOperation.Definition definition = (AbstractAddSetNodeOperation.Definition)super.convertDslToSl(statement);
        definition.managedNode.setName(statement.getParameter("NodeName").getValue());
        definition.managedNode.setDir(new File("nodes" + File.separator + definition.managedNode.getName()).getAbsolutePath());
        definition.managedNode.setDdx(definition.managedNode.getDir() + File.separator + "deploy");
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        StringBuilder response = new StringBuilder();
        AbstractAddSetNodeOperation.Definition definition = (AbstractAddSetNodeOperation.Definition)statement;
        ManagedNode node = definition.managedNode;
        node.setDefaults();
        CreateManagedNodeOperation.checkParameters(node, response);
        if (node.getJavaHome() == null) {
            node.setJavaHome(((MNodeRuntimeContext)this.callable).container.getJavaHomePath());
        }
        this.checkPositionNodeName(definition);
        CreateManagedNodeOperation.checkError(!((MNodeRuntimeContext)this.callable).container.getManagedNodes().existsNode(node.getName()), "Node already exists.");
        Trace.logInfo(this, "Creating managed node '" + definition.managedNode.getName() + "'...");
        File workingDir = new File(node.getDir());
        if (!workingDir.exists()) {
            FileIOUtils.newFileDir(workingDir.getAbsolutePath());
        }
        if (node.getJavaCfg() != null) {
            CreateManagedNodeOperation.checkWarning("-JAVA-CFG", CreateManagedNodeOperation.getJavaCfgPath(node), false, response);
        }
        CreateManagedNodeOperation.generateDeploymentDescriptor(node.getName(), node.getDir(), ((MNodeRuntimeContext)this.callable).getDdx(), ((MNodeRuntimeContext)this.callable).getXSerializer());
        ArrayList<String> commandArgs = new ArrayList<String>();
        Utils.fillCommandArgs(node, ((MNodeRuntimeContext)this.callable).getSTRootDir(), "-init", commandArgs);
        Trace.logInfo(this, ((Object)commandArgs).toString());
        Utils.startProcessAndWaitForCompletion(commandArgs.toArray(new String[0]));
        CreateManagedNodeOperation.setAcceptors((MNodeRuntimeContext)this.callable, node, true);
        CreateManagedNodeOperation.setDirectoryTable((MNodeRuntimeContext)this.callable, node.getName(), node.getDir(), true);
        CreateManagedNodeOperation.setTimezone((MNodeRuntimeContext)this.callable, node);
        this.addNodeToContainer(definition);
        Trace.logInfo(this, "Managed node '" + definition.managedNode.getName() + "' created.");
        return new SLResponse(response.length() > 0 ? response.toString() : null);
    }

    private static void checkParameters(ManagedNode node, StringBuilder response) throws WrongParameterException {
        CreateManagedNodeOperation.checkWarning("-EXEC-DIR", node.getExecDir(), true, response);
        CreateManagedNodeOperation.checkWarning("-JAVA-HOME", node.getJavaHome(), true, response);
    }

    static void generateDeploymentDescriptor(String nodeName, String nodeWorkingDir, CtxDeploymentDescriptor mnodeDdx, XSerializer serializer) throws Exception {
        CtxDeploymentDescriptor ddx = new CtxDeploymentDescriptor();
        ddx.setContextName(nodeName);
        ddx.setContainerClass(Container.class.getName());
        ddx.setAuthenticationModule(mnodeDdx.getAuthenticationModule());
        ddx.setBatchSize(mnodeDdx.getBatchSize());
        ddx.setClusterEnabled(mnodeDdx.isClusterEnabled());
        ddx.setClusterName(mnodeDdx.getClusterName());
        ddx.setCoherenceAutoBind(mnodeDdx.isCoherenceAutoBind());
        ddx.setConnectionRetry(mnodeDdx.getConnectionRetry());
        ddx.setConnectionTimeout(mnodeDdx.getConnectionTimeout());
        ddx.setContextTimeout(mnodeDdx.getContextTimeout());
        ddx.setContextType(mnodeDdx.getContextType());
        ddx.setDiscoveryProtocol(mnodeDdx.getDiscoveryProtocol());
        ddx.setInitialContextFactory(mnodeDdx.getInitialContextFactory());
        ddx.setIOTimeout(mnodeDdx.getIOTimeout());
        ddx.setLicenseKey(mnodeDdx.getLicenseKey());
        ddx.setLicenseTs(mnodeDdx.getLicenseTs());
        ddx.setPresence(mnodeDdx.isPresence());
        ddx.setProviderArchive(mnodeDdx.getProviderArchive());
        ddx.setProviderURL(mnodeDdx.getProviderURL());
        ddx.setReferral(mnodeDdx.getReferral());
        ddx.setRuntimeCacheForceLock(mnodeDdx.isRuntimeCacheForceLock());
        ddx.setRuntimeContextAutoUnload(mnodeDdx.isRuntimeContextAutoUnload());
        ddx.setSecurityCredentials(mnodeDdx.getSecurityCredentials());
        ddx.setSecurityPrincipal(mnodeDdx.getSecurityPrincipal());
        ddx.setSTRoot(mnodeDdx.getSTRoot());
        File ddxDir = new File(nodeWorkingDir, "deploy");
        if (!ddxDir.exists()) {
            ddxDir.mkdirs();
        }
        File cdxFile = new File(ddxDir, "rtcontext.cdx");
        cdxFile.createNewFile();
        FileIOUtils.putFile(ddxDir.getAbsolutePath(), cdxFile.getName(), serializer.serialize(ddx).getBytes());
        StDeployGenerator.generate(ddxDir);
        cdxFile.delete();
    }

    static void setAcceptors(MNodeRuntimeContext callable, ManagedNode node, boolean updateGlv) throws Exception {
        String poolName = CreateManagedNodeOperation.getPoolName(callable, node.getName());
        CreateManagedNodeOperation.setAcceptor(callable, node, poolName, LinkProtocol.TLP);
        CreateManagedNodeOperation.setAcceptor(callable, node, poolName, LinkProtocol.HTTP);
        if (updateGlv) {
            CreateManagedNodeOperation.updateGlobalVariables(callable, node.getDir());
        }
    }

    static String getPoolName(MNodeRuntimeContext callable, String nodeName) throws Exception {
        String poolName = CreateManagedNodeOperation.getPoolName(nodeName);
        if (!callable.getGlobalVariableFactory().existsLiteralPool(poolName)) {
            callable.getGlobalVariableFactory().addLiteralPool(poolName);
        }
        return poolName;
    }

    static String getPoolName(String nodeName) {
        return nodeName.replace('.', '_');
    }

    private static void setAcceptor(MNodeRuntimeContext callable, ManagedNode node, String poolName, LinkProtocol protocol) throws Exception {
        callable.getGlobalVariableFactory().setVariable(poolName, String.valueOf((Object)protocol) + "_host", "localhost");
        callable.getGlobalVariableFactory().setVariable(poolName, String.valueOf((Object)protocol) + "_port", Integer.toString(CreateManagedNodeOperation.findAvailablePort(callable, node.getName(), protocol)));
        File acceptorFile = new File(node.getDir() + "/.tfcache/objects/sys/network/acceptors/" + String.valueOf((Object)protocol) + "/" + protocol.name() + "Acceptor.Default.xdo");
        Acceptor acceptor = (Acceptor)callable.getXSerializer().deserialize(FileIOUtils.getFileContent(acceptorFile));
        acceptor.setURL(CreateManagedNodeOperation.getUrl(protocol, poolName));
        FileIOUtils.putFile(acceptorFile.getParent(), acceptorFile.getName(), callable.getXSerializer().serialize(acceptor).getBytes());
    }

    private static int findAvailablePort(MNodeRuntimeContext callable, String nodeName, LinkProtocol protocol) throws FabricException {
        MNodeContainer container = callable.container;
        switch (protocol) {
            case TLP: {
                return CreateManagedNodeOperation.findPort(callable, nodeName, protocol, container.getMinTlpPortPositive(), container.getMaxTlpPortPositive());
            }
            case HTTP: {
                return CreateManagedNodeOperation.findPort(callable, nodeName, protocol, container.getMinHttpPortPositive(), container.getMaxHttpPortPositive());
            }
        }
        throw new FabricException("Invalid LinkProtocol!");
    }

    private static String getUrl(LinkProtocol protocol, String poolName) {
        return "$gvar:(" + poolName + "." + String.valueOf((Object)protocol) + "_host):$gvar:(" + poolName + "." + String.valueOf((Object)protocol) + "_port)";
    }

    private static int findPort(MNodeRuntimeContext callable, String nodeName, LinkProtocol protocol, int minPort, int maxPort) throws FabricException {
        int result;
        String managedNode = "managed node '" + nodeName + "'";
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (ManagedNode node : callable.getManagedNodes()) {
            FabricNodeReference reference = callable.getModerator().lookupFabricNode(node.getName());
            if (reference != null) {
                for (LinkAddress address : reference.getAcceptors()) {
                    if (address.getProtocol() != protocol) continue;
                    usedPorts.add(address.getAddress().getPort());
                }
                continue;
            }
            try {
                for (File file : FileIOUtils.directoryList(node.getDir() + "/.tfcache/objects/sys/network/acceptors/" + String.valueOf((Object)protocol) + "/", "*.xdo")) {
                    Acceptor acceptor = (Acceptor)callable.getXSerializer().deserialize(FileIOUtils.getFileContent(file));
                    String url = new MacroProcessor().process(acceptor.getURL());
                    int index = url.lastIndexOf(":");
                    if (index == -1) continue;
                    usedPorts.add(Integer.valueOf(url.substring(index + 1)));
                }
            }
            catch (Exception error) {
                Trace.logError(CreateManagedNodeOperation.class, "Obtaining " + protocol.name() + " acceptor for " + managedNode + " failed. Cause: " + error.getMessage());
            }
        }
        if (maxPort < minPort) {
            int tmp = maxPort;
            minPort = maxPort = minPort;
        }
        for (result = minPort; result <= maxPort && !CreateManagedNodeOperation.isPortAvailable(result, usedPorts); ++result) {
        }
        if (result > maxPort) {
            throw new FabricException("Assigning " + protocol.name() + " port for " + managedNode + " failed. Cause: All ports from range [" + minPort + "," + maxPort + "] are used.");
        }
        Trace.logInfo(CreateManagedNodeOperation.class, protocol.name() + " port " + result + " assigned for " + managedNode + ".");
        return result;
    }

    private static boolean isPortAvailable(int port, Set<Integer> usedPorts) {
        if (!usedPorts.contains(port)) {
            if (NetworkUtils.isPortAvailable(port)) {
                return true;
            }
            Trace.logInfo(CreateManagedNodeOperation.class, "Port '" + port + "' is used by another application.");
        }
        return false;
    }

    static void setDirectoryTable(MNodeRuntimeContext callable, String nodeName, String nodeWorkingDir, boolean updateGlv) throws Exception {
        TLPAcceptor acceptor = callable.getTLPAcceptorFactory().lookupAcceptor("Default");
        if (acceptor != null) {
            XSerializer serializer = callable.getXSerializer();
            callable.getDiscoveryModule().getDirectoryTable().addLink(nodeName, new DiscoveryLink(callable.getName(), CreateManagedNodeOperation.getURL(acceptor)));
            DiscoveryModuleConfiguration mnodeDiscovery = callable.getDiscoveryModuleFactory().getActiveModuleConfiguration();
            File discoveryFile = new File(nodeWorkingDir + "/.tfcache/objects/sys/discovery/DiscoveryModule.Default.xdo");
            DiscoveryModuleConfiguration discovery = CreateManagedNodeOperation.readDiscoveryModule(discoveryFile, serializer);
            CreateManagedNodeOperation.setFabricDirectory(callable, nodeName, nodeWorkingDir, discovery, CreateManagedNodeOperation.getFabricDirectory(mnodeDiscovery).toRealPath(new LinkOption[0]));
            if (updateGlv) {
                CreateManagedNodeOperation.updateGlobalVariables(callable, nodeWorkingDir);
            }
            discovery.setParameter("multicastEnabled", mnodeDiscovery.getParameter("multicastEnabled"));
            discovery.setParameter("multicastAddress", mnodeDiscovery.getParameter("multicastAddress"));
            discovery.setParameter("multicastWaitingTime", mnodeDiscovery.getParameter("multicastWaitingTime"));
            CreateManagedNodeOperation.writeDiscoveryModule(discovery, discoveryFile, serializer);
        }
    }

    private static String getURL(TLPAcceptor acceptor) {
        String url = acceptor.getURL();
        return url.contains("://") ? url : acceptor.getProtocol().getURLPrefix() + url;
    }

    private static void updateGlobalVariables(MNodeRuntimeContext callable, String nodeWorkingDir) throws Exception {
        File glvFile = new File(nodeWorkingDir + "/.tfcache/globals/GlobalVariables.xdo");
        FileIOUtils.putFile(glvFile.getParent(), glvFile.getName(), callable.getXSerializer().serialize(callable.getGlobalVariableFactory().getGlobalVariables()).getBytes());
    }

    static DiscoveryModuleConfiguration readDiscoveryModule(File file, Serializer serializer) throws Exception {
        return (DiscoveryModuleConfiguration)Utils.readObject(file.getAbsolutePath(), serializer);
    }

    static void writeDiscoveryModule(DiscoveryModuleConfiguration module, File file, Serializer serializer) throws Exception {
        Utils.writeObject(module, file.getAbsolutePath(), serializer);
    }

    static Path getFabricDirectory(DiscoveryModuleConfiguration discovery) throws Exception {
        String fabricDirectory = new MacroProcessor().process(discovery.getParameter("fabricDirectory"));
        return fabricDirectory != null ? Paths.get(fabricDirectory, new String[0]) : null;
    }

    static void setFabricDirectory(MNodeRuntimeContext callable, String nodeName, String nodeDir, DiscoveryModuleConfiguration discovery, Path path) throws Exception {
        String poolName = CreateManagedNodeOperation.getPoolName(callable, nodeName);
        callable.getGlobalVariableFactory().setVariable(CreateManagedNodeOperation.getPoolName(callable, nodeName), "fabricDirectory", path.isAbsolute() ? path.toString() : Paths.get(nodeDir, new String[0]).toRealPath(new LinkOption[0]).relativize(path).toString());
        discovery.setParameter("fabricDirectory", CreateManagedNodeOperation.getUrl(poolName));
    }

    private static String getUrl(String poolName) {
        return "$gvar:(" + poolName + ".fabricDirectory)";
    }

    static void setTimezone(MNodeRuntimeContext callable, ManagedNode node) throws Exception {
        File dsStoreFile = new File(node.getDir() + "/.tfcache/objects/sys/dataspace/DataspaceStore.xdo");
        if (!dsStoreFile.exists()) {
            Utils.writeObject(callable.getDataspaceStore(), dsStoreFile.getAbsolutePath(), callable.getXSerializer());
        } else {
            DataspaceStore dsStore = (DataspaceStore)Utils.readObject(dsStoreFile.getAbsolutePath(), callable.getXSerializer());
            dsStore.properties.setProperty("dtspace.timezone", callable.getNodeTimezone().getID());
            Utils.writeObject(dsStore, dsStoreFile.getAbsolutePath(), callable.getXSerializer());
        }
    }
}

