/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.mf.operation.frm.BackupNodeOperation;
import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.deploy.DeploymentAdvisoryType;
import com.streamscape.sef.dispatcher.AbstractBackupNodeOperation;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.slang.SLMessageListener;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.tools.mnode.BackupManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;

public class CheckoutManagedNodeOperation
extends AbstractBackupNodeOperation<MNodeRuntimeContext> {
    private static final String NAME = "checkout managed node";

    public CheckoutManagedNodeOperation() {
        super(NAME);
        this.syntax.addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.setDescription("Checks out the specified node into the Fabric Resource Module file.");
        this.syntax.setExamples("checkout managed node Node1 at 'C:/Streamscape/resources/Node.frm'\ncheckout managed node Node1 manifest TestManifest at 'C:/Streamscape/resources/Node.frm' no data");
        this.syntax.addTag(OperationTag.mnode);
        this.syntax.addCompletionCommand("list managed nodes");
    }

    boolean isOperationAllowed(ManagedNode node) {
        return (node.currentOperation == null || node.currentOperation == ManagedNode.Operation.NONE) && node.getCheckedOutBy() == null;
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((MNodeRuntimeContext)this.callable).getManagedNodes().stream().filter(node -> node != null && this.isOperationAllowed((ManagedNode)node)).map(ManagedNode::getName).collect(Collectors.toList()));
    }

    @Override
    protected SLResponse execute(AbstractFrmNodeOperation.Definition statement, MFSession session, long timeout) throws Exception {
        return CheckoutManagedNodeOperation.doInvoke(this, (MNodeRuntimeContext)this.callable, (Definition)statement, session, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SLResponse doInvoke(AbstractOperation operation, MNodeRuntimeContext callable, Definition definition, MFSession session, long timeout) throws Exception {
        ManagedNode node = callable.container.getManagedNodes().getNode(definition.getNodeName());
        if (node == null) {
            throw new FabricException("Node not found.");
        }
        if (node.currentOperation != null && node.currentOperation != ManagedNode.Operation.NONE) {
            throw new FabricException("Checkout is not possible while other operation is in progress.");
        }
        if (node.getCheckedOutBy() != null) {
            throw new FabricException("Node already checked out by '" + node.getCheckedOutBy() + "' user. It should be either checked in or reverted.");
        }
        SLResponse response = new SLResponse();
        File frmFile = new File(node.getDir() + "/tmp.frm");
        node.currentOperation = ManagedNode.Operation.CHECKOUT;
        try {
            FrmManifest manifest = CheckoutManagedNodeOperation.getManifest(callable, definition.getManifestName());
            SLResponse sLResponse = response = node.isRunning() ? CheckoutManagedNodeOperation.checkoutOnlineNode(callable, definition, session, timeout, node, manifest, frmFile) : CheckoutManagedNodeOperation.checkoutOfflineNode(callable, definition, session, node, manifest, frmFile);
            if (response.isOK()) {
                Utils.sleep(100L);
                CheckoutManagedNodeOperation.downloadFrm(session, frmFile, CheckoutManagedNodeOperation.createFrmPath(definition.getFrmPath()));
                node.setCheckedOutBy(session.getOwnerName());
                callable.container.getManagedNodes().save();
                CheckoutManagedNodeOperation.raiseDeploymentAdvisory(callable, DeploymentAdvisoryType.NODE_CHECKED_OUT, definition.getNodeName(), callable.getName());
            }
        }
        finally {
            frmFile.delete();
            node.currentOperation = ManagedNode.Operation.NONE;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SLResponse checkoutOnlineNode(MNodeRuntimeContext callable, Definition definition, MFSession session, long timeout, ManagedNode node, FrmManifest manifest, File frmFile) throws Exception {
        SLResponse response = new SLResponse();
        String tmpManifestName = "TempManifest_" + System.currentTimeMillis() + ".frmm";
        String tmpManifestPath = "resources/" + tmpManifestName;
        SLSession slSession = null;
        FileInputStream inputFileStream = null;
        RepositoryAccessor tnodeAccessor = null;
        try {
            BackupNodeOperation.Definition backupNodeDefinition = new BackupNodeOperation.Definition(definition);
            if (definition.getManifestName() != null) {
                tnodeAccessor = CheckoutManagedNodeOperation.getFabricConnection(callable).getRepositoryAccessor(definition.getNodeName());
                CheckoutManagedNodeOperation.uploadManifest(callable, tnodeAccessor, tmpManifestPath, manifest);
                backupNodeDefinition.setManifestName(tmpManifestName);
            }
            MessageListener listener = new MessageListener(session);
            slSession = CheckoutManagedNodeOperation.getFabricConnection(callable).createSLSession(definition.getNodeName());
            slSession.setSLMessageListener(listener);
            SLResponse backupNodeResponse = slSession.slangRequest(backupNodeDefinition, timeout);
            if (definition.isAsync() && backupNodeResponse instanceof PseudoSLResponse) {
                listener.doWait();
                if (listener.errorMessage != null) {
                    SLResponse sLResponse = listener.errorMessage.getText() != null ? new SLResponse(listener.errorMessage.getText(), false) : new SLResponse(listener.errorMessage.getException());
                    return sLResponse;
                }
            } else if (!backupNodeResponse.isOK()) {
                SLResponse sLResponse = backupNodeResponse;
                return sLResponse;
            }
        }
        finally {
            if (inputFileStream != null) {
                inputFileStream.close();
            }
            if (slSession != null) {
                slSession.close();
            }
            if (tnodeAccessor != null) {
                tnodeAccessor.deleteFile(tmpManifestPath);
            }
        }
        return response;
    }

    private static void uploadManifest(MNodeRuntimeContext callable, RepositoryAccessor accessor, String tmpManifestPath, FrmManifest manifest) throws Exception {
        if (!accessor.existsFile("resources")) {
            accessor.createDirectory("resources");
        }
        if (accessor.existsFile(tmpManifestPath)) {
            accessor.deleteFile(tmpManifestPath);
        }
        accessor.createFile(tmpManifestPath, callable.getXSerializer().serialize(manifest).getBytes(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SLResponse checkoutOfflineNode(MNodeRuntimeContext callable, Definition definition, MFSession session, ManagedNode node, FrmManifest manifest, File frmFile) throws Exception {
        if (node.isRunning()) {
            throw new FabricException("Running node can not be checked out.");
        }
        try (OutputStream output = null;){
            CheckoutManagedNodeOperation.sendSLMessage("\nGenerating Resource Module...\n", session);
            output = CheckoutManagedNodeOperation.openFrmOutputStream(frmFile);
            FrmFileWriter writer = new FrmFileWriter(frmFile.getAbsolutePath(), output);
            writer.setExcludeMNodeObject(false);
            writer.addFile("manifest.frmm", callable.getXSerializer().serialize(manifest).getBytes());
            writer.setWithoutData(definition.isWithoutData());
            writer.generate(new File(node.getDir()), new File(node.getDdx()), manifest, message -> CheckoutManagedNodeOperation.sendSLMessage(message, session));
            CheckoutManagedNodeOperation.addScripts(definition, session, writer);
            writer.close();
            CheckoutManagedNodeOperation.sendSLMessage("Resource Module generated.\n", session);
        }
        Utils.sleep(100L);
        return new SLResponse("Operation completed successfully.");
    }

    static FabricConnection getFabricConnection(MNodeRuntimeContext callable) {
        return callable.container.getFabricConnection();
    }

    @Override
    protected Definition createDefinition(DSLStatement statement, String frmPath, boolean isAsync, String manifestName, boolean withoutData, boolean withoutDefrag, String password) {
        return new Definition(statement.getParameter("NodeName").getValue(), frmPath, isAsync, manifestName, withoutData, withoutDefrag, password);
    }

    static class Definition
    extends AbstractBackupNodeOperation.Definition {
        Definition(String nodeName, String frmPath, boolean isAsync, String manifestName, boolean withoutData, boolean withoutDefrag, String password) {
            super(CheckoutManagedNodeOperation.NAME, nodeName, frmPath, isAsync, manifestName, withoutData, withoutDefrag, password);
        }

        Definition(BackupManagedNodeOperation.Definition other) {
            this(other.getNodeName(), other.getFrmPath(), other.isAsync(), other.getManifestName(), other.isWithoutData(), other.isWithoutDefrag(), other.getPassword());
            this.setMnodeScript(other.getMnodeScript());
            this.setTnodeScript(other.getTnodeScript());
        }
    }

    private static class MessageListener
    implements SLMessageListener {
        MFSession session;
        SLMessage errorMessage;
        volatile boolean isWaiting = true;

        MessageListener(MFSession session) {
            this.session = session;
        }

        @Override
        public void onMessage(SLMessage message) {
            try {
                if (message.getText() == null && message.isOK()) {
                    this.doNotify();
                } else if (message.isOK()) {
                    CheckoutManagedNodeOperation.sendSLMessage(message, this.session);
                } else {
                    this.errorMessage = message;
                }
            }
            catch (FabricException fabricException) {
                // empty catch block
            }
        }

        synchronized void doWait() throws Exception {
            while (this.isWaiting) {
                this.wait();
            }
        }

        synchronized void doNotify() {
            if (this.isWaiting) {
                this.isWaiting = false;
                this.notifyAll();
            }
        }
    }
}

