/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sef.FabricException;
import com.streamscape.sef.deploy.DeploymentAdvisoryType;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.tools.mnode.AbstractImportManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;

public class CheckinManagedNodeOperation
extends AbstractImportManagedNodeOperation {
    public static final String NAME = "checkin managed node";

    public CheckinManagedNodeOperation() {
        super(NAME);
        this.syntax.setDescription("Imports the content of specified Fabric Resource Module into the specified managed node.\nThis operation replaces existing files in the node directory with files taken from the FRM.\nThe original deployment descriptor is retained and not replaced by the one from FRM.\nThe node must be stopped and checked out.");
        this.syntax.setExamples("checkin managed node TestNode1 from 'C:/Streamscape/resources/Node.frm'");
    }

    @Override
    protected boolean isOperationAllowed(ManagedNode node) {
        return super.isOperationAllowed(node) && node.getCheckedOutBy() != null;
    }

    @Override
    protected void doCheckBeforeExecute(ManagedNode node, MFSession session) throws Exception {
        if (node.getCheckedOutBy() == null) {
            throw new FabricException("Node is not checked out. Use 'import managed node' instead.");
        }
        if (!node.getCheckedOutBy().equals(session.getOwnerName())) {
            throw new FabricException("Node can be checked in only by the user who checked it out.");
        }
    }

    @Override
    protected void doCompleteExecution(AbstractFrmNodeOperation.Definition definition, ManagedNode node) throws Exception {
        node.setCheckedOutBy(null);
        ((MNodeRuntimeContext)this.callable).container.getManagedNodes().save();
        CheckinManagedNodeOperation.raiseDeploymentAdvisory((MNodeRuntimeContext)this.callable, DeploymentAdvisoryType.NODE_CHECKED_IN, definition.getNodeName(), ((MNodeRuntimeContext)this.callable).getName());
    }
}

