/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.dispatcher.AbstractBackupNodeOperation;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.CheckoutManagedNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.RevertManagedNodeOperation;
import java.util.List;

public class BackupManagedNodeOperation
extends AbstractBackupNodeOperation<MNodeRuntimeContext> {
    private static final String NAME = "backup managed node";

    public BackupManagedNodeOperation() {
        super(NAME);
        this.syntax.addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.setDescription("Backs up the specified node into the Fabric Resource Module file.\nThis operation is equivalent to sequential call of 'checkout managed node' and 'revert managed node'.");
        this.syntax.setExamples("backup managed node Node1 at 'C:/Streamscape/resources/Node.frm'\nbackup managed node Node1 manifest TestManifest at 'C:/Streamscape/resources/Node.frm' no data");
        this.syntax.addTag(OperationTag.mnode);
        this.syntax.addCompletionCommand("list managed nodes");
    }

    boolean isOperationAllowed(ManagedNode node) {
        return (node.currentOperation == null || node.currentOperation == ManagedNode.Operation.NONE) && node.getCheckedOutBy() == null;
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
            if (node == null || !this.isOperationAllowed(node)) continue;
            completions.add(node.getName());
        }
    }

    @Override
    protected SLResponse execute(AbstractFrmNodeOperation.Definition statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        CheckoutManagedNodeOperation.doInvoke(this, (MNodeRuntimeContext)this.callable, new CheckoutManagedNodeOperation.Definition(definition), session, timeout);
        RevertManagedNodeOperation.doInvoke((MNodeRuntimeContext)this.callable, new RevertManagedNodeOperation.Definition(definition), session);
        return new SLResponse("Operation completed successfully.");
    }

    @Override
    protected Definition createDefinition(DSLStatement statement, String frmPath, boolean isAsync, String manifestName, boolean withoutData, boolean withoutDefrag, String password) {
        return new Definition(statement.getParameter("NodeName").getValue(), frmPath, isAsync, manifestName, withoutData, withoutDefrag, password);
    }

    static class Definition
    extends AbstractBackupNodeOperation.Definition {
        Definition(String nodeName, String frmPath, boolean isAsync, String manifestName, boolean withoutData, boolean withoutDefrag, String password) {
            super(BackupManagedNodeOperation.NAME, nodeName, frmPath, isAsync, manifestName, withoutData, withoutDefrag, password);
        }
    }
}

