/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.utils.WrongParameterException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.mnode.AbstractAddSetNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AlterManagedNodeOperation
extends AbstractAddSetNodeOperation {
    private static final String NAME = "alter managed node";

    public AlterManagedNodeOperation() {
        super(NAME);
        this.syntax.setAction("ALTER MANAGED NODE").addActionParameter(new IdentifierParameter("NodeName"));
        AlterManagedNodeOperation.addDirDdxModifiers(this.syntax, false);
        AlterManagedNodeOperation.addCommonCreateAddSetModifiers(this.syntax, true);
        this.syntax.setDescription("Sets the parameters of the specified managed node.");
        this.syntax.setSyntaxDescription("The following parameters are supported:\n\n" + AlterManagedNodeOperation.getDirDdxModifiersDescription() + this.getCommonCreateAddSetModifiersDescription());
        this.syntax.setExamples("alter managed node Node1 -dir 'D:/TMP/Node1' -ddx 'D:/TMP/Node1' -java-args '-Xmx1024m' -log 'D:/TMP/tnode.log'\nalter managed node Node1 -java-cfg 'D:/TMP/tnode.conf' -java-args '-Xmx512m -Xmx1024m' -log-broadcast\nalter managed node Node1 -dir 'D:/TMP/Node1' -log 'D:/TMP/tnode.log' -debug\nalter managed node Node1 autostart true position first\nalter managed node Node1 -admin '9999'\nalter managed node Node1 -admin '$hostname:9999'\nalter managed node Node1 -admin '$hostname:(eth0):9999'\nalter managed node Node1 -admin ''");
        this.syntax.addCompletionCommand("list managed nodes");
    }

    @Override
    protected String getAdminDescription() {
        return super.getAdminDescription() + "                    If an empty URL is specified, the administrative acceptor will not be enabled.\n";
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (ManagedNode node : ((MNodeRuntimeContext)this.callable).getManagedNodes()) {
            if (node == null) continue;
            completions.add(node.getName());
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.listModifiers().size() == 1) {
            throw new ParsingException("Parameters are not specified.");
        }
        AbstractAddSetNodeOperation.Definition definition = (AbstractAddSetNodeOperation.Definition)super.convertDslToSl(statement);
        definition.managedNode.setName(statement.getParameter("NodeName").getValue());
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractAddSetNodeOperation.Definition definition = (AbstractAddSetNodeOperation.Definition)statement;
        ManagedNode existingNode = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.managedNode.getName());
        if (existingNode == null) {
            return new SLResponse("Node not found.", false);
        }
        if (existingNode.isRunning()) {
            return new SLResponse("Node is running.", false);
        }
        StringBuilder response = new StringBuilder();
        AlterManagedNodeOperation.checkParameters(existingNode, definition.managedNode, response);
        this.checkPositionNodeName(definition);
        if (definition.managedNode.getDir() != null) {
            existingNode.setDir(definition.managedNode.getDir());
        }
        if (definition.managedNode.getDdx() != null) {
            existingNode.setDdx(definition.managedNode.getDdx());
        }
        if (definition.managedNode.getExecDir() != null) {
            existingNode.setExecDir(definition.managedNode.getExecDir());
        }
        if (definition.managedNode.getJavaArgs() != null) {
            existingNode.setJavaArgs(definition.managedNode.getJavaArgs());
        }
        if (definition.managedNode.getJavaCfg() != null) {
            existingNode.setJavaCfg(definition.managedNode.getJavaCfg());
        }
        if (definition.managedNode.getJavaHome() != null) {
            existingNode.setJavaHome(definition.managedNode.getJavaHome());
        }
        if (definition.managedNode.getLog() != null) {
            existingNode.setLog(definition.managedNode.getLog());
        }
        if (definition.managedNode.isLogBroadcast() != null) {
            existingNode.setLogBroadcast(definition.managedNode.isLogBroadcast());
        }
        if (definition.managedNode.isDebug() != null) {
            existingNode.setDebug(definition.managedNode.isDebug());
        }
        if (definition.managedNode.getAdmin() != null) {
            existingNode.setAdmin(definition.managedNode.getAdmin().isEmpty() ? null : definition.managedNode.getAdmin());
        }
        if (definition.managedNode.isAutoStart() != null) {
            existingNode.setAutoStart(definition.managedNode.isAutoStart());
        }
        if (definition.managedNode.getDelayBeforeStart() != null) {
            existingNode.setDelayBeforeStart(definition.managedNode.getDelayBeforeStart());
        }
        if (definition.managedNode.getStartTimeout() != null) {
            existingNode.setStartTimeout(definition.managedNode.getStartTimeout());
        }
        if (definition.position == AbstractAddSetNodeOperation.Definition.Position.BEFORE) {
            if (definition.positionNodeName != null) {
                ((MNodeRuntimeContext)this.callable).container.getManagedNodes().moveNodeBefore(definition.managedNode.getName(), definition.positionNodeName);
            } else {
                ((MNodeRuntimeContext)this.callable).container.getManagedNodes().moveNode(definition.managedNode.getName(), 0);
            }
        } else if (definition.position == AbstractAddSetNodeOperation.Definition.Position.AFTER) {
            if (definition.positionNodeName != null) {
                ((MNodeRuntimeContext)this.callable).container.getManagedNodes().moveNodeAfter(definition.managedNode.getName(), definition.positionNodeName);
            } else {
                ((MNodeRuntimeContext)this.callable).container.getManagedNodes().moveNodeToEnd(definition.managedNode.getName());
            }
        } else {
            ((MNodeRuntimeContext)this.callable).container.getManagedNodes().updateNode(existingNode);
        }
        return new SLResponse();
    }

    private static void checkParameters(ManagedNode existingNode, ManagedNode checkedNode, StringBuilder response) throws WrongParameterException {
        AlterManagedNodeOperation.checkError("-DIR", checkedNode.getDir(), true);
        AlterManagedNodeOperation.checkError("-EXEC-DIR", checkedNode.getExecDir(), true);
        AlterManagedNodeOperation.checkError("-JAVA-HOME", checkedNode.getJavaHome(), true);
        if (checkedNode.getJavaCfg() != null) {
            AlterManagedNodeOperation.checkError("-JAVA-CFG", AlterManagedNodeOperation.getJavaCfgPath(checkedNode.getJavaCfg(), existingNode), false);
        }
        AlterManagedNodeOperation.checkDdx(checkedNode);
        AlterManagedNodeOperation.checkLog(checkedNode, response);
    }

    private static void checkLog(ManagedNode node, StringBuilder response) {
        try {
            if (node.getLog() == null) {
                return;
            }
            boolean exists = new File(node.getLog()).exists();
            ContainerLogger.checkLogger(node.getLog());
            if (!exists) {
                new File(node.getLog()).delete();
            }
        }
        catch (IOException exception) {
            Trace.logException(AlterManagedNodeOperation.class, exception, true);
            AlterManagedNodeOperation.printWarning("-LOG", node.getLog(), "file '" + node.getLog() + "' cannot be written.", response);
        }
    }

    private static void checkDdx(ManagedNode node) throws WrongParameterException {
        if (node.getDdx() != null) {
            CtxDeploymentDescriptor descriptor;
            AlterManagedNodeOperation.checkError("-DDX", AlterManagedNodeOperation.getAbsoluteDdx(node), true);
            String descriptorFilename = AlterManagedNodeOperation.getAbsoluteDdx(node) + "/stdeploy.jar";
            try {
                descriptor = DeployUtils.getDeploymentDescriptor(descriptorFilename, XSerializerFactory.getInstance().getDefaultSerializer());
            }
            catch (Exception exception) {
                Trace.logException(AlterManagedNodeOperation.class, exception, true);
                throw new WrongParameterException("-DDX", "obtaining of Deployment Descriptor from file '" + descriptorFilename + "' failed.", exception);
            }
            AlterManagedNodeOperation.checkError(!StringUtils.isEmpty(descriptor.getContextName()), "-DDX", "Node name not specified in Deployment Descriptor.");
            AlterManagedNodeOperation.checkError(node.getName().equals(descriptor.getContextName()), "-DDX", "Node name in Deployment Descriptor does not match with name of the managed node.");
        }
    }
}

