/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.utils.WrongParameterException;
import com.streamscape.slex.MFSession;
import com.streamscape.tools.mnode.AbstractAddSetNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import java.io.File;
import java.io.IOException;

public class AddManagedNodeOperation
extends AbstractAddSetNodeOperation {
    private static final String NAME = "add managed node";

    public AddManagedNodeOperation() {
        super(NAME);
        this.syntax.setAction("ADD MANAGED NODE");
        AddManagedNodeOperation.addDirDdxModifiers(this.syntax, true);
        AddManagedNodeOperation.addCommonCreateAddSetModifiers(this.syntax, false);
        this.syntax.setDescription("Adds a new node to the list of managed nodes.");
        this.syntax.setSyntaxDescription("Mandatory parameters:\n\n" + AddManagedNodeOperation.getDirDdxModifiersDescription() + "\nOptional parameters:\n\n" + this.getCommonCreateAddSetModifiersDescription());
        this.syntax.setExamples("add managed node -dir 'D:/TMP/Node1' -ddx 'D:/TMP/Node1' -java-args '-Xmx512m -Xmx1024m' -debug true\nadd managed node -dir 'D:/TMP/Node1' -ddx 'D:/TMP/Node1' -java-cfg 'D:/TMP/tnode.conf' -java-args '-Xmx1024m'\nadd managed node -dir 'D:/TMP/Node1' -ddx 'D:/TMP/Node1' -log 'D:/TMP/tnode.log' -log-broadcast true\nadd managed node -dir 'D:/TMP/Node1' -ddx 'D:/TMP/Node1' autostart true position first\nadd managed node -dir 'D:/TMP/Node1' -ddx 'D:/TMP/Node1' -admin '9999'\nadd managed node -dir 'D:/TMP/Node1' -ddx 'D:/TMP/Node1' -admin '$hostname:9999'\nadd managed node -dir 'D:/TMP/Node1' -ddx 'D:/TMP/Node1' -admin '$hostname:(eth0):9999'");
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        StringBuilder response = new StringBuilder();
        AbstractAddSetNodeOperation.Definition definition = (AbstractAddSetNodeOperation.Definition)statement;
        ManagedNode node = definition.managedNode;
        AddManagedNodeOperation.checkDdx(node, (MNodeRuntimeContext)this.callable);
        node.setDefaults();
        AddManagedNodeOperation.checkParameters(node, response, (MNodeRuntimeContext)this.callable);
        this.checkPositionNodeName(definition);
        ManagedNode existingNode = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(node.getName());
        AddManagedNodeOperation.checkError(existingNode == null, "Node already exists.");
        this.addNodeToContainer(definition);
        return new SLResponse(response.length() > 0 ? response.toString() : null);
    }

    private static void checkParameters(ManagedNode node, StringBuilder response, MNodeRuntimeContext callable) throws WrongParameterException {
        AddManagedNodeOperation.checkError("-DIR", node.getDir(), true);
        AddManagedNodeOperation.checkWarning("-EXEC-DIR", node.getExecDir(), true, response);
        AddManagedNodeOperation.checkWarning("-JAVA-HOME", node.getJavaHome(), true, response);
        if (node.getJavaCfg() != null) {
            AddManagedNodeOperation.checkWarning("-JAVA-CFG", AddManagedNodeOperation.getJavaCfgPath(node), false, response);
        }
        AddManagedNodeOperation.checkLog(node, response);
    }

    private static void checkLog(ManagedNode node, StringBuilder response) {
        try {
            boolean exists = new File(node.getLog()).exists();
            ContainerLogger.checkLogger(node.getLog());
            if (!exists) {
                new File(node.getLog()).delete();
            }
        }
        catch (IOException exception) {
            Trace.logException(AddManagedNodeOperation.class, exception, true);
            AddManagedNodeOperation.printWarning("-LOG", node.getLog(), "file '" + node.getLog() + "' cannot be written.", response);
        }
    }

    static void checkDdx(ManagedNode node, MNodeRuntimeContext callable) throws WrongParameterException {
        if (node.getDdx() == null) {
            String ddx = node.getDir() + "/deploy";
            if (!new File(ddx).isDirectory()) {
                ddx = callable.getSTRootDir() + "/deploy";
            }
            try {
                node.setDdx(new File(ddx).getCanonicalPath());
            }
            catch (IOException exception) {
                Trace.logException(AddManagedNodeOperation.class, exception, true);
                throw new WrongParameterException("-DDX", "directory '" + ddx + "' does not exist.");
            }
        }
        AddManagedNodeOperation.checkError("-DDX", AddManagedNodeOperation.getAbsoluteDdx(node), true);
        String descriptorFilename = AddManagedNodeOperation.getAbsoluteDdx(node) + "/stdeploy.jar";
        try {
            CtxDeploymentDescriptor descriptor = DeployUtils.getDeploymentDescriptor(descriptorFilename, XSerializerFactory.getInstance().getDefaultSerializer());
            node.setName(descriptor.getContextName());
        }
        catch (Exception exception) {
            Trace.logException(AddManagedNodeOperation.class, exception, true);
            throw new WrongParameterException("-DDX", "obtaining of Deployment Descriptor from file '" + descriptorFilename + "' failed.", exception);
        }
        AddManagedNodeOperation.checkError(node.getName() != null && node.getName().length() != 0, "-DDX", "Node name not specified in Deployment Descriptor.");
    }
}

