/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractAccessorProxy;
import com.streamscape.sef.dispatcher.AbstractActivatorConnection;
import com.streamscape.sef.dispatcher.SLFileMessageRaiserRemote;
import com.streamscape.sef.dispatcher.SLWrapper;
import com.streamscape.sef.exchange.FabricCluster;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.DefaultConnectionStateHandler;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.GetTransferBufferSizeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import com.streamscape.slex.SemanticLexiconProcessor;
import com.streamscape.slex.SetSessionContextOperation;
import com.streamscape.slex.SetTransferBufferSizeOperation;
import com.streamscape.slex.ShowSessionContextOperation;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.tools.mnode.MNodeContainer;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import com.streamscape.tools.mnode.activator.ActivatorNetworkConnection;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ActivatorConnection
extends AbstractActivatorConnection
implements SLCallable {
    private String url;
    private transient MNodeContainer container;
    private transient Map<Integer, MNodeRequestHandler> requestHandlers;
    private transient ActivatorNetworkConnection.ConnectionFactory connectionFactory;
    private transient ActivatorNetworkConnection connection;
    private transient ConnectionMonitor connectionMonitor;
    private transient SessionDSLProvider dslProvider;
    private transient Map<String, SLFileMessageRaiserRemote> fileRaisers;

    ActivatorConnection() {
        this("tlp://localhost:6666");
    }

    ActivatorConnection(String url) {
        this.url = url;
    }

    String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    void init(MNodeContainer container) throws FabricException {
        this.container = container;
        this.initRequestHandlers();
        this.connectionFactory = new ActivatorNetworkConnection.ConnectionFactory(new ConnectionStateHandlerImpl(), ThreadPoolType.DYNAMIC, 10);
        this.connectionMonitor = new ConnectionMonitor();
        this.dslProvider = new SessionDSLProvider(this);
        this.fileRaisers = new HashMap<String, SLFileMessageRaiserRemote>();
    }

    void destroy() {
        if (this.connection != null) {
            this.connection.close(true);
            this.connection = null;
        }
    }

    void start() {
        this.connectionMonitor.doExecute();
        this.connectionMonitor.start();
    }

    public void stop() {
        this.connectionMonitor.stop();
    }

    void closeConnection() {
        if (this.connection != null) {
            this.connection.close(true);
            this.connection = null;
        }
    }

    public boolean isReady() {
        return this.connection != null && this.connection.isOpened();
    }

    Object invokeRequest(byte type) throws Exception {
        return this.connection.invokeRequest(type);
    }

    Object invokeRequest(byte type, Object data) throws Exception {
        return this.connection.invokeRequest(type, data);
    }

    Object invokeRequest(byte type, Object data, long timeout) throws Exception {
        return this.connection.invokeRequest(type, data, timeout);
    }

    byte[] invokeRoutedRequest(byte[] data, long timeout) throws Exception {
        return this.connection.invokeRoutedRequest(this.convertType(data), timeout);
    }

    private byte[] convertType(byte[] data) {
        byte type = data[0];
        if (type == 10) {
            data[0] = 8;
        }
        return data;
    }

    void sendMessage(Object message) throws Exception {
        this.connection.sendMessage(message);
    }

    void sendMessage(long sessionId, Object message) throws Exception {
        this.connection.sendMessage(sessionId, message);
    }

    private void openFileRaiser(ActivatorMFSession session) throws FabricException {
        SLFileMessageRaiserRemote raiser = new SLFileMessageRaiserRemote(session.getComponentName(), session.getSLSessionName(), null);
        try {
            raiser.open();
        }
        catch (IOException exception) {
            if (exception.getCause() != null) {
                throw new FabricException(exception.getMessage(), exception.getCause());
            }
            throw new FabricException(exception.getMessage());
        }
        this.fileRaisers.put(session.getSLSessionName(), raiser);
    }

    private void closeFileRaiser(ActivatorMFSession session) {
        SLFileMessageRaiserRemote raiser;
        if (session != null && (raiser = this.fileRaisers.remove(session.getSLSessionName())) != null) {
            raiser.close();
        }
    }

    private Object raiseFileMessage(Object data, long timeout) throws FabricException {
        SLFileMessage fileMessage = (SLFileMessage)((OpaqueDatagram)data).getData();
        try {
            SLFileMessageRaiserRemote raiser = this.fileRaisers.get(fileMessage.getSLSessionName());
            if (raiser != null) {
                return raiser.raise(fileMessage, timeout);
            }
        }
        catch (IOException exception) {
            return exception instanceof FileNotFoundException ? exception : new FabricException("Raising File Message request failed.", exception);
        }
        return new FabricException("SLFileMessage raiser not found for '" + fileMessage.getSLSessionName() + "' session.");
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return session instanceof ActivatorMFSession;
    }

    private Object onMnodeRequest(int requestId, Object data) throws FabricException {
        MNodeRequestHandler handler = this.requestHandlers.get(requestId);
        if (handler == null) {
            throw new FabricException("Unknown internal request [" + requestId + "] received.");
        }
        return handler.onRequest(data);
    }

    private void initRequestHandlers() {
        this.requestHandlers = new ConcurrentHashMap<Integer, MNodeRequestHandler>();
        this.requestHandlers.put(1, new GetNodeLogsRequestHandler());
        this.requestHandlers.put(2, new UploadImageRequestHandler());
        this.requestHandlers.put(3, new GetStartTnodesTimeoutRequestHandler());
        this.requestHandlers.put(4, new StartTnodesRequestHandler());
        this.requestHandlers.put(5, new StopTnodesRequestHandler());
        this.requestHandlers.put(6, new JoinSysplexRequestHandler());
        this.requestHandlers.put(7, new GetTnodeNamesRequestHandler());
        this.requestHandlers.put(8, new CheckTnodesRequestHandler());
        this.requestHandlers.put(9, new StopMnodesRequestHandler());
        this.requestHandlers.put(10, new ListNodesRequestHandler());
        this.requestHandlers.put(11, new GetMnodeNamesRequestHandler());
        this.requestHandlers.put(12, new CreateClusterRequestHandler());
        this.requestHandlers.put(13, new DropClusterRequestHandler());
        this.requestHandlers.put(14, new RestartTnodesRequestHandler());
    }

    private class ConnectionStateHandlerImpl
    extends DefaultConnectionStateHandler {
        private ConnectionStateHandlerImpl() {
        }

        @Override
        public void onOpen(Connection connection, boolean isOutgoing) throws FabricException {
            Trace.logInfo(this, "Connection to Activator opened.");
            connection.setPacketHandler(new PacketHandlerImpl(connection));
        }

        @Override
        public void onClose(Connection connection, boolean isNormal) {
            ActivatorConnection.this.connection = null;
            Trace.logInfo(this, "Connection to Activator closed.");
        }
    }

    private class ConnectionMonitor
    extends MonitorWorker {
        private long errorTime;

        ConnectionMonitor() throws FabricException {
            super("FSYS:MNode:Activator.ConnectionMonitor", "Monitors a connection to Activator.", 5000L);
            this.errorTime = -1L;
        }

        @Override
        protected void doExecute() {
            block12: {
                if (ActivatorConnection.this.connection == null) {
                    try {
                        ActivatorConnection.this.connection = ActivatorConnection.this.connectionFactory.createConnection(new LinkAddress(ActivatorConnection.this.url), 10L);
                        this.errorTime = -1L;
                    }
                    catch (Throwable exception) {
                        if (this.errorTime == -1L) {
                            this.errorTime = System.currentTimeMillis();
                        } else if (System.currentTimeMillis() - this.errorTime >= 60000L) {
                            Trace.logException(Activator.class, exception, false);
                            Trace.logError(Activator.class, "Connecting to Activator failed.");
                            this.errorTime = -1L;
                        }
                        return;
                    }
                }
                if (!ActivatorConnection.this.connection.isOpened()) {
                    try {
                        ActivatorConnection.this.connection.open(true);
                    }
                    catch (Throwable exception) {
                        Trace.logException(Activator.class, exception, true);
                        Trace.logError(Activator.class, "Opening connection to Activator failed.");
                        ActivatorConnection.this.connection = null;
                    }
                    try {
                        if (ActivatorConnection.this.connection != null) {
                            ActivatorConnection.this.connection.connect((byte)1, null, null, ActivatorConnection.this.container.getUserName(), ActivatorConnection.this.container.getPassword(), ActivatorConnection.this.container.getProcessID(), false);
                        }
                    }
                    catch (Throwable exception) {
                        Trace.logException(Activator.class, exception, true);
                        Trace.logError(Activator.class, "Establishing session with Activator failed.");
                        if (ActivatorConnection.this.connection == null) break block12;
                        ActivatorConnection.this.connection.close(true);
                        ActivatorConnection.this.connection = null;
                    }
                }
            }
        }
    }

    class SessionDSLProvider
    extends AbstractDSLProvider<ActivatorConnection> {
        SessionDSLProvider(ActivatorConnection this$0) {
            super("ActivatorConnection.SessionDSLProvider", this$0, SuggestionGroup.SESSION_OPERATIONS);
            this.registerOperation(new SetTransferBufferSizeOperation());
            this.registerOperation(new GetTransferBufferSizeOperation());
            this.registerOperation(new SetSessionContextOperation());
            this.registerOperation(new ShowSessionContextOperation());
            this.activate(this$0);
        }
    }

    private static interface MNodeRequestHandler<TData> {
        public Object onRequest(TData var1) throws FabricException;
    }

    private class GetNodeLogsRequestHandler
    implements MNodeRequestHandler<Void> {
        private GetNodeLogsRequestHandler() {
        }

        @Override
        public Object onRequest(Void data) throws FabricException {
            return ActivatorConnection.this.container.getNodeLogs();
        }
    }

    private class UploadImageRequestHandler
    implements MNodeRequestHandler<Activator.UploadImageCommandData> {
        private UploadImageRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.UploadImageCommandData data) throws FabricException {
            return ActivatorConnection.this.container.uploadImage(data.session, data.images, data.withWait);
        }
    }

    private class GetStartTnodesTimeoutRequestHandler
    implements MNodeRequestHandler<Activator.NodesCommandData> {
        private GetStartTnodesTimeoutRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.NodesCommandData data) throws FabricException {
            return ActivatorConnection.this.container.getStartTnodesTimeout(data.session, data.atDomain, data.nodeTimeout);
        }
    }

    private class StartTnodesRequestHandler
    implements MNodeRequestHandler<Activator.NodesCommandData> {
        private StartTnodesRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.NodesCommandData data) throws FabricException {
            return ActivatorConnection.this.container.startTnodes(data.session, data.atDomain, data.nodeTimeout);
        }
    }

    private class StopTnodesRequestHandler
    implements MNodeRequestHandler<Activator.NodesCommandData> {
        private StopTnodesRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.NodesCommandData data) throws FabricException {
            return ActivatorConnection.this.container.stopTnodes(data.session, data.atDomain, data.nodeTimeout, false);
        }
    }

    private class JoinSysplexRequestHandler
    implements MNodeRequestHandler<ActivatorMFSession> {
        private JoinSysplexRequestHandler() {
        }

        @Override
        public Object onRequest(ActivatorMFSession session) throws FabricException {
            ActivatorConnection.this.container.joinSysplex(session);
            return null;
        }
    }

    private class GetTnodeNamesRequestHandler
    implements MNodeRequestHandler<Void> {
        private GetTnodeNamesRequestHandler() {
        }

        @Override
        public Object onRequest(Void data) throws FabricException {
            return ActivatorConnection.this.container.getTnodeNames();
        }
    }

    private class CheckTnodesRequestHandler
    implements MNodeRequestHandler<Activator.CommandData> {
        private CheckTnodesRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.CommandData data) throws FabricException {
            return ActivatorConnection.this.container.checkTnodes(data.nodeName, (ActivatorMFSession)data.mfSession);
        }
    }

    private class StopMnodesRequestHandler
    implements MNodeRequestHandler<Activator.NodesCommandData> {
        private StopMnodesRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.NodesCommandData data) throws FabricException {
            return ActivatorConnection.this.container.stopMnodes(data.session, data.nodeTimeout);
        }
    }

    private class ListNodesRequestHandler
    implements MNodeRequestHandler<ActivatorMFSession> {
        private ListNodesRequestHandler() {
        }

        @Override
        public Object onRequest(ActivatorMFSession session) throws FabricException {
            return ActivatorConnection.this.container.listNodes(session);
        }
    }

    private class GetMnodeNamesRequestHandler
    implements MNodeRequestHandler<Void> {
        private GetMnodeNamesRequestHandler() {
        }

        @Override
        public Object onRequest(Void data) throws FabricException {
            return ActivatorConnection.this.container.getMnodeNames();
        }
    }

    private class CreateClusterRequestHandler
    implements MNodeRequestHandler<Activator.CommandData> {
        private CreateClusterRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.CommandData data) throws FabricException {
            ActivatorConnection.this.container.createCluster((ActivatorMFSession)data.mfSession, (FabricCluster)data.data);
            return null;
        }
    }

    private class DropClusterRequestHandler
    implements MNodeRequestHandler<Activator.CommandData> {
        private DropClusterRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.CommandData data) throws FabricException {
            ActivatorConnection.this.container.dropCluster((ActivatorMFSession)data.mfSession);
            return null;
        }
    }

    private class RestartTnodesRequestHandler
    implements MNodeRequestHandler<Activator.NodesCommandData> {
        private RestartTnodesRequestHandler() {
        }

        @Override
        public Object onRequest(Activator.NodesCommandData data) throws FabricException {
            return ActivatorConnection.this.container.stopTnodes(data.session, data.atDomain, data.nodeTimeout, true);
        }
    }

    class AccessorProxyImpl
    extends AbstractAccessorProxy {
        private ActivatorMFSession mfSession;

        AccessorProxyImpl(String sessionName, String componentName, ComponentOwner owner, boolean isRouted, String slSessionName, SLSessionData data) {
            super((SemanticLexiconProcessor)null);
            this.mfSession = new ActivatorMFSession(sessionName, componentName, owner, isRouted, slSessionName, data, MNodeContainer.getContext().getName() + "[Activator]", ActivatorMFSession.isFromSlangTool(componentName));
        }

        @Override
        protected void logError(Throwable exception) {
        }

        @Override
        protected MFSession getMFSession() {
            return this.mfSession;
        }

        @Override
        protected void setAccessorSession(AccessorSessionReference accessorSession) {
            super.setAccessorSession(accessorSession);
        }

        @Override
        public void close() {
            ActivatorConnection.this.closeFileRaiser(this.mfSession);
        }

        @Override
        public ImmutableEventDatagram onRequest(ImmutableEventDatagram request) throws FabricRequestException {
            try {
                if (!ActivatorConnection.this.isReady()) {
                    throw new FabricRequestException("Session with Activator is not established.");
                }
                SLWrapper data = (SLWrapper)((OpaqueEvent)request).getData();
                SLResponse response = ActivatorConnection.this.invokeSessionCommand(ActivatorConnection.this.dslProvider, this.mfSession, data, data.getOperationTimeout());
                if (response == null) {
                    response = (SLResponse)ActivatorConnection.this.invokeRequest((byte)8, new Activator.CommandData(this.mfSession, data), data.getOperationTimeout());
                }
                return AbstractAccessorProxy.createResponseEvent(response);
            }
            catch (Exception exception) {
                throw new FabricRequestException(exception);
            }
        }
    }

    private class PacketHandlerImpl
    extends ActivatorNetworkConnection.DefaultPacketHandler {
        PacketHandlerImpl(Connection connection) {
            super(connection);
        }

        @Override
        protected Object processRequest(byte type, byte[] bytes, Object data, long timeout) throws FabricException {
            switch (type) {
                case 4: {
                    FabricThreadManager.getInstance().createThread("FSYS:Shutdown.Executor", "Executes a shutdown of the node.", () -> {
                        Utils.sleep(500L);
                        Trace.logInfo(Activator.class, "Activator shut down. Exiting...");
                        System.exit(0);
                    }).start();
                    break;
                }
                case 6: {
                    return ActivatorConnection.this.raiseFileMessage(data, timeout);
                }
                case 8: {
                    try {
                        return ActivatorConnection.this.container.invokeRoutedContainerRequest(((Activator.CommandData)data).nodeName, bytes, timeout);
                    }
                    catch (Exception exception) {
                        if (exception instanceof FabricException) {
                            throw (FabricException)exception;
                        }
                        throw new FabricException("Invocation of command failed.", exception);
                    }
                }
                case 9: {
                    return ActivatorConnection.this.onMnodeRequest(((Activator.MNodeRequestData)data).requestId, ((Activator.MNodeRequestData)data).data);
                }
                case 12: {
                    ActivatorConnection.this.openFileRaiser((ActivatorMFSession)data);
                    break;
                }
                case 13: {
                    ActivatorConnection.this.closeFileRaiser((ActivatorMFSession)data);
                }
            }
            return null;
        }

        @Override
        protected Object processBroadcastRequest(byte type, byte[] data, long timeout) throws FabricException {
            switch (type) {
                case 10: {
                    try {
                        return ActivatorConnection.this.container.broadcastRoutedContainerRequest(data, timeout);
                    }
                    catch (Exception exception) {
                        throw new FabricException(exception);
                    }
                }
            }
            return null;
        }

        @Override
        public void onPacket(byte[] packet) {
            try {
                Object data = ActivatorConnection.this.connection.unpack(this.getMessageBytes(packet));
                if (data instanceof Activator.EventData) {
                    ActivatorConnection.this.container.raiseEvent(((Activator.EventData)data).event, ((Activator.EventData)data).eventScope);
                } else if (data instanceof Activator.LogEventData) {
                    ActivatorConnection.this.container.raiseLogEvent(((Activator.LogEventData)data).source, ((Activator.LogEventData)data).trace, ((Activator.LogEventData)data).eventScope);
                } else if (data instanceof SLMessage) {
                    ActivatorConnection.this.container.raiseSLMessage((SLMessage)data);
                }
            }
            catch (Exception exception) {
                ActivatorConnection.this.container.logException(exception, "Packet processing failed.");
            }
        }
    }
}

