/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.ContainerLockSupport;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

abstract class AbstractStartStopNodeOperation
extends AbstractMNodeOperation {
    protected static volatile boolean inProgress = false;
    protected static final Object mutex = new Object();
    protected static final int MIN_PORT = 9999;
    protected static final int MAX_PORT = 65535;

    AbstractStartStopNodeOperation(String operationName, String description) {
        super(true, true);
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName.toUpperCase()).addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().setSyntaxHintSpace()).addParameter(new IdentifierParameter("NodeName"))).addModifier((AbstractModifier)new Modifier("ALL").setAlias("*")));
        this.addTimeoutModifier();
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false).setName("WithWait"));
        this.syntax.setDescription(description);
        this.setExamples(operationName);
        this.syntax.addCompletionCommand("list managed nodes");
    }

    protected void addTimeoutModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("TIMEOUT", false).addParameter(new LongParameter("Timeout")));
    }

    protected void addAdminModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("ADMIN", false).addParameter(new StringParameter("URL")));
    }

    protected void setExamples(String operationName) {
        this.syntax.setExamples(operationName + " ExampleNode\n" + operationName + " all\n" + operationName + " ExampleNode timeout 10\n" + operationName + " ExampleNode with wait\n" + operationName + " ExampleNode timeout 10 with wait");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((MNodeRuntimeContext)this.callable).getManagedNodes().stream().filter(node -> node != null && this.isOperationAllowed((ManagedNode)node)).map(ManagedNode::getName).collect(Collectors.toList()));
        if (completions.size() > 0) {
            completions.add(0, "all");
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        AbstractDefinition definition = statement.existsParameter("NodeName") && !statement.getParameter("NodeName").getValue().equalsIgnoreCase("ALL") ? this.createDefinition(statement.getParameter("NodeName").getValue()) : this.createDefinition(true);
        this.setTimeout(statement, definition);
        if (statement.existsModifier("WithWait")) {
            definition.withWait = true;
        }
        this.setOtherParameters(statement, definition);
        return definition;
    }

    protected void setTimeout(DSLStatement statement, AbstractDefinition definition) {
        if (statement.existsParameter("Timeout")) {
            definition.timeout = Integer.parseInt(statement.getParameter("Timeout").getValue());
        }
    }

    protected void setOtherParameters(DSLStatement statement, AbstractDefinition definition) {
        if (statement.existsModifier("ADMIN")) {
            ((AbstractStartNodeDefinition)definition).setAdminURL(statement.getParameter("URL").getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Object object = mutex;
        synchronized (object) {
            if (inProgress) {
                return new SLResponse("Operation with managed nodes is already in progress.", false);
            }
            inProgress = true;
            AbstractDefinition definition = (AbstractDefinition)statement;
            if (definition.withWait) {
                SLResponse response;
                SynchronousOperationExecutor executor = new SynchronousOperationExecutor();
                try {
                    executor.doExecute(definition, session);
                    response = new SLResponse();
                }
                catch (Exception exception) {
                    response = new SLResponse(exception);
                }
                response.setMessages(executor.getMessages());
                return response;
            }
            AsynchronousOperationExecutor executor = new AsynchronousOperationExecutor(this, (AbstractDefinition)statement, session);
            executor.start();
            if (definition.asyncWithWait) {
                executor.join();
                return new SLResponse();
            }
            return new PseudoSLResponse();
        }
    }

    protected abstract boolean isOperationAllowed(ManagedNode var1);

    protected abstract void doOperation(ManagedNode var1, AbstractDefinition var2, MFSession var3) throws Exception;

    protected abstract AbstractDefinition createDefinition(String var1);

    protected abstract AbstractDefinition createDefinition(boolean var1);

    protected static class AbstractDefinition
    extends AbstractSLStatement {
        String nodeName;
        boolean isAll = false;
        int timeout = -1;
        boolean withWait = false;
        boolean asyncWithWait = false;

        AbstractDefinition(String operationName, String nodeName) {
            this(operationName, nodeName, -1, false);
        }

        AbstractDefinition(String operationName, String nodeName, int timeout, boolean withWait) {
            super(operationName);
            this.nodeName = nodeName;
            this.timeout = timeout;
            this.withWait = withWait;
        }

        AbstractDefinition(String operationName, boolean isAll) {
            this(operationName, isAll, -1, false);
        }

        AbstractDefinition(String operationName, boolean isAll, boolean asyncWithWait) {
            super(operationName);
            this.isAll = isAll;
            this.asyncWithWait = asyncWithWait;
        }

        AbstractDefinition(String operationName, boolean isAll, int timeout, boolean withWait) {
            super(operationName);
            this.isAll = isAll;
            this.timeout = timeout;
            this.withWait = withWait;
        }

        AbstractDefinition(String operationName, AbstractDefinition other) {
            super(operationName);
            this.nodeName = other.nodeName;
            this.isAll = other.isAll;
            this.timeout = other.timeout;
            this.withWait = other.withWait;
            this.asyncWithWait = other.asyncWithWait;
        }
    }

    protected static class AbstractStartNodeDefinition
    extends AbstractDefinition {
        String adminURL;

        AbstractStartNodeDefinition(String operationName, String nodeName) {
            super(operationName, nodeName);
        }

        AbstractStartNodeDefinition(String operationName, boolean isAll) {
            super(operationName, isAll);
        }

        AbstractStartNodeDefinition(String operationName, boolean isAll, boolean asyncWithWait) {
            super(operationName, isAll, asyncWithWait);
        }

        AbstractStartNodeDefinition(String operationName, AbstractStartNodeDefinition other) {
            super(operationName, other);
            this.adminURL = other.adminURL;
        }

        void setAdminURL(String adminURL) {
            this.adminURL = adminURL;
        }
    }

    class SynchronousOperationExecutor
    extends OperationExecutor {
        private List<String> messages;

        SynchronousOperationExecutor() {
            this.messages = new ArrayList<String>();
        }

        @Override
        protected void processSuccess(String nodeName) throws FabricException {
            this.messages.add("Node '" + nodeName + "' " + (AbstractStartStopNodeOperation.this.getName().contains("start") ? "started" : "stopped") + ".");
        }

        @Override
        protected void processException(String nodeName, Exception exception, MFSession session) throws FabricException {
            if (exception != null) {
                throw new FabricException("Operation failed. Cause: " + exception.getMessage());
            }
        }

        public List<String> getMessages() {
            return this.messages;
        }
    }

    class AsynchronousOperationExecutor
    extends SingleTaskWorker {
        AbstractDefinition definition;
        MFSession session;

        protected AsynchronousOperationExecutor(AbstractStartStopNodeOperation operation, AbstractDefinition definition, MFSession session) {
            super("FSYS:AsynchronousOperationExecutor", "Executes '" + operation.getName() + "' operation.");
            this.definition = definition;
            this.session = session;
        }

        @Override
        protected void doExecute() throws FabricException {
            new OperationExecutor(){

                @Override
                protected void processException(String nodeName, Exception exception, MFSession session) throws FabricException {
                    if (exception != null) {
                        AbstractStartStopNodeOperation.this.raiseSLMessageError(exception.getMessage(), session);
                    } else {
                        AbstractStartStopNodeOperation.this.raiseSLMessage(null, session);
                    }
                }
            }.doExecute(this.definition, this.session);
        }
    }

    protected static abstract class AbstractNodeActor {
        ManagedNode node;
        AbstractDefinition definition;
        ContainerLockSupport.RemoteNodeLock remoteNodeLock;

        AbstractNodeActor(ManagedNode node, AbstractDefinition definition) throws Exception {
            this.node = node;
            this.definition = definition;
            this.remoteNodeLock = ContainerLockSupport.getRemoteNodeLock(node.getDir());
        }
    }

    abstract class OperationExecutor {
        OperationExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doExecute(AbstractDefinition definition, MFSession session) throws FabricException {
            Utils.sleep(1000L);
            try {
                if (definition.isAll) {
                    List<ManagedNode> nodes = ((MNodeRuntimeContext)AbstractStartStopNodeOperation.this.callable).getManagedNodes();
                    if (AbstractStartStopNodeOperation.this.getName().equals("stop managed node")) {
                        Collections.reverse(nodes);
                    }
                    for (ManagedNode node : nodes) {
                        if (!AbstractStartStopNodeOperation.this.isOperationAllowed(node)) continue;
                        try {
                            AbstractStartStopNodeOperation.this.doOperation(node, definition, session);
                            this.processSuccess(node.getName());
                            Utils.sleep(1000L);
                        }
                        catch (Exception exception) {
                            this.processException(node.getName(), exception, session);
                        }
                    }
                } else {
                    try {
                        AbstractStartStopNodeOperation.this.doOperation(((MNodeRuntimeContext)((AbstractStartStopNodeOperation)AbstractStartStopNodeOperation.this).callable).container.getManagedNodes().getNode(definition.nodeName), definition, session);
                    }
                    catch (Exception exception) {
                        this.processException(definition.nodeName, exception, session);
                    }
                }
                if (!definition.asyncWithWait) {
                    this.processException(null, null, session);
                }
            }
            finally {
                inProgress = false;
            }
        }

        protected void processSuccess(String nodeName) throws FabricException {
        }

        protected abstract void processException(String var1, Exception var2, MFSession var3) throws FabricException;
    }
}

