/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.Utils;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

abstract class AbstractImportManagedNodeOperation
extends AbstractFrmNodeOperation<MNodeRuntimeContext> {
    public AbstractImportManagedNodeOperation(String operationName) {
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName).addActionParameter(new IdentifierParameter("NodeName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("FROM").setName("FrmPathModifier")).addParameter(new SLFilePathParameter("FrmPath"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false).setName("WithWait"));
        this.syntax.addCompletionCommand("list managed nodes");
        this.syntax.addTag(OperationTag.mnode);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        ((MNodeRuntimeContext)this.callable).getManagedNodes().stream().filter(node -> node != null && this.isOperationAllowed((ManagedNode)node)).map(ManagedNode::getName).forEach(completions::add);
    }

    protected boolean isOperationAllowed(ManagedNode node) {
        return !node.isRunning();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getName(), statement.getParameter("NodeName").getValue(), statement.getParameter("FrmPath").getValue(), !statement.existsModifier("WithWait"));
    }

    @Override
    protected void checkBeforeExecute(AbstractFrmNodeOperation.Definition definition, MFSession session) throws Exception {
        ManagedNode existingNode = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.getNodeName());
        if (existingNode == null) {
            throw new FabricException("Node not found.");
        }
        if (existingNode.isRunning()) {
            throw new FabricException("Node is running.");
        }
        if (existingNode.isOperationInProgress()) {
            throw new FabricException("Another operation is in progress.");
        }
        this.doCheckBeforeExecute(existingNode, session);
    }

    protected abstract void doCheckBeforeExecute(ManagedNode var1, MFSession var2) throws Exception;

    @Override
    protected SLResponse execute(AbstractFrmNodeOperation.Definition definition, MFSession session, long timeout) throws Exception {
        this.raiseSLMessage("\n", session);
        ManagedNode existingNode = ((MNodeRuntimeContext)this.callable).container.getManagedNodes().getNode(definition.getNodeName());
        try (InputStream input = this.openFrmInputStream(session, definition);){
            File nodeDir = new File(existingNode.getDir());
            if (!nodeDir.exists()) {
                FileIOUtils.newFileDir(nodeDir.getAbsolutePath());
            }
            HashSet<String> exclusionFiles = new HashSet<String>(Arrays.asList("manifest.frmm"));
            String nodeDdx = AbstractMNodeOperation.getRelativeDdx(existingNode);
            if (nodeDdx != null) {
                exclusionFiles.add(new File(nodeDdx, "stdeploy.jar").getPath());
            }
            try (FrmFileReader frmFile = new FrmFileReader(input);){
                frmFile.extractTo(nodeDir, exclusionFiles);
            }
            this.raiseSLMessage("\nFRM file extracted.\n", session);
            this.doCompleteExecution(definition, existingNode);
            SLResponse sLResponse = new SLResponse();
            return sLResponse;
        }
    }

    protected abstract void doCompleteExecution(AbstractFrmNodeOperation.Definition var1, ManagedNode var2) throws Exception;

    @Override
    protected void raiseSLMessage(String message, MFSession session) {
        super.raiseSLMessage(message, session);
        Utils.sleep(10L);
    }

    protected static class Definition
    extends AbstractFrmNodeOperation.Definition {
        public Definition(String operationName, String nodeName, String frmPath, boolean isAsync) {
            super(operationName, nodeName, frmPath, isAsync);
        }
    }
}

