/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.utils.WrongParameterException;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.tools.mnode.AbstractMNodeOperation;
import com.streamscape.tools.mnode.MNodeRuntimeContext;
import com.streamscape.tools.mnode.ManagedNode;
import com.streamscape.tools.mnode.ManagementNode;
import com.streamscape.tools.mnode.ManagementNodeFactory;
import java.io.File;

abstract class AbstractAddSetNodeOperation
extends AbstractMNodeOperation {
    AbstractAddSetNodeOperation(String name) {
        super(true, false);
        this.createDSLSyntax(name);
    }

    static void addDirDdxModifiers(DSLStatementSyntax syntax, boolean required) {
        syntax.addModifier((AbstractModifier)new Modifier("-DIR", required).addParameter(new LocalPathParameter("working_directory")));
        syntax.addModifier((AbstractModifier)new Modifier("-DDX", required).addParameter(new LocalPathParameter("path_to_deployment_descriptor")));
    }

    static String getDirDdxModifiersDescription() {
        return "   -dir           - Working directory of the new node.\n   -ddx           - Location of a deployment descriptor archive of the new node (i.e. stdeploy.jar).\n";
    }

    static void addCommonCreateAddSetModifiers(DSLStatementSyntax syntax, boolean isSet) {
        syntax.addModifier((AbstractModifier)new Modifier("-EXEC-DIR", false).addParameter(new LocalPathParameter("path_to_tnode_executable")));
        syntax.addModifier((AbstractModifier)new Modifier("-JAVA-CFG", false).addParameter(new LocalPathParameter("path_to_jvm_parameters_file")));
        syntax.addModifier((AbstractModifier)new Modifier("-JAVA-ARGS", false).addParameter(new StringParameter("jvm_parameters", Character.valueOf('\''), Character.valueOf('\''))));
        syntax.addModifier((AbstractModifier)new Modifier("-JAVA-HOME", false).addParameter(new LocalPathParameter("path_to_java_home")));
        syntax.addModifier((AbstractModifier)new Modifier("-LOG", false).addParameter(new StringParameter("log_filename", Character.valueOf('\''), Character.valueOf('\''))));
        AbstractAddSetNodeOperation.addBooleanModifier(syntax, "-LOG-BROADCAST", "is_log_broadcast", isSet);
        AbstractAddSetNodeOperation.addBooleanModifier(syntax, "-DEBUG", "is_debug", isSet);
        syntax.addModifier((AbstractModifier)new Modifier("-ADMIN", false).addParameter(new StringParameter("URL")));
        AbstractAddSetNodeOperation.addBooleanModifier(syntax, "AUTOSTART", "is_autostart", isSet);
        syntax.addModifier((AbstractModifier)new Modifier("DELAY", false).addParameter(new IntegerParameter("delay")));
        syntax.addModifier((AbstractModifier)new Modifier("TIMEOUT", false).addParameter(new LongParameter("timeout")));
        syntax.addModifier(new CompoundModifier("OrderChoiceCompound", false).addModifier(new Modifier("POSITION")).addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("PositionChoice").addModifier(new Modifier("FIRST"))).addModifier(new Modifier("LAST"))).addModifier((AbstractModifier)new Modifier("BEFORE NODE").addParameter(new IdentifierParameter("beforeNodeName")))).addModifier((AbstractModifier)new Modifier("AFTER NODE").addParameter(new IdentifierParameter("afterNodeName")))));
    }

    protected String getCommonCreateAddSetModifiersDescription() {
        return "   -exec-dir      - Path to the directory containing executable file for managed node (i.e. tnode.exe or tnode.sh).\n                    If this parameter is not specified, $STROOT/bin or the current directory will be used.\n   -java-cfg      - Path to the file containing JVM options. Default is tnode.conf.\n   -java-args     - List of JVM options (e.g. '-Xms128m -Xmx256m').\n   -java-home     - Path to Java Home directory (e.g. 'C:/Program Files/Java/jdk1.8').\n                    If this parameter is not specified, a standard Java installation will be searched.\n   -log           - Allows the node to write trace messages to the specified log file. Default is tnode.log.\n   -log-broadcast - Allows the node to broadcast trace messages as events (with event id [event.log.&lt;NodeName&gt;]).\n   -debug         - Allows the node to print launcher debug information to a debug.log file.\n" + this.getAdminDescription() + "\n   autostart      - Allows the management node to automatically start this node.\n   delay          - Delay (in seconds) before automatic start-up of the node. Default is 1 second.\n   timeout        - Wait time (in seconds) for automatic start-up of the node. Default is 180 seconds.\n   position       - Sets a position for the new node in the list of managed nodes. By default the node is added to the end of the list.";
    }

    protected String getAdminDescription() {
        return "   -admin         - Allows the node to initialize and start an administrative HTTP acceptor with the specified URL.\n                    URL must have the following format: [$hostname:[(&lt;NetworkInterface&gt;):]]<Port>.\n                    Examples: <u>9999</u>, <u>$hostname:9999</u>, <u>$hostname:(eth0):9999</u>, <u>$hostname:(1):9999</u>.\n";
    }

    private static void addBooleanModifier(DSLStatementSyntax syntax, String modifierToken, String parameter, boolean isSet) {
        Modifier modifier = new Modifier(modifierToken, false);
        modifier.addParameter(new BooleanParameter(parameter));
        syntax.addModifier(modifier);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        ManagedNode node = new ManagedNode();
        node.setDir(statement.getParameter("working_directory").getValue());
        node.setDdx(statement.getParameter("path_to_deployment_descriptor").getValue());
        node.setExecDir(statement.getParameter("path_to_tnode_executable").getValue());
        node.setJavaCfg(statement.getParameter("path_to_jvm_parameters_file").getValue());
        node.setJavaArgs(statement.getParameter("jvm_parameters").getValue());
        node.setJavaHome(statement.getParameter("path_to_java_home").getValue());
        node.setLog(statement.getParameter("log_filename").getValue());
        if (statement.existsParameter("is_log_broadcast")) {
            node.setLogBroadcast(Boolean.valueOf(statement.getParameter("is_log_broadcast").getValue().toLowerCase()));
        } else {
            node.setLogBroadcast(null);
        }
        if (statement.existsParameter("is_debug")) {
            node.setDebug(Boolean.valueOf(statement.getParameter("is_debug").getValue().toLowerCase()));
        } else {
            node.setDebug(null);
        }
        if (statement.existsModifier("-ADMIN")) {
            node.setAdmin(statement.getParameter("URL").getValue());
        } else {
            node.setAdmin(null);
        }
        if (statement.existsParameter("is_autostart")) {
            node.setAutoStart(Boolean.valueOf(statement.getParameter("is_autostart").getValue().toLowerCase()));
        } else {
            node.setAutoStart(null);
        }
        if (statement.existsParameter("delay")) {
            node.setDelayBeforeStart(Integer.valueOf(statement.getParameter("delay").getValue().toLowerCase()));
        } else {
            node.setDelayBeforeStart(null);
        }
        if (statement.existsParameter("timeout")) {
            node.setStartTimeout(Long.valueOf(statement.getParameter("timeout").getValue().toLowerCase()));
        } else {
            node.setStartTimeout(null);
        }
        Definition definition = new Definition(this.syntax.getName(), node);
        if (statement.existsModifier("FIRST")) {
            definition.position = Definition.Position.BEFORE;
        } else if (statement.existsModifier("LAST")) {
            definition.position = Definition.Position.AFTER;
        } else if (statement.existsParameter("beforeNodeName")) {
            definition.position = Definition.Position.BEFORE;
            definition.positionNodeName = statement.getParameter("beforeNodeName").getValue();
        } else if (statement.existsParameter("afterNodeName")) {
            definition.position = Definition.Position.AFTER;
            definition.positionNodeName = statement.getParameter("afterNodeName").getValue();
        }
        return definition;
    }

    void addNodeToContainer(Definition definition) throws Exception {
        ManagementNodeFactory.copyObject(new ManagementNode(((MNodeRuntimeContext)this.callable).getName()), definition.managedNode);
        if (definition.position == Definition.Position.BEFORE) {
            if (definition.positionNodeName != null) {
                ((MNodeRuntimeContext)this.callable).container.getManagedNodes().insertNodeBefore(definition.managedNode, definition.positionNodeName);
            } else {
                ((MNodeRuntimeContext)this.callable).container.getManagedNodes().prependNode(definition.managedNode);
            }
        } else if (definition.position == Definition.Position.AFTER) {
            if (definition.positionNodeName != null) {
                ((MNodeRuntimeContext)this.callable).container.getManagedNodes().insertNodeAfter(definition.managedNode, definition.positionNodeName);
            } else {
                ((MNodeRuntimeContext)this.callable).container.getManagedNodes().appendNode(definition.managedNode);
            }
        } else {
            ((MNodeRuntimeContext)this.callable).container.getManagedNodes().appendNode(definition.managedNode);
        }
    }

    void checkPositionNodeName(Definition definition) throws Exception {
        if (definition.positionNodeName != null && !((MNodeRuntimeContext)this.callable).container.getManagedNodes().existsNode(definition.positionNodeName)) {
            throw new Exception("Managed node '" + definition.positionNodeName + "' does not exist.");
        }
    }

    static String getJavaCfgPath(ManagedNode node) {
        return AbstractAddSetNodeOperation.getJavaCfgPath(node.getJavaCfg(), node);
    }

    static String getJavaCfgPath(String javaCfg, ManagedNode node) {
        return new File(javaCfg).isAbsolute() ? javaCfg : node.getDir() + "/" + javaCfg;
    }

    static void checkError(String parameterName, String parameterValue, boolean isDirectory) throws WrongParameterException {
        AbstractAddSetNodeOperation.checkError(AbstractAddSetNodeOperation.exists(parameterValue, isDirectory), parameterName, (isDirectory ? "directory '" : "file '") + parameterValue + "' does not exist.");
    }

    static void checkError(boolean condition, String parameterName, String errorMessage) throws WrongParameterException {
        if (!condition) {
            throw new WrongParameterException(parameterName, errorMessage);
        }
    }

    static void checkError(boolean condition, String errorMessage) throws FabricException {
        if (!condition) {
            throw new FabricException(errorMessage);
        }
    }

    static void checkWarning(String parameterName, String parameterValue, boolean isDirectory, StringBuilder response) {
        if (!AbstractAddSetNodeOperation.exists(parameterValue, isDirectory)) {
            AbstractAddSetNodeOperation.printWarning(parameterName, parameterValue, (isDirectory ? "directory '" : "file '") + parameterValue + "' does not exist.", response);
        }
    }

    static void printWarning(String parameterName, String parameterValue, String message, StringBuilder response) {
        if (response.length() > 0) {
            response.append("\n");
        }
        response.append("WARNING: Parameter '").append(parameterName).append("' will be ignored: ").append(message);
    }

    static boolean exists(String parameterValue, boolean isDirectory) {
        return parameterValue == null || (isDirectory ? new File(parameterValue).isDirectory() : new File(parameterValue).exists());
    }

    public static class Definition
    extends AbstractSLStatement {
        ManagedNode managedNode;
        Position position;
        String positionNodeName;

        public Definition(String name, ManagedNode managedNode) {
            super(name);
            this.managedNode = managedNode;
        }

        public ManagedNode getManagedNode() {
            return this.managedNode;
        }

        static enum Position {
            BEFORE,
            AFTER;

        }
    }
}

