/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.log.monitor;

import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogEventSourceResolver;
import com.streamscape.tools.log.monitor.LogMonitor;
import java.io.File;

public class SimpleLogEventSourceResolver
implements LogEventSourceResolver {
    @Override
    public void prepare() {
    }

    @Override
    public boolean resolve(LogEventSource source) {
        Pair<String, Boolean> result = this.doResolve(source);
        String error = (String)result.first;
        if (error == null) {
            if (source.isValid()) {
                return (Boolean)result.second;
            }
            return this.setError(source, null);
        }
        if (source.isValid() || !Utils.equalsNullSafe(source.getError(), error)) {
            return this.setError(source, error);
        }
        return (Boolean)result.second;
    }

    protected Pair<String, Boolean> doResolve(LogEventSource source) {
        return new Pair<String, Boolean>(this.validateFilename(source), false);
    }

    protected String validateFilename(LogEventSource source) {
        if (StringUtils.isEmpty(source.getLogFilename())) {
            source.setLogFileFound(false);
            LogMonitor.logError("Log filename not set (source '" + String.valueOf(source) + "').");
            return "Log filename not set.";
        }
        if (!new File(source.getLogFilename()).exists()) {
            source.setLogFileFound(false);
            LogMonitor.logInfo("WARNING: Log file '" + source.getLogFilename() + "' not found (source '" + String.valueOf(source) + "').");
        } else {
            source.setLogFileFound(true);
        }
        return null;
    }

    protected boolean setError(LogEventSource source, String error) {
        source.setError(error);
        return true;
    }
}

