/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.log.monitor;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.tools.log.monitor.LogEventForwarder;
import com.streamscape.tools.log.monitor.LogEventForwarderConfiguration;
import com.streamscape.tools.log.monitor.LogEventForwarderConfigurationImpl;
import com.streamscape.tools.log.monitor.LogEventForwarderState;
import com.streamscape.tools.log.monitor.LogEventLocalForwarder;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogEventSourceResolver;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.log.monitor.LogMonitorConfiguration;
import com.streamscape.tools.log.monitor.LogMonitorFactory;
import com.streamscape.tools.log.monitor.LogMonitorListener;
import com.streamscape.tools.log.monitor.SimpleLogEventSourceResolver;
import com.streamscape.tools.log.monitor.Version;
import com.streamscape.tools.tailer.impl.FileTailerExecutor;
import com.streamscape.tools.tailer.impl.FileTailerInputStream;
import com.streamscape.tools.tailer.impl.RotationFilenameProvider;
import com.streamscape.tools.tailer.impl.RotationFilesListByFilenameProvider;
import com.streamscape.tools.tailer.impl.SimpleRotationResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

class LogMonitorImpl
implements LogMonitor {
    private LogMonitorConfiguration configuration;
    private LogEventForwarderConfigurationImpl forwarderConfiguration;
    private boolean autoStart = false;
    private long timeStamp = System.currentTimeMillis();
    private transient LogMonitorFactory factory;
    private transient LogEventSourceResolver sourceResolver;
    private transient Map<String, LogMonitorListener> typeListeners;
    private transient LogEventForwarder forwarder;
    private transient LogEventLocalForwarder localForwarder;
    private transient Map<String, ListenerHolder> holders;
    private transient FabricThread monitorThread;
    private volatile transient boolean isInitialized = false;
    private volatile transient boolean isStarted = false;
    private transient String lastError;

    protected void setFactory(LogMonitorFactory factory) {
        this.factory = factory;
    }

    String getDomain() {
        return this.factory != null ? this.factory.getDomain() : null;
    }

    String getNodeName() {
        return this.factory != null ? this.factory.getNodeName() : null;
    }

    @Override
    public synchronized void init() throws FabricException {
        if (!this.isInitialized) {
            if (this.sourceResolver == null) {
                this.sourceResolver = new SimpleLogEventSourceResolver();
            }
            this.typeListeners = new ConcurrentHashMap<String, LogMonitorListener>();
            this.holders = new ConcurrentHashMap<String, ListenerHolder>();
            boolean changed = false;
            if (this.configuration != null) {
                changed |= this.doSet(this.configuration);
            }
            if (this.forwarderConfiguration != null) {
                changed |= this.initForwarder(this.forwarderConfiguration);
            }
            if (changed) {
                this.onUpdate();
            }
            this.isInitialized = true;
        }
    }

    @Override
    public synchronized void setConfiguration(LogMonitorConfiguration configuration) throws FabricException {
        this.checkInitialized();
        boolean changed = true;
        if (!this.isStarted) {
            changed = this.doSet(configuration);
        } else {
            this.doUpdate(configuration);
        }
        this.configuration = configuration;
        if (changed) {
            this.onUpdate();
        }
        if (this.forwarder != null && this.forwarder.isStarted()) {
            this.forwarder.setMonitorConfiguration(this.configuration);
        }
    }

    synchronized void updateConfiguration(LogMonitorConfiguration configuration) throws FabricException {
        this.doUpdate(configuration);
        this.configuration = configuration;
        this.onUpdate();
    }

    private boolean doSet(LogMonitorConfiguration configuration) throws FabricException {
        boolean changed = this.isChanged(configuration) | this.doResolve(configuration);
        this.holders.clear();
        configuration.getSources().stream().filter(LogEventSource::isValid).forEach(source -> this.doAddHolder((LogEventSource)source, null));
        return changed;
    }

    private void doUpdate(LogMonitorConfiguration configuration) throws FabricException {
        this.doResolve(configuration);
        List<LogEventSource> oldSources = this.configuration.getSources();
        List<LogEventSource> newSources = configuration.getSources();
        ArrayList<LogEventSource> updatedSources = new ArrayList<LogEventSource>();
        ArrayList<LogEventSource> addedSources = new ArrayList<LogEventSource>();
        for (LogEventSource newSource : newSources) {
            int index = oldSources.indexOf(newSource);
            if (index != -1) {
                LogEventSource oldSource = oldSources.remove(index);
                if (!this.holders.containsKey(oldSource.getFullName()) || newSource.getLogFilename() != null && FileIOUtils.equals(oldSource.getLogFilename(), newSource.getLogFilename())) continue;
                updatedSources.add(newSource);
                continue;
            }
            addedSources.add(newSource);
        }
        this.processAddedSources(addedSources);
        this.processRemovedSources(oldSources);
        this.processUpdatedSources(updatedSources);
    }

    private void processAddedSources(List<LogEventSource> sources) {
        sources.forEach(source -> {
            this.doAddHolder((LogEventSource)source);
            LogMonitor.logInfo("Source '" + source.getFullName() + "' added.");
        });
    }

    private void processRemovedSources(List<LogEventSource> sources) {
        sources.forEach(source -> {
            this.closeHolder(this.holders.remove(source.getFullName()));
            LogMonitor.logInfo("Source '" + source.getFullName() + "' removed.");
        });
    }

    private void processUpdatedSources(List<LogEventSource> sources) {
        sources.forEach(source -> {
            this.closeHolder(this.holders.remove(source.getFullName()));
            if (source.isValid()) {
                this.doAddHolder((LogEventSource)source);
            }
            LogMonitor.logInfo("Source '" + source.getFullName() + "' updated.");
        });
    }

    private boolean doResolve(LogMonitorConfiguration configuration) throws FabricException {
        LogMonitor.logInfo("Resolving configuration...");
        LogMonitorImpl.checkConfiguration(configuration);
        boolean changed = this.resolveSources(configuration);
        LogMonitor.logInfo("Configuration resolved.");
        return changed;
    }

    private boolean resolveSources(LogMonitorConfiguration configuration) {
        this.sourceResolver.prepare();
        boolean changed = false;
        for (LogEventSource source : configuration.getSources()) {
            changed |= this.sourceResolver.resolve(source);
        }
        return changed;
    }

    private boolean isChanged(LogMonitorConfiguration configuration) {
        return this.configuration == null && configuration != null || configuration != null && (this.configuration.getInterval() != configuration.getInterval() || this.configuration.getMaxBlockSize() != configuration.getMaxBlockSize() || this.configuration.getMaxSizeOnIteration() != configuration.getMaxSizeOnIteration());
    }

    @Override
    public LogEventForwarderConfiguration createForwarderConfigurationInstance() {
        return new LogEventForwarderConfigurationImpl();
    }

    @Override
    public synchronized void setForwarderConfiguration(LogEventForwarderConfiguration configuration) throws FabricException {
        if (!this.isStarted) {
            if (configuration == null) {
                LogMonitor.logInfo("Log Event Forwarder disabled.");
                this.forwarder = null;
            } else {
                this.initForwarder(configuration);
            }
        } else {
            throw new FabricException("Configuration cannot be changed while monitor is running.");
        }
        this.forwarderConfiguration = (LogEventForwarderConfigurationImpl)configuration;
        this.onUpdate();
    }

    private boolean initForwarder(LogEventForwarderConfiguration forwarderConfiguration) throws FabricException {
        boolean changed = false;
        if (this.configuration != null && !Utils.equalsNullSafe(this.configuration.getName(), forwarderConfiguration.getName())) {
            this.configuration.setName(forwarderConfiguration.getName());
            changed = true;
        }
        if (forwarderConfiguration.getReconnectInterval() <= 0L) {
            forwarderConfiguration.setReconnectInterval(30L);
            changed = true;
        }
        if (forwarderConfiguration.getEventScope() == null) {
            forwarderConfiguration.setEventScope(EventScope.GLOBAL);
            changed = true;
        }
        this.forwarder = new LogEventForwarder(this, (LogEventForwarderConfigurationImpl)forwarderConfiguration);
        this.holders.values().stream().filter(holder -> holder.listener instanceof LogEventForwarder.Listener).forEach(holder -> {
            LogEventForwarder logEventForwarder = this.forwarder;
            Objects.requireNonNull(logEventForwarder);
            holder.listener = logEventForwarder.new LogEventForwarder.Listener(holder.source);
        });
        LogMonitor.logInfo("Log Event Forwarder enabled.");
        return changed;
    }

    @Override
    public LogMonitorConfiguration getConfiguration() {
        return this.configuration != null ? this.configuration.clone() : null;
    }

    LogMonitorConfiguration doGetConfiguration() {
        return this.configuration;
    }

    @Override
    public LogEventForwarderConfiguration getForwarderConfiguration() {
        return this.forwarderConfiguration != null ? this.forwarderConfiguration.clone() : null;
    }

    @Override
    public void setLocalForwarder(LogEventLocalForwarder localForwarder) {
        this.localForwarder = localForwarder;
    }

    LogEventLocalForwarder getLocalForwarder() {
        return this.localForwarder;
    }

    @Override
    public void setSourceResolver(LogEventSourceResolver sourceResolver) {
        if (sourceResolver != null) {
            this.sourceResolver = sourceResolver;
        }
    }

    @Override
    public synchronized void addSources(List<LogEventSource> sources, LogMonitorListener listener) throws FabricException {
        this.checkConfiguration();
        this.sourceResolver.prepare();
        for (LogEventSource source : sources) {
            this.doAddSource(source, listener, false);
        }
        this.onUpdate();
    }

    @Override
    public synchronized void addSource(LogEventSource source, LogMonitorListener listener) throws FabricException {
        this.checkConfiguration();
        this.sourceResolver.prepare();
        this.doAddSource(source, listener, true);
    }

    private void doAddSource(LogEventSource source, LogMonitorListener listener, boolean needUpdate) {
        this.sourceResolver.resolve(source);
        LogEventSource oldSource = this.configuration.getSource(source.getSourceType(), source.getSourceName());
        if (this.configuration.existsSource(source) && this.isStarted) {
            this.closeHolder(this.holders.get(source.getFullName()));
        }
        this.addHolder(source, listener);
        this.configuration.addSource(source);
        if (this.forwarder != null && this.forwarder.isStarted()) {
            this.forwarder.setMonitorConfiguration(this.configuration);
        }
        this.onUpdate();
        LogMonitor.logInfo("Source '" + source.getFullName() + "' added.");
    }

    @Override
    public synchronized void removeSource(String sourceType, String sourceName) throws FabricException {
        this.checkConfiguration();
        if (this.configuration.removeSource(sourceType, sourceName)) {
            this.doRemoveSource(sourceType, sourceName);
            this.onUpdateSources();
        }
    }

    @Override
    public synchronized void removeSources(String sourceType) throws FabricException {
        this.checkConfiguration();
        boolean removed = false;
        for (LogEventSource source : this.configuration.getSources()) {
            if (!source.getSourceType().equals(sourceType) || !this.configuration.removeSource(source.getSourceType(), source.getSourceName())) continue;
            this.doRemoveSource(source.getSourceType(), source.getSourceName());
            removed = true;
        }
        if (removed) {
            this.onUpdateSources();
        }
    }

    private void doRemoveSource(String sourceType, String sourceName) {
        String fullName = LogEventSource.getFullName(sourceType, sourceName);
        this.closeHolder(this.holders.remove(fullName));
        LogMonitor.logInfo("Source '" + fullName + "' removed.");
    }

    private void onUpdateSources() {
        if (this.forwarder != null && this.forwarder.isStarted()) {
            this.forwarder.setMonitorConfiguration(this.configuration);
        }
        this.onUpdate();
    }

    @Override
    public synchronized boolean existsSource(String sourceType, String sourceName) {
        return this.configuration != null && this.configuration.existsSource(sourceType, sourceName);
    }

    @Override
    public synchronized void addExternalSourceType(String type) throws FabricException {
        this.checkConfiguration();
        if (!this.configuration.existsExternalSourceType(type)) {
            this.configuration.addExternalSourceType(type);
            this.onUpdate();
            LogMonitor.logInfo("Source type '" + type + "' added.");
        }
    }

    @Override
    public synchronized void removeExternalSourceType(String type) throws FabricException {
        this.checkConfiguration();
        if (this.configuration.removeExternalSourceType(type)) {
            this.onUpdate();
            LogMonitor.logInfo("Source type '" + type + "' removed.");
        }
    }

    @Override
    public synchronized boolean existsExternalSourceType(String type) {
        return this.configuration != null && this.configuration.existsExternalSourceType(type);
    }

    @Override
    public synchronized void setListener(String sourceType, LogMonitorListener listener) throws FabricException {
        this.checkConfiguration();
        if (!this.isStarted) {
            this.typeListeners.put(sourceType, listener);
        } else {
            this.doSetListener(sourceType, listener);
        }
    }

    private void doSetListener(String sourceType, LogMonitorListener listener) {
        this.holders.values().stream().filter(holder -> holder.source.getSourceType().equals(sourceType)).forEach(holder -> holder.setListener(listener));
    }

    @Override
    public synchronized void setListener(String sourceType, String sourceName, LogMonitorListener listener) throws FabricException {
        this.checkConfiguration();
        LogEventSource source = this.configuration.getSource(sourceType, sourceName);
        if (source == null) {
            throw new FabricException("Source '" + LogEventSource.getFullName(sourceType, sourceName) + "' does not exist.");
        }
        if (!source.isValid()) {
            throw new FabricException("Source '" + LogEventSource.getFullName(sourceType, sourceName) + "' is not valid.");
        }
        ListenerHolder holder = this.holders.get(source.getFullName());
        if (holder != null) {
            holder.setListener(listener);
        } else {
            this.addHolder(source, listener);
        }
    }

    private void addHolder(LogEventSource source, LogMonitorListener listener) {
        if (listener == null) {
            this.doAddHolder(source);
        } else {
            this.doAddHolder(source, listener);
        }
    }

    private void doAddHolder(LogEventSource source) {
        if (source.isValid()) {
            LogMonitorListener listener = this.typeListeners.get(source.getSourceType());
            if (listener != null) {
                this.addHolder(source, listener);
            } else if (this.forwarder != null) {
                LogEventForwarder logEventForwarder = this.forwarder;
                Objects.requireNonNull(logEventForwarder);
                this.addHolder(source, logEventForwarder.new LogEventForwarder.Listener(source));
            } else {
                LogMonitor.logError("Listener is not set for source '" + String.valueOf(source) + "'.");
            }
        }
    }

    private void doAddHolder(LogEventSource source, LogMonitorListener listener) {
        if (source.isValid()) {
            this.holders.put(source.getFullName(), new ListenerHolder(source, listener));
            LogMonitor.logInfo("Source '" + String.valueOf(source) + "' added. Log file: '" + source.getLogFilename() + "'.");
        }
    }

    @Override
    public boolean isAutoStart() {
        return this.autoStart;
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
        this.onUpdate();
    }

    @Override
    public synchronized void start() throws FabricException {
        this.checkInitialized();
        if (!this.isStarted) {
            try {
                this.startForwarder();
                this.checkConfiguration();
                this.resolveListeners();
                this.monitorThread = FabricThreadManager.getInstance().createThread("FSYS:LogMonitor", "Monitors log files.", new LogMonitorRunnable());
                this.monitorThread.start();
                this.clearLastError();
                this.isStarted = true;
            }
            catch (FabricException exception) {
                this.setLastError(exception);
                this.stopForwarder();
                throw exception;
            }
        }
    }

    private void startForwarder() throws FabricException {
        if (this.forwarder != null) {
            this.forwarder.start();
            LogMonitorConfiguration configuration = this.forwarder.getMonitorConfiguration(this.configuration);
            if (configuration != null) {
                this.setConfiguration(configuration);
            }
        }
    }

    private void resolveListeners() {
        this.holders.values().stream().filter(holder -> holder.removed).forEach(holder -> {
            holder.removed = false;
        });
        this.holders.values().stream().filter(holder -> holder.listener == null).forEach(holder -> {
            LogMonitorListener listener = this.typeListeners.get(holder.source.getSourceType());
            if (listener != null) {
                holder.listener = listener;
            } else if (this.forwarder != null) {
                LogEventForwarder logEventForwarder = this.forwarder;
                Objects.requireNonNull(logEventForwarder);
                holder.listener = logEventForwarder.new LogEventForwarder.Listener(holder.source);
            } else {
                LogMonitor.logError("Listener is not set for source '" + String.valueOf(holder.source) + "'.");
            }
        });
    }

    @Override
    public synchronized void stop() {
        if (this.isStarted) {
            this.stopForwarder();
            if (this.monitorThread != null) {
                this.monitorThread.interrupt();
                this.monitorThread = null;
            }
            this.closeAllHolders();
            this.isStarted = false;
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    private void stopForwarder() {
        if (this.forwarder != null) {
            this.forwarder.stop();
        }
    }

    private synchronized List<ListenerHolder> getHolders() {
        return new ArrayList<ListenerHolder>(this.holders.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHolder(ListenerHolder holder) {
        if (holder != null) {
            Object object = holder.mutex;
            synchronized (object) {
                holder.removed = true;
                if (holder.executor != null) {
                    holder.executor.close();
                    holder.executor = null;
                }
            }
        }
    }

    private void closeAllHolders() {
        this.holders.forEach((path, holder) -> this.closeHolder((ListenerHolder)holder));
    }

    private void checkConfiguration() throws FabricException {
        this.checkInitialized();
        LogMonitorImpl.checkConfiguration(this.configuration);
    }

    private static void checkConfiguration(LogMonitorConfiguration configuration) throws FabricException {
        if (configuration == null) {
            throw new FabricException("Configuration is not available.");
        }
    }

    private void checkInitialized() throws FabricException {
        if (!this.isInitialized) {
            throw new FabricException("Log Monitor is not initialized.");
        }
    }

    private void onUpdate() {
        this.timeStamp = System.currentTimeMillis();
        try {
            if (this.factory != null) {
                this.factory.saveObject(this);
                LogMonitor.logInfo("Object saved.");
            }
        }
        catch (FabricException exception) {
            LogMonitorImpl.logException((Throwable)exception, "Saving Log Monitor object failed.");
        }
    }

    @Override
    public String getVersion() {
        return Version.getVersion();
    }

    @Override
    public Date getUpdateTimestamp() {
        return this.timeStamp > 0L ? new Date(this.timeStamp) : null;
    }

    void setUpdateTimestamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public Date getLastEventTimestamp() {
        return this.forwarder != null ? this.forwarder.getLastEventTime() : null;
    }

    @Override
    public LogEventForwarderState getForwarderState() {
        return this.forwarder != null ? this.forwarder.getState() : LogEventForwarderState.DISCONNECTED;
    }

    @Override
    public String getLastError() {
        return this.lastError;
    }

    void setLastError(String error) {
        this.lastError = error;
    }

    void setLastError(Throwable exception) {
        this.setLastError(Utils.formatException(exception, "\n"));
    }

    void clearLastError() {
        this.lastError = null;
    }

    @Override
    public void forwardExternalEvent(MapEvent event) {
        try {
            if (this.forwarder != null && this.forwarder.isStarted() && this.existsExternalSourceType(event.getEventStringProperty("sourceType"))) {
                this.forwarder.raiseExternalEvent(event);
            }
        }
        catch (SDOException sDOException) {
            // empty catch block
        }
    }

    public static void logException(Throwable exception) {
        LogMonitorImpl.logException(exception, true);
    }

    public static void logException(Throwable exception, boolean printStackTrace) {
        Trace.logException(LogMonitor.class, exception, printStackTrace);
    }

    public static void logException(Throwable exception, String message) {
        LogMonitorImpl.logException(exception, message, true);
    }

    public static void logException(Throwable exception, String message, boolean printStackTrace) {
        LogMonitorImpl.logException(exception, printStackTrace);
        LogMonitor.logError(message);
    }

    private static class ListenerHolder {
        LogEventSource source;
        LogMonitorListener listener;
        volatile FileTailerExecutor executor;
        boolean removed = false;
        final Object mutex = new Object();

        ListenerHolder(LogEventSource source) {
            this.source = source;
        }

        ListenerHolder(LogEventSource source, LogMonitorListener listener) {
            this.source = source;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setListener(LogMonitorListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listener = listener;
            }
        }
    }

    private class LogMonitorRunnable
    implements Runnable {
        private LogMonitorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (LogMonitorImpl.this.isStarted && !Thread.currentThread().isInterrupted()) {
                long totalRead = 0L;
                for (ListenerHolder holder : LogMonitorImpl.this.getHolders()) {
                    Object object = holder.mutex;
                    synchronized (object) {
                        if (!holder.removed && holder.executor == null && holder.listener != null) {
                            Path path = Paths.get(holder.source.getLogFilename(), new String[0]);
                            SimpleRotationResolver resolver = null;
                            try {
                                resolver = new SimpleRotationResolver(new RotationFilesListByFilenameProvider(new StreamscapeLogRotationFilenameProvider()), path);
                            }
                            catch (IOException exception) {
                                String error = "Creating Rotation Resolver for log file '" + String.valueOf(path) + "' failed.";
                                Trace.logError(this, error);
                                try {
                                    holder.listener.onException(new IOException(error, exception));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            holder.executor = new FileTailerExecutor(new FileTailerInputStream(path, holder.source.getLinesOffset(), resolver));
                            holder.executor.addListener(holder.listener);
                            if (LogMonitorImpl.this.configuration.getMaxBlockSize() > 0) {
                                holder.executor.setMaxBlockSize(LogMonitorImpl.this.configuration.getMaxBlockSize());
                            }
                            if (LogMonitorImpl.this.configuration.getMaxSizeOnIteration() > 0) {
                                holder.executor.setMaxReadOnOneExecute(LogMonitorImpl.this.configuration.getMaxSizeOnIteration());
                            }
                        }
                    }
                    FileTailerExecutor executor = holder.executor;
                    if (executor == null) continue;
                    totalRead += (long)executor.execute();
                }
                if (totalRead != 0L) continue;
                try {
                    Thread.sleep(LogMonitorImpl.this.configuration.getInterval());
                }
                catch (InterruptedException exception) {
                    LogMonitorImpl.this.isStarted = false;
                    break;
                }
            }
            LogMonitorImpl.this.closeAllHolders();
        }
    }

    static class StreamscapeLogRotationFilenameProvider
    implements RotationFilenameProvider {
        StreamscapeLogRotationFilenameProvider() {
        }

        @Override
        public boolean isRotation(String filename, String rotatedFilename) {
            return ContainerLogger.isArchive(filename, rotatedFilename);
        }
    }
}

