/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.log.monitor;

import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.utils.Utils;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.log.monitor.LogMonitorConfiguration;
import com.streamscape.tools.log.monitor.LogMonitorImpl;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogMonitorFactory {
    public static final String OBJECT_FILE_NAME = "LogMonitor.xml";
    private String location;
    private String domain;
    private String nodeName;
    private transient XSerializer serializer;
    private static final long NEW_VERSION_TIMESTAMP;

    public LogMonitorFactory() {
    }

    public LogMonitorFactory(String location) {
        this.location = location;
    }

    public LogMonitorFactory(String location, String domain, String nodeName) {
        this(location);
        this.domain = domain;
        this.nodeName = nodeName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public synchronized LogMonitor create() throws FabricException {
        LogMonitor result = this.readObject();
        if (result == null) {
            result = new LogMonitorImpl();
        }
        ((LogMonitorImpl)result).setFactory(this);
        return result;
    }

    public boolean existsObject() {
        return new File(this.getObjectFilename()).exists();
    }

    private LogMonitor readObject() throws FabricException {
        File objectFile;
        if (this.location != null && (objectFile = new File(this.getObjectFilename())).exists()) {
            this.initSerializer();
            return this.validateObject((LogMonitor)Utils.readObject(objectFile.getAbsolutePath(), this.serializer));
        }
        return null;
    }

    private LogMonitor validateObject(LogMonitor monitor) throws FabricException {
        LogMonitorConfiguration configuration;
        boolean needUpdate = false;
        Date updateTime = monitor.getUpdateTimestamp();
        if ((updateTime == null || updateTime.getTime() < NEW_VERSION_TIMESTAMP) && (configuration = this.getConfiguration(monitor)) != null) {
            for (LogEventSource source : configuration.getSources()) {
                if (!Utils.equalsNullSafe(source.getSourceType(), "PROCESSOR_NODE")) continue;
                source.setSourceType(FabricNodeRole.TASK_NODE.name());
                needUpdate = true;
            }
        }
        if (needUpdate) {
            this.updateTimestamp(monitor);
            this.saveObject(monitor);
        }
        return monitor;
    }

    private LogMonitorConfiguration getConfiguration(LogMonitor monitor) throws FabricException {
        return ((LogMonitorImpl)monitor).doGetConfiguration();
    }

    private void updateTimestamp(LogMonitor monitor) throws FabricException {
        ((LogMonitorImpl)monitor).setUpdateTimestamp(System.currentTimeMillis());
    }

    public synchronized void saveObject(LogMonitor monitor) throws FabricException {
        if (this.location != null) {
            this.initSerializer();
            Utils.writeObject(monitor, this.getObjectFilename(), this.serializer);
        }
    }

    private String getObjectFilename() {
        return this.location + "/LogMonitor.xml";
    }

    private void initSerializer() throws FabricException {
        if (this.serializer == null) {
            XSerializerFactory factory = XSerializerFactory.getInstance();
            try {
                factory.alias(new SemanticType("LogMonitor", "com.streamscape.tools.log.monitor.LogMonitorImpl"));
                factory.alias(new SemanticType("LogEventForwarderConfiguration", "com.streamscape.tools.log.monitor.LogEventForwarderConfigurationImpl"));
            }
            catch (Exception exception) {
                throw new FabricException("Adding semantic types for LogMonitor failed.", exception);
            }
            this.serializer = factory.getDefaultSerializer();
        }
    }

    static {
        try {
            NEW_VERSION_TIMESTAMP = new SimpleDateFormat("dd/MM/yyyy").parse("20/04/2017").getTime();
        }
        catch (ParseException exception) {
            throw new RuntimeException(exception);
        }
    }
}

