/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.log.monitor;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.tools.log.monitor.LogEventSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LogMonitorConfiguration
extends CloneableDataObject {
    private static final int MB = 0x100000;
    private String name;
    private long interval = 1000L;
    private int maxBlockSize = 0xA00000;
    private int maxSizeOnIteration = 0xA00000;
    private Set<LogEventSource> sources;
    private Set<String> sourceTypes;
    private Map<String, String> properties;

    public LogMonitorConfiguration(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public void setMaxBlockSize(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public int getMaxSizeOnIteration() {
        return this.maxSizeOnIteration;
    }

    public void setMaxSizeOnIteration(int maxSizeOnIteration) {
        this.maxSizeOnIteration = maxSizeOnIteration;
    }

    public synchronized void addSource(LogEventSource source) {
        if (this.sources == null) {
            this.sources = new HashSet<LogEventSource>();
        } else {
            this.sources.remove(source);
        }
        this.sources.add(source);
    }

    public synchronized boolean removeSource(LogEventSource source) {
        return this.sources != null && this.sources.remove(source);
    }

    public synchronized boolean removeSource(String sourceType, String sourceName) {
        return this.sources != null && this.sources.remove(new LogEventSource(sourceType, sourceName));
    }

    public synchronized LogEventSource getSource(String sourceType, String sourceName) {
        if (this.sources != null) {
            LogEventSource model = new LogEventSource(sourceType, sourceName);
            return this.sources.stream().filter(source -> source.equals(model)).findFirst().orElse(null);
        }
        return null;
    }

    public synchronized boolean existsSource(LogEventSource source) {
        return this.sources != null && this.sources.contains(source);
    }

    public synchronized boolean existsSource(String sourceType, String sourceName) {
        return this.existsSource(new LogEventSource(sourceType, sourceName));
    }

    public synchronized boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public synchronized List<LogEventSource> getSources() {
        return this.sources != null ? new ArrayList<LogEventSource>(this.sources) : new ArrayList();
    }

    public synchronized void addExternalSourceType(String type) {
        if (this.sourceTypes == null) {
            this.sourceTypes = new HashSet<String>();
        }
        this.sourceTypes.add(type);
    }

    public synchronized boolean removeExternalSourceType(String type) {
        return this.sourceTypes != null && this.sourceTypes.remove(type);
    }

    public synchronized boolean existsExternalSourceType(String type) {
        return this.sourceTypes != null && this.sourceTypes.contains(type);
    }

    public synchronized boolean hasExternalSourceTypes() {
        return this.sourceTypes != null && !this.sourceTypes.isEmpty();
    }

    public synchronized List<String> getExternalSourceTypes() {
        return this.sourceTypes != null ? new ArrayList<String>(this.sourceTypes) : new ArrayList();
    }

    public synchronized void addProperty(String name, String value) {
        this.initProperties();
        this.properties.put(name, value);
    }

    public synchronized void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    public synchronized Map<String, String> getProperties() {
        return this.properties != null ? new HashMap<String, String>(this.properties) : new HashMap();
    }

    public synchronized boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    private void initProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
    }

    @Override
    public LogMonitorConfiguration clone() {
        LogMonitorConfiguration result = (LogMonitorConfiguration)super.clone();
        result.sources = this.sources != null ? this.sources.stream().map(LogEventSource::clone).collect(Collectors.toSet()) : null;
        result.properties = this.properties != null ? (HashMap)((HashMap)this.properties).clone() : null;
        return result;
    }
}

