/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.log.monitor;

import com.streamscape.sdo.CloneableDataObject;

public class LogEventSource
extends CloneableDataObject {
    private String sourceType;
    private String sourceName;
    private String logFilename;
    private int linesOffset = 0;
    private boolean isValid = true;
    private String error;
    private transient boolean isLogFileFound = true;

    public LogEventSource(String sourceType, String sourceName) {
        this.sourceType = sourceType;
        this.sourceName = sourceName;
    }

    public LogEventSource(String sourceType, String sourceName, String logFilename) {
        this(sourceType, sourceName);
        this.logFilename = logFilename;
    }

    public LogEventSource(String sourceType, String sourceName, int linesOffset) {
        this(sourceType, sourceName);
        this.linesOffset = linesOffset;
    }

    public LogEventSource(String sourceType, String sourceName, String logFilename, int linesOffset) {
        this(sourceType, sourceName, logFilename);
        this.linesOffset = linesOffset;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public int getLinesOffset() {
        return this.linesOffset;
    }

    public void setLinesOffset(int linesOffset) {
        this.linesOffset = linesOffset;
    }

    public boolean isValid() {
        return this.isValid;
    }

    void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String getError() {
        return this.error;
    }

    void setError(String error) {
        this.setValid(error == null);
        this.error = error;
    }

    public boolean isLogFileFound() {
        return this.isLogFileFound;
    }

    public void setLogFileFound(boolean isLogFileFound) {
        this.isLogFileFound = isLogFileFound;
    }

    public static String getFullName(String sourceType, String sourceName) {
        return sourceType + "." + sourceName;
    }

    public String getFullName() {
        return LogEventSource.getFullName(this.sourceType, this.sourceName);
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LogEventSource && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public LogEventSource clone() {
        return (LogEventSource)super.clone();
    }
}

