/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.log.monitor;

import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.tools.log.monitor.LogEventForwarderConfiguration;
import java.security.GeneralSecurityException;

class LogEventForwarderConfigurationImpl
extends CloneableDataObject
implements LogEventForwarderConfiguration {
    private String name;
    private String url;
    private String userName;
    private String password;
    private int reconnectAttempts = -1;
    private long reconnectInterval = 30L;
    private EventScope eventScope = EventScope.GLOBAL;
    private boolean noLocal = true;
    private static final byte[] KEY = new byte[]{40, -89, -67, 59, 113, -16, 36, 45, -43, 100, -92, 110, 86, -22, -127, 110};

    LogEventForwarderConfigurationImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean hasName() {
        return !StringUtils.isEmpty(this.name);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    String getPassword() {
        return this.decryptPassword();
    }

    @Override
    public void setPassword(String password) {
        this.password = LogEventForwarderConfigurationImpl.encryptPassword(password);
    }

    private static String encryptPassword(String password) {
        try {
            return password != null ? Base64.encodeBytes(CryptoUtils.encrypt(password.getBytes(), KEY)) : null;
        }
        catch (GeneralSecurityException ignored) {
            return null;
        }
    }

    private String decryptPassword() {
        try {
            return new String(CryptoUtils.decrypt(Base64.decode(this.password), KEY));
        }
        catch (GeneralSecurityException ignored) {
            return null;
        }
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    @Override
    public EventScope getEventScope() {
        return this.eventScope;
    }

    @Override
    public void setEventScope(EventScope eventScope) {
        this.eventScope = eventScope;
    }

    @Override
    public boolean isNoLocal() {
        return this.noLocal;
    }

    @Override
    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    @Override
    public LogEventForwarderConfigurationImpl clone() {
        return (LogEventForwarderConfigurationImpl)super.clone();
    }
}

