/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.log.monitor;

import com.streamscape.lib.evqueue.EventQueue;
import com.streamscape.lib.evqueue.EventQueueException;
import com.streamscape.lib.evqueue.FlowControlMode;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractLogEventForwarder;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.trace.LogSplitter;
import com.streamscape.sef.trace.TraceRecord;
import com.streamscape.tools.log.monitor.AbstractLogMonitorStringListener;
import com.streamscape.tools.log.monitor.LogEventForwarderConfiguration;
import com.streamscape.tools.log.monitor.LogEventForwarderConfigurationImpl;
import com.streamscape.tools.log.monitor.LogEventForwarderState;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.log.monitor.LogMonitorConfiguration;
import com.streamscape.tools.log.monitor.LogMonitorImpl;
import com.streamscape.tools.log.monitor.Utils;
import java.util.Date;
import java.util.List;

class LogEventForwarder
extends AbstractLogEventForwarder {
    private LogMonitorImpl monitor;
    private LogEventForwarderConfigurationImpl configuration;
    private volatile boolean isStarted = false;
    private long lastEventTime = -1L;

    LogEventForwarder(LogMonitorImpl monitor, LogEventForwarderConfigurationImpl configuration) throws FabricException {
        this.monitor = monitor;
        this.configuration = configuration;
        if (configuration.isNoLocal()) {
            if (StringUtils.isEmpty(configuration.getUrl())) {
                throw new FabricException("URL is not set in Log Event Forwarder.");
            }
            if (StringUtils.isEmpty(configuration.getUserName())) {
                throw new FabricException("User name is not set in Log Event Forwarder.");
            }
        }
    }

    LogEventForwarderConfiguration getConfiguration() {
        return this.configuration;
    }

    LogMonitorConfiguration getMonitorConfiguration(LogMonitorConfiguration monitorConfiguration) {
        if (this.connection != null) {
            try {
                AcknowledgementEvent ack;
                Object result;
                LogMonitor.logInfo("Obtaining configuration from target system...");
                DataEvent event = (DataEvent)EventDatagramFactory.getInstance().createEvent("event.LogMonitor.Configuration");
                event.setEventStringProperty("name", this.configuration.getName());
                if (monitorConfiguration != null) {
                    event.setData(monitorConfiguration);
                }
                if ((result = (ack = this.raiseRequest(event)).getData()) instanceof LogMonitorConfiguration) {
                    LogMonitor.logInfo("Configuration obtained from target system.");
                    return (LogMonitorConfiguration)result;
                }
                throw new FabricException("Wrong type of reply received for 'event.LogMonitor.Configuration' request.");
            }
            catch (Exception exception) {
                LogMonitorImpl.logException(exception, "Obtaining configuration from target system failed.", false);
            }
        }
        return null;
    }

    void setMonitorConfiguration(LogMonitorConfiguration monitorConfiguration) {
        if (this.connection != null) {
            try {
                LogMonitor.logInfo("Uploading configuration to target system...");
                DataEvent event = (DataEvent)EventDatagramFactory.getInstance().createEvent("event.LogMonitor.Configuration");
                event.setEventStringProperty("action", LogMonitor.ConfigurationAction.SET.name());
                event.setData(monitorConfiguration);
                this.raiseRequest(event);
                LogMonitor.logInfo("Configuration uploaded to target system.");
            }
            catch (Exception exception) {
                LogMonitorImpl.logException(exception, "Uploading configuration to target system failed.", false);
            }
        }
    }

    void start() throws FabricException {
        if (!this.isStarted) {
            this.openConnection();
            this.createConfigurationConsumer();
            this.initExternalEventQueue();
            this.isStarted = true;
        }
    }

    void stop() {
        if (this.isStarted) {
            this.destroyExternalEventQueue();
            this.dropConfigurationConsumer();
            this.closeConnection();
            this.isStarted = false;
        }
    }

    boolean isStarted() {
        return this.isStarted;
    }

    private void openConnection() throws FabricException {
        if (!StringUtils.isEmpty(this.configuration.getUrl())) {
            try {
                LogMonitor.logInfo("Opening connection to target system...");
                this.openConnection(this.configuration.getUrl(), this.configuration.getReconnectAttempts(), this.configuration.getReconnectInterval(), this.configuration.getUserName(), this.configuration.getPassword(), this.monitor.getDomain(), this.monitor.getNodeName());
                LogMonitor.logInfo("Connection to target system opened.");
            }
            catch (Exception exception) {
                throw new FabricException("Opening connection to target system failed.", exception);
            }
        }
    }

    @Override
    protected void closeConnection() {
        if (this.connection != null) {
            try {
                LogMonitor.logInfo("Closing connection to target system...");
                super.closeConnection();
                LogMonitor.logInfo("Connection to target system closed.");
            }
            catch (Exception exception) {
                this.monitor.setLastError(exception);
                LogMonitorImpl.logException(exception);
            }
        }
    }

    private void createConfigurationConsumer() throws FabricException {
        if (this.connection != null) {
            try {
                this.createConfigurationConsumer(this.configuration.getName(), new ConfigurationListener());
            }
            catch (Exception exception) {
                throw new FabricException("Creating configuration consumer failed.", exception);
            }
        }
    }

    @Override
    protected void dropConfigurationConsumer() {
        if (this.connection != null) {
            try {
                super.dropConfigurationConsumer();
            }
            catch (Exception exception) {
                LogMonitorImpl.logException(exception);
            }
        }
    }

    protected void raiseLogEvent(LogEventSource source, TraceRecord trace, EventScope eventScope) {
        MapEvent event = null;
        try {
            if (this.connection != null) {
                event = Utils.createEvent(source, trace);
                super.raiseLogEvent(event, eventScope);
            }
        }
        catch (Exception exception) {
            this.monitor.setLastError(exception);
        }
        try {
            if (!this.configuration.isNoLocal() && this.monitor.getLocalForwarder() != null) {
                if (event != null) {
                    this.monitor.getLocalForwarder().raiseLogEvent(event, eventScope);
                } else {
                    this.monitor.getLocalForwarder().raiseLogEvent(source, trace, eventScope);
                }
            }
        }
        catch (Exception exception) {
            this.monitor.setLastError(exception);
        }
        this.lastEventTime = System.currentTimeMillis();
    }

    Date getLastEventTime() {
        return this.lastEventTime > 0L ? new Date(this.lastEventTime) : null;
    }

    @Override
    protected LogEventForwarderState getState() {
        try {
            return super.getState();
        }
        catch (Exception ignored) {
            return LogEventForwarderState.DISCONNECTED;
        }
    }

    @Override
    protected void initExternalEventQueue() {
        this.externalEventQueue = new EventQueue<MapEvent>("FSYS:LogMonitor.ExternalEventQueue", event -> {
            try {
                if (this.connection != null) {
                    this.raiseLogEvent((MapEvent)event, this.configuration.getEventScope());
                    this.lastEventTime = System.currentTimeMillis();
                }
            }
            catch (Throwable exception) {
                this.monitor.setLastError(new FabricException("Forwarding external Log Event failed.", exception));
            }
        });
        this.externalEventQueue.setFlowControlMode(FlowControlMode.DROP);
        this.externalEventQueue.start();
    }

    void raiseExternalEvent(MapEvent event) {
        try {
            this.externalEventQueue.enqueue(event);
        }
        catch (EventQueueException eventQueueException) {
            // empty catch block
        }
    }

    class ConfigurationListener
    implements FabricEventListener {
        ConfigurationListener() {
        }

        @Override
        public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
            DataEvent configEvent = (DataEvent)event;
            try {
                LogMonitor.ConfigurationAction action = LogMonitor.ConfigurationAction.valueOf(configEvent.getEventStringProperty("action"));
                switch (action) {
                    case GET: {
                        this.raiseConfigurationAcknowledgement(event);
                        break;
                    }
                    case SET: {
                        LogMonitor.logInfo("Configuration received from target system. Updating...");
                        LogMonitorConfiguration configuration = (LogMonitorConfiguration)configEvent.getData();
                        LogEventForwarder.this.monitor.updateConfiguration(configuration);
                        LogMonitor.logInfo("Configuration updated.");
                        this.raiseConfigurationAcknowledgement(event);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                throw new FabricEventException("Processing 'event.LogMonitor.Configuration' event failed.", (Throwable)exception);
            }
        }

        private void raiseConfigurationAcknowledgement(ImmutableEventDatagram event) throws Exception {
            AcknowledgementEvent ack = EventDatagramFactory.getInstance().createAcknowledgement((EventDatagram)event, false);
            ack.setData(LogEventForwarder.this.monitor.doGetConfiguration());
            LogEventForwarder.this.raiseAcknowledgement(ack);
        }
    }

    class Listener
    extends AbstractLogMonitorStringListener {
        private LogSplitter splitter;

        Listener(LogEventSource source) {
            super(source);
            this.splitter = new LogSplitter();
        }

        @Override
        public void onNewBlock(String block, long offset) {
            super.onNewBlock(block, offset);
            List<TraceRecord> traces = this.splitter.split(block);
            this.splitter.split(null, traces);
            for (TraceRecord trace : traces) {
                LogEventForwarder.this.raiseLogEvent(this.source, trace, LogEventForwarder.this.configuration.getEventScope());
            }
        }
    }
}

