/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.log.monitor;

import com.streamscape.Trace;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.log.monitor.LogMonitorListener;

public abstract class AbstractLogMonitorListener
implements LogMonitorListener {
    protected LogEventSource source;

    protected AbstractLogMonitorListener(LogEventSource source) {
        this.source = source;
    }

    public LogEventSource getSource() {
        return this.source;
    }

    @Override
    public void onFileNotFound(String filename) {
        if (this.source.isLogFileFound()) {
            this.source.setLogFileFound(false);
            LogMonitor.logError("Log file '" + filename + "' not found (source '" + String.valueOf(this.source) + "').");
        }
    }

    @Override
    public void onFileFound(String filename) {
    }

    @Override
    public void onFileRotated(String oldFilename, String newFilename) {
        LogMonitor.logInfo("Log file '" + oldFilename + "' rotated to '" + newFilename + "' (source '" + String.valueOf(this.source) + "').");
    }

    @Override
    public void onFileTruncated(String filename) {
        LogMonitor.logError("Log file '" + filename + "' truncated (source '" + String.valueOf(this.source) + "').");
    }

    @Override
    public void onException(Exception exception) {
        Trace.logException(LogMonitor.class, exception, true);
    }

    protected void setLogFileFound() {
        if (!this.source.isLogFileFound()) {
            this.source.setLogFileFound(true);
            LogMonitor.logInfo("Log file '" + this.source.getLogFilename() + "' found (source '" + String.valueOf(this.source) + "').");
        }
    }
}

