/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.lexer;

import com.streamscape.lib.utils.CIString;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class TokensTree<T> {
    private Map<String, T> stringTokensCaseSentitive = new ConcurrentHashMap<String, T>();
    private Map<Character, T> characterTokensCaseSentitive = new ConcurrentHashMap<Character, T>();
    private Map<CIString, T> stringTokens = new ConcurrentHashMap<CIString, T>();
    private Map<Character, T> characterTokens = new ConcurrentHashMap<Character, T>();
    private int tokenMaxLength = 0;

    TokensTree() {
    }

    public void put(String key, T value, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            if (key.length() == 1) {
                this.characterTokensCaseSentitive.put(Character.valueOf(key.charAt(0)), value);
            } else {
                this.stringTokensCaseSentitive.put(key, value);
            }
        } else if (key.length() == 1) {
            this.characterTokens.put(Character.valueOf(Character.toLowerCase(key.charAt(0))), value);
        } else {
            this.stringTokens.put(new CIString(key), value);
        }
        if (this.tokenMaxLength < key.length()) {
            this.tokenMaxLength = key.length();
        }
    }

    public boolean containsKey(char key) {
        return this.get(key) != null;
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public T get(char key) {
        T result = this.characterTokensCaseSentitive.get(Character.valueOf(key));
        if (result == null) {
            result = Character.isLowerCase(key) ? this.characterTokens.get(Character.valueOf(key)) : this.characterTokens.get(Character.valueOf(Character.toLowerCase(key)));
        }
        return result;
    }

    public T get(String key) {
        if (key.length() > this.tokenMaxLength) {
            return null;
        }
        if (key.length() == 1) {
            return this.get(key.charAt(0));
        }
        T result = this.stringTokensCaseSentitive.get(key);
        if (result == null) {
            result = this.stringTokens.get(new CIString(key));
        }
        return result;
    }

    public int getTokenMaxLength() {
        return this.tokenMaxLength;
    }
}

