/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.lexer;

import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.TokenType;

public class Token<T extends TokenType> {
    private CommonTokenType commonType;
    private T customType;
    private String value;

    Token(TokenType tokenType) {
        this(tokenType, tokenType.getValue());
    }

    Token(TokenType tokenType, String value) {
        if (tokenType instanceof CommonTokenType) {
            this.commonType = (CommonTokenType)tokenType;
        } else {
            this.customType = tokenType;
        }
        this.value = value;
    }

    public boolean isCommon() {
        return this.commonType != null;
    }

    public boolean isCustom() {
        return this.customType != null;
    }

    public boolean isDelimiter() {
        return this.isCommon() ? this.commonType.isDelimiter() : this.customType.isDelimiter();
    }

    public CommonTokenType getCommonType() {
        return this.commonType;
    }

    public T getCustomType() {
        return this.customType;
    }

    public String getTokenName() {
        return this.isCommon() ? this.commonType.name() : ((Enum)this.customType).name();
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getTokenName() + ":" + this.value;
    }
}

